---
generated_at: 2026-02-01 21:50:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：12-レジスタビュー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  - 全項目が根拠ありのため、優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `IOHandlerCursesGUI.cpp` 行5969-6015 - RegistersWindowDelegateクラス定義
- E-02: `IOHandlerCursesGUI.cpp` 行5971-5972 - コンストラクタ実装
- E-03: `IOHandlerCursesGUI.cpp` 行5976-5978 - WindowDelegateGetHelpText()
- E-04: `IOHandlerCursesGUI.cpp` 行5980-6010 - WindowDelegateDraw()描画処理
- E-05: `IOHandlerCursesGUI.cpp` 行5986-5997 - スタックID変更時のレジスタリスト更新
- E-06: `IOHandlerCursesGUI.cpp` 行5989-5996 - RegisterContextからのレジスタセット取得
- E-07: `IOHandlerCursesGUI.cpp` 行5999-6007 - フレームがない場合の処理
- E-08: `IOHandlerCursesGUI.cpp` 行5540-5548 - ValueObjectListDelegate基底クラス
- E-09: `IOHandlerCursesGUI.cpp` 行5597-5626 - キーボードショートカットヘルプ定義
- E-10: `IOHandlerCursesGUI.cpp` 行5628-5650 - WindowDelegateHandleChar()
- E-11: `IOHandlerCursesGUI.cpp` 行5737-5769 - FormatForChar()メソッド
- E-12: `IOHandlerCursesGUI.cpp` 行5644-5650 - フォーマットキー処理
- E-13: `IOHandlerCursesGUI.cpp` 行5652-5655 - tキーによる型名トグル
- E-14: `IOHandlerCursesGUI.cpp` 行5680-5714 - ナビゲーションキー処理
- E-15: `IOHandlerCursesGUI.cpp` 行5716-5718 - hキーによるヘルプ表示
- E-16: `IOHandlerCursesGUI.cpp` 行6648-6677 - eMenuID_ViewRegistersメニューハンドラ
- E-17: `IOHandlerCursesGUI.cpp` 行6673-6676 - ウィンドウ作成とデリゲート設定
- E-18: `画面一覧.csv` 行13 - レジスタビューの画面定義
- E-19: `画面機能マッピング.csv` 行22-23 - 機能マッピング情報
- E-20: `画面遷移図.md` 行59-60 - 画面遷移情報（F5 View > Registers）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | RegistersWindowDelegateはValueObjectListDelegateを継承 | E-01, E-08 | ○ |
| C-02 | コンストラクタでDebugger参照を保持 | E-02 | ○ |
| C-03 | ヘルプテキストは「Register window keyboard shortcuts:」 | E-03 | ○ |
| C-04 | WindowDelegateDraw()で描画処理を実行 | E-04 | ○ |
| C-05 | スタックIDが変わった場合のみレジスタリストを更新 | E-05 | ○ |
| C-06 | RegisterContextからGetRegisterSetCount()でセット数を取得 | E-06 | ○ |
| C-07 | ValueObjectRegisterSet::Create()でレジスタセットを作成 | E-06 | ○ |
| C-08 | プロセス実行中はtrueを返して更新をスキップ | E-07 | ○ |
| C-09 | プロセス終了時は空のリストで更新 | E-07 | ○ |
| C-10 | xキーで16進数（小文字）フォーマット | E-11 | ○ |
| C-11 | Xキーで16進数（大文字）フォーマット | E-11 | ○ |
| C-12 | oキーで8進数フォーマット | E-11 | ○ |
| C-13 | dキーで符号付き整数フォーマット | E-11 | ○ |
| C-14 | fキーで浮動小数点フォーマット | E-11 | ○ |
| C-15 | フォーマットキー押下でvalobj_sp->SetFormat()を呼び出し | E-12 | ○ |
| C-16 | tキーでg_options.show_typesをトグル | E-13 | ○ |
| C-17 | 上下矢印キーでm_selected_row_idxを変更 | E-14 | ○ |
| C-18 | 右矢印キーでExpand()を呼び出し | E-14 | ○ |
| C-19 | 左矢印キーでUnexpand()または親選択 | E-14 | ○ |
| C-20 | スペースキーで展開/折りたたみトグル | E-14 | ○ |
| C-21 | hキーでCreateHelpSubwindow()を呼び出し | E-15 | ○ |
| C-22 | F5 > View > Registersでトグル動作 | E-16, E-20 | ○ |
| C-23 | 新規ウィンドウ作成時にRegisterWindowDelegateを設定 | E-17 | ○ |
| C-24 | 画面一覧でサブビューカテゴリとして定義 | E-18 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [x] RegistersWindowDelegateクラスの継承関係が正確か
- [x] フォーマット変更キーとFormatの対応が正確か
- [x] キーボードショートカット一覧が網羅されているか
- [x] 描画処理のフロー（スタックID変更時の更新）が正確か
- [x] 画面遷移（F5メニューからのトグル動作）が正確か
