---
generated_at: 2026-02-01 21:55:00
metrics:
  claims_total: 26
  claims_with_evidence: 26
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：13-ブレークポイントビュー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：26 / 26、根拠なし：0
- 優先レビュー（高）
  - 全項目が根拠ありのため、優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `IOHandlerCursesGUI.cpp` 行5495-5538 - BreakpointsTreeDelegateクラス定義
- E-02: `IOHandlerCursesGUI.cpp` 行5497-5498 - BreakpointsTreeDelegateコンストラクタ
- E-03: `IOHandlerCursesGUI.cpp` 行5502-5508 - TreeDelegateShouldDraw()
- E-04: `IOHandlerCursesGUI.cpp` 行5510-5512 - TreeDelegateDrawTreeItem()で「Breakpoints」表示
- E-05: `IOHandlerCursesGUI.cpp` 行5514-5528 - TreeDelegateGenerateChildren()
- E-06: `IOHandlerCursesGUI.cpp` 行5517-5519 - BreakpointListの取得とミューテックスロック
- E-07: `IOHandlerCursesGUI.cpp` 行5521-5525 - BreakpointTreeDelegateによる子項目生成
- E-08: `IOHandlerCursesGUI.cpp` 行5533 - TreeDelegateExpandRootByDefault()がtrueを返す
- E-09: `IOHandlerCursesGUI.cpp` 行5449-5493 - BreakpointTreeDelegateクラス定義
- E-10: `IOHandlerCursesGUI.cpp` 行5457-5461 - GetBreakpoint()
- E-11: `IOHandlerCursesGUI.cpp` 行5463-5470 - TreeDelegateDrawTreeItem()でID/resolver/filter表示
- E-12: `IOHandlerCursesGUI.cpp` 行5472-5484 - TreeDelegateGenerateChildren()でロケーション生成
- E-13: `IOHandlerCursesGUI.cpp` 行5308-5447 - BreakpointLocationTreeDelegateクラス定義
- E-14: `IOHandlerCursesGUI.cpp` 行5321-5324 - GetBreakpointLocation()
- E-15: `IOHandlerCursesGUI.cpp` 行5326-5336 - TreeDelegateDrawTreeItem()でロケーション表示
- E-16: `IOHandlerCursesGUI.cpp` 行5338-5427 - ComputeDetailsList()
- E-17: `IOHandlerCursesGUI.cpp` 行5345-5351 - module情報の取得
- E-18: `IOHandlerCursesGUI.cpp` 行5353-5373 - compile unit, function, location情報
- E-19: `IOHandlerCursesGUI.cpp` 行5376-5385 - symbol情報
- E-20: `IOHandlerCursesGUI.cpp` 行5390-5394 - address情報
- E-21: `IOHandlerCursesGUI.cpp` 行5395-5408 - indirect target情報
- E-22: `IOHandlerCursesGUI.cpp` 行5411-5419 - resolved, hardware情報
- E-23: `IOHandlerCursesGUI.cpp` 行5421-5424 - hit count情報
- E-24: `IOHandlerCursesGUI.cpp` 行6682-6712 - eMenuID_ViewBreakpointsメニューハンドラ
- E-25: `IOHandlerCursesGUI.cpp` 行6700-6701 - HorizontalSplitPercentage(0.70)
- E-26: `IOHandlerCursesGUI.cpp` 行6706-6709 - BreakpointsTreeDelegateの生成とTreeWindowDelegateへの設定
- E-27: `画面一覧.csv` 行14 - ブレークポイントビューの画面定義
- E-28: `画面機能マッピング.csv` 行24-25 - 機能マッピング情報
- E-29: `画面遷移図.md` 行62-63 - 画面遷移情報（F5 View > Breakpoints）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BreakpointsTreeDelegateはTreeDelegateを継承 | E-01 | ○ |
| C-02 | TreeDelegateShouldDraw()でターゲットの存在を確認 | E-03 | ○ |
| C-03 | TreeDelegateDrawTreeItem()で「Breakpoints」を表示 | E-04 | ○ |
| C-04 | BreakpointListのミューテックスをロックして子項目生成 | E-06 | ○ |
| C-05 | BreakpointTreeDelegateを使用して各ブレークポイントを表示 | E-07, E-09 | ○ |
| C-06 | ルートノードはデフォルトで展開 | E-08 | ○ |
| C-07 | BreakpointTreeDelegateでID:resolver filterの形式で表示 | E-11 | ○ |
| C-08 | BreakpointLocationTreeDelegateで各ロケーションを表示 | E-12, E-13 | ○ |
| C-09 | ロケーション表示形式は{bp_id}.{loc_id}: {address} | E-15 | ○ |
| C-10 | ComputeDetailsList()で詳細情報リストを計算 | E-16 | ○ |
| C-11 | module情報を詳細に含む | E-17 | ○ |
| C-12 | compile unit, function, location情報を詳細に含む | E-18 | ○ |
| C-13 | symbol情報を詳細に含む | E-19 | ○ |
| C-14 | address情報を詳細に含む | E-20 | ○ |
| C-15 | indirect target情報を詳細に含む | E-21 | ○ |
| C-16 | resolved, hardware情報を詳細に含む | E-22 | ○ |
| C-17 | hit count情報を詳細に含む | E-23 | ○ |
| C-18 | F5 > View > Breakpointsでトグル動作 | E-24, E-29 | ○ |
| C-19 | HorizontalSplitPercentage(0.70)でThreadsウィンドウを分割 | E-25 | ○ |
| C-20 | TreeWindowDelegateでBreakpointsTreeDelegateをラップ | E-26 | ○ |
| C-21 | 画面一覧でサブビューカテゴリとして定義 | E-27 | ○ |
| C-22 | 機能No.8（LLDB）に関連付けられている | E-28 | ○ |
| C-23 | 3層の階層構造で表示 | E-01, E-09, E-13 | ○ |
| C-24 | TextTreeDelegateで詳細テキストを表示 | E-16 | ○ |
| C-25 | ブレークポイントがない場合は空のツリーを表示 | E-05 | ○ |
| C-26 | ターゲット未選択時は描画をスキップ | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [x] 3層のTreeDelegate階層構造が正確に記述されているか
- [x] ComputeDetailsList()で生成される詳細情報が網羅されているか
- [x] 画面遷移（F5メニューからのトグル動作）が正確か
- [x] レイアウト（HorizontalSplitPercentage 0.70）が正確か
- [x] 表示形式のフォーマットが正確か
