---
generated_at: 2026-02-01 22:00:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：14-検索ウィンドウ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - 全項目が根拠ありのため、優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `IOHandlerCursesGUI.cpp` 行3650-3670 - SearcherDelegateインターフェース定義
- E-02: `IOHandlerCursesGUI.cpp` 行3656 - GetNumberOfMatches()
- E-03: `IOHandlerCursesGUI.cpp` 行3659 - GetMatchTextAtIndex()
- E-04: `IOHandlerCursesGUI.cpp` 行3663 - UpdateMatches()
- E-05: `IOHandlerCursesGUI.cpp` 行3667 - ExecuteCallback()
- E-06: `IOHandlerCursesGUI.cpp` 行3672-3818 - SearcherWindowDelegateクラス定義
- E-07: `IOHandlerCursesGUI.cpp` 行3674-3677 - SearcherWindowDelegateコンストラクタ
- E-08: `IOHandlerCursesGUI.cpp` 行3679-3693 - ウィンドウレイアウトのコメント
- E-09: `IOHandlerCursesGUI.cpp` 行3697-3704 - GetNumberOfVisibleMatches()
- E-10: `IOHandlerCursesGUI.cpp` 行3706-3717 - UpdateScrolling()
- E-11: `IOHandlerCursesGUI.cpp` 行3719-3736 - DrawMatches()
- E-12: `IOHandlerCursesGUI.cpp` 行3738-3748 - DrawContent()
- E-13: `IOHandlerCursesGUI.cpp` 行3750-3761 - WindowDelegateDraw()
- E-14: `IOHandlerCursesGUI.cpp` 行3753 - DrawTitleBox()で「Press Esc to Cancel」表示
- E-15: `IOHandlerCursesGUI.cpp` 行3763-3771 - SelectNext()/SelectPrevious()
- E-16: `IOHandlerCursesGUI.cpp` 行3773-3776 - ExecuteCallback()
- E-17: `IOHandlerCursesGUI.cpp` 行3778-3781 - UpdateMatches()
- E-18: `IOHandlerCursesGUI.cpp` 行3783-3809 - WindowDelegateHandleChar()
- E-19: `IOHandlerCursesGUI.cpp` 行3827-3863 - CommonCompletionSearcherDelegateクラス定義
- E-20: `IOHandlerCursesGUI.cpp` 行3842-3849 - CommandCompletions::InvokeCommonCompletionCallbacks()の使用
- E-21: `画面一覧.csv` 行15 - 検索ウィンドウの画面定義
- E-22: `画面機能マッピング.csv` 行26 - 機能マッピング情報
- E-23: `画面遷移図.md` 行49-50 - プロセスアタッチフォームからの検索ダイアログ遷移

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SearcherWindowDelegateはWindowDelegateを継承 | E-06 | ○ |
| C-02 | SearcherDelegateインターフェースを使用 | E-01 | ○ |
| C-03 | GetNumberOfMatches()でマッチ数を取得 | E-02 | ○ |
| C-04 | GetMatchTextAtIndex()でマッチテキストを取得 | E-03 | ○ |
| C-05 | UpdateMatches()で検索結果を更新 | E-04, E-17 | ○ |
| C-06 | ExecuteCallback()でコールバック実行 | E-05, E-16 | ○ |
| C-07 | コンストラクタでSearcherDelegateSPとTextFieldDelegateを初期化 | E-07 | ○ |
| C-08 | ウィンドウは1文字パディングで囲まれる | E-08 | ○ |
| C-09 | フッターに「Press Esc to Cancel」を表示 | E-14 | ○ |
| C-10 | GetNumberOfVisibleMatches()で可視マッチ数を計算 | E-09 | ○ |
| C-11 | UpdateScrolling()で選択項目の可視性を確保 | E-10 | ○ |
| C-12 | DrawMatches()でマッチリストを描画 | E-11 | ○ |
| C-13 | DrawContent()でテキストフィールドとマッチリストを描画 | E-12 | ○ |
| C-14 | WindowDelegateDraw()でウィンドウ全体を描画 | E-13 | ○ |
| C-15 | SelectNext()/SelectPrevious()で候補選択 | E-15 | ○ |
| C-16 | Enter/Tab/上下矢印/ESCのキー処理 | E-18 | ○ |
| C-17 | CommonCompletionSearcherDelegateがCommandCompletionsを使用 | E-19, E-20 | ○ |
| C-18 | 画面一覧で検索機能カテゴリとして定義 | E-21 | ○ |
| C-19 | 機能No.8（LLDB）に関連付けられている | E-22 | ○ |
| C-20 | プロセスアタッチフォームから検索ダイアログに遷移 | E-23 | ○ |
| C-21 | m_selected_matchを0にリセット（候補更新時） | E-17 | ○ |
| C-22 | RemoveSubWindow()でウィンドウを閉じる | E-16, E-18 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [x] SearcherWindowDelegateのキー入力処理が網羅されているか
- [x] SearcherDelegateインターフェースの抽象メソッドが正確か
- [x] CommonCompletionSearcherDelegateの実装が正確か
- [x] ウィンドウレイアウト（コメントに記載のASCII図）が正確か
- [x] 画面遷移（プロセスアタッチフォームからの呼び出し）が正確か
