---
generated_at: 2026-02-01 10:05:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：2-メニューバー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. 特になし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `lldb/source/Core/IOHandlerCursesGUI.cpp` 3876-3970行（Menuクラス定義）
- E-02: `lldb/source/Core/IOHandlerCursesGUI.cpp` 3878行（Menu::Type列挙型）
- E-03: `lldb/source/Core/IOHandlerCursesGUI.cpp` 3869-3874行（MenuDelegateインターフェース）
- E-04: `lldb/source/Core/IOHandlerCursesGUI.cpp` 3972-3996行（Menuコンストラクタ）
- E-05: `lldb/source/Core/IOHandlerCursesGUI.cpp` 4023-4075行（DrawMenuTitle）
- E-06: `lldb/source/Core/IOHandlerCursesGUI.cpp` 6314-6346行（メニューID列挙型）
- E-07: `lldb/source/Core/IOHandlerCursesGUI.cpp` 6405-6511行（MenuDelegateAction実装）
- E-08: `docs/code-to-docs/画面一覧/画面一覧.csv` 2行目（メニューバー情報）
- E-09: `docs/code-to-docs/画面遷移図.md`（メニュー構造図）
- E-10: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 2行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MenuクラスはWindowDelegateを継承している | E-01 | ○ |
| C-02 | Menu::Typeには Invalid、Bar、Item、Separator がある | E-02 | ○ |
| C-03 | F1〜F6キーで対応するメニューが開く | E-06, E-09 | ○ |
| C-04 | メニューはLLDB、Target、Process、Thread、View、Helpの6つ | E-06, E-09 | ○ |
| C-05 | サブメニューはm_submenusベクタで管理される | E-01 | ○ |
| C-06 | m_parentで親メニューを参照する | E-01 | ○ |
| C-07 | セパレータは横線で描画される | E-05 | ○ |
| C-08 | ショートカットキー文字は下線付きで強調表示 | E-05 | ○ |
| C-09 | 選択中項目は反転表示（A_REVERSE） | E-05 | ○ |
| C-10 | Menu::Action()がMenuDelegateActionに処理を委譲 | E-01, E-07 | ○ |
| C-11 | TargetCreateでTargetCreateFormDelegateが生成される | E-07 | ○ |
| C-12 | ProcessAttachでProcessAttachFormDelegateが生成される | E-07 | ○ |
| C-13 | ProcessLaunchでProcessLaunchFormDelegateが生成される | E-07 | ○ |
| C-14 | メニューアイテムコンストラクタでname、key_name、identifierを設定 | E-04 | ○ |
| C-15 | 名前がない場合はType::Separatorになる | E-04 | ○ |
| C-16 | F1-F6キーでアクセス可能と画面一覧に記載 | E-08 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全ての主張がソースコードまたは設計ドキュメントから確認できる。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] Menuクラスの定義を確認（3876行〜）
- [ ] メニューID列挙型が全て正しいか確認（6314行〜）
- [ ] DrawMenuTitleの描画ロジックを確認（4023行〜）
- [ ] 画面遷移図のメニュー構造との整合性を確認
