---
generated_at: 2026-02-01 10:10:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：3-ソースビュー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  1. 特になし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `lldb/source/Core/IOHandlerCursesGUI.cpp` 6785-6824行（SourceFileWindowDelegateクラス定義、キーヘルプ配列）
- E-02: `lldb/source/Core/IOHandlerCursesGUI.cpp` 6826-6965行（WindowDelegateDraw前半）
- E-03: `lldb/source/Core/IOHandlerCursesGUI.cpp` 6967-7084行（WindowDelegateDraw後半）
- E-04: `lldb/source/Core/IOHandlerCursesGUI.cpp` 7261-7451行（WindowDelegateHandleChar）
- E-05: `lldb/source/Core/IOHandlerCursesGUI.cpp` 7453-7500行（ToggleBreakpointOnSelectedLine）
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv` 3行目（ソースビュー情報）
- E-07: `docs/code-to-docs/画面遷移図.md`（画面遷移情報）
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 3-6行目（機能マッピング）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SourceFileWindowDelegateクラスで実装されている | E-01, E-06 | ○ |
| C-02 | 上下矢印キーで行選択を変更できる | E-01, E-04 | ○ |
| C-03 | 左右矢印キーで水平スクロールできる | E-01, E-04 | ○ |
| C-04 | Page Up/Downでページスクロールできる | E-01, E-04 | ○ |
| C-05 | bキーでブレークポイントをトグルできる | E-01, E-04, E-05, E-08 | ○ |
| C-06 | cキーでプロセスを続行できる | E-01, E-04, E-08 | ○ |
| C-07 | n/Nキーでステップオーバーできる | E-01, E-04, E-08 | ○ |
| C-08 | s/Sキーでステップインできる | E-01, E-04, E-08 | ○ |
| C-09 | fキーでステップアウトできる | E-01, E-04 | ○ |
| C-10 | u/dキーでフレーム移動できる | E-01, E-04 | ○ |
| C-11 | Enterキーでワンショットブレークポイント実行できる | E-01, E-04 | ○ |
| C-12 | PC行はダイヤモンド記号でマークされる | E-03 | ○ |
| C-13 | ブレークポイント行はBlackOnWhiteで強調表示 | E-03 | ○ |
| C-14 | 選択行は反転表示（A_REVERSE） | E-03 | ○ |
| C-15 | 停止理由はWhiteOnBlue背景で表示 | E-03 | ○ |
| C-16 | ソースファイルがない場合はディスアセンブリ表示に切り替わる | E-02 | ○ |
| C-17 | タイトルは"Sources"と表示される | E-03 | ○ |
| C-18 | モジュール名と関数名が反転表示で表示される | E-03 | ○ |
| C-19 | ExecutionContextからProcess/Thread/Frame状態を取得 | E-02 | ○ |
| C-20 | ToggleBreakpointOnSelectedLineで既存ブレークポイントを検索・削除 | E-05 | ○ |
| C-21 | ToggleBreakpointOnSelectedLineで新規ブレークポイントを作成 | E-05 | ○ |
| C-22 | 機能No.8 LLDBが主機能および補助機能として関連 | E-08 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全ての主張がソースコードまたは設計ドキュメントから確認できる。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] SourceFileWindowDelegateクラスの定義を確認（6785行〜）
- [ ] WindowDelegateDrawの描画ロジックを確認（6826行〜）
- [ ] WindowDelegateHandleCharのキー処理を確認（7261行〜）
- [ ] ToggleBreakpointOnSelectedLineの実装を確認（7453行〜）
- [ ] 画面遷移図との整合性を確認
