---
generated_at: 2026-02-01 10:15:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：4-変数ビュー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. 特になし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `lldb/source/Core/IOHandlerCursesGUI.cpp` 5540-5620行（ValueObjectListDelegateクラス定義）
- E-02: `lldb/source/Core/IOHandlerCursesGUI.cpp` 5902-5967行（FrameVariablesWindowDelegateクラス定義）
- E-03: `lldb/source/Core/IOHandlerCursesGUI.cpp` 5913-5962行（WindowDelegateDraw実装）
- E-04: `lldb/source/Core/IOHandlerCursesGUI.cpp` 5597-5620行（キーヘルプ配列）
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` 4行目（変数ビュー情報）
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 7-8行目（機能マッピング）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | FrameVariablesWindowDelegateクラスで実装されている | E-02, E-05 | ○ |
| C-02 | ValueObjectListDelegateを継承している | E-02 | ○ |
| C-03 | 上下矢印キーで選択変更できる | E-04 | ○ |
| C-04 | 左右矢印キーで展開/折りたたみできる | E-04 | ○ |
| C-05 | Page Up/Downでページスクロールできる | E-04 | ○ |
| C-06 | xキーで16進数表示（小文字）できる | E-04 | ○ |
| C-07 | Xキーで16進数表示（大文字）できる | E-04 | ○ |
| C-08 | dキーで符号付き整数表示できる | E-04 | ○ |
| C-09 | uキーで符号なし整数表示できる | E-04 | ○ |
| C-10 | oキーで8進数表示できる | E-04 | ○ |
| C-11 | bキーで2進数表示できる | E-04 | ○ |
| C-12 | cキーで文字表示できる | E-04 | ○ |
| C-13 | fキーで浮動小数点表示できる | E-04 | ○ |
| C-14 | プロセス実行中は更新しない | E-03 | ○ |
| C-15 | フレームブロックが変わった場合のみ変数リストを更新 | E-03 | ○ |
| C-16 | eDynamicDontRunTargetで動的型を使用しない | E-03 | ○ |
| C-17 | SyntheticValueがある場合はそれを優先表示 | E-03 | ○ |
| C-18 | 機能No.8 LLDBが主機能および補助機能として関連 | E-06 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全ての主張がソースコードまたは設計ドキュメントから確認できる。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] FrameVariablesWindowDelegateクラスの定義を確認（5902行〜）
- [ ] ValueObjectListDelegateのキーヘルプ配列を確認（5597行〜）
- [ ] WindowDelegateDrawの変数取得ロジックを確認（5913行〜）
- [ ] 画面機能マッピングとの整合性を確認
