---
generated_at: 2026-02-01 10:20:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：5-スレッドビュー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. 特になし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `lldb/source/Core/IOHandlerCursesGUI.cpp` 5190-5240行（ThreadsTreeDelegateクラス定義）
- E-02: `lldb/source/Core/IOHandlerCursesGUI.cpp` 5206-5228行（描画メソッド）
- E-03: `lldb/source/Core/IOHandlerCursesGUI.cpp` 5230-5240行（子要素生成メソッド）
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` 5行目（スレッドビュー情報）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 9-10行目（機能マッピング）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ThreadsTreeDelegateクラスで実装されている | E-01, E-04 | ○ |
| C-02 | TreeDelegateを継承している | E-01 | ○ |
| C-03 | 上下矢印キーで選択変更できる | E-01 | ○ |
| C-04 | 左右矢印キーで展開/折りたたみできる | E-01 | ○ |
| C-05 | プロセス実行中は描画をスキップする | E-02 | ○ |
| C-06 | stop_idが変わった場合のみスレッドリストを更新 | E-03 | ○ |
| C-07 | FormatEntityでプロセス情報をフォーマット | E-01, E-02 | ○ |
| C-08 | "process ${process.id}{, name = ${process.name}}" 形式を使用 | E-01 | ○ |
| C-09 | プロセス内の全スレッドを一覧表示 | E-03, E-05 | ○ |
| C-10 | 各スレッドのスタックフレームを確認できる | E-05 | ○ |
| C-11 | Enterキーでスレッド/フレームをアクティブに設定 | E-01 | ○ |
| C-12 | Page Up/Downでページスクロールできる | E-01 | ○ |
| C-13 | メインウィンドウの右側に表示される | E-04 | ○ |
| C-14 | 機能No.8 LLDBが主機能および補助機能として関連 | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全ての主張がソースコードまたは設計ドキュメントから確認できる。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] ThreadsTreeDelegateクラスの定義を確認（5190行〜）
- [ ] TreeDelegateShouldDrawの状態チェックを確認（5206行〜）
- [ ] TreeDelegateGenerateChildrenのスレッド取得を確認（5230行〜）
- [ ] 画面機能マッピングとの整合性を確認
