---
generated_at: 2026-02-01 10:25:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：6-ステータスバー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  1. 特になし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `lldb/source/Core/IOHandlerCursesGUI.cpp` 6731-6782行（StatusBarWindowDelegateクラス定義）
- E-02: `lldb/source/Core/IOHandlerCursesGUI.cpp` 6739-6777行（WindowDelegateDraw実装）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` 6行目（ステータスバー情報）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 11行目（機能マッピング）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | StatusBarWindowDelegateクラスで実装されている | E-01, E-03 | ○ |
| C-02 | メインウィンドウの最下部に表示される | E-03 | ○ |
| C-03 | プロセスIDと状態を表示する | E-02 | ○ |
| C-04 | スレッドIDを表示する | E-02 | ○ |
| C-05 | フレーム番号とPCを表示する | E-02 | ○ |
| C-06 | 背景色はBlackOnWhite | E-02 | ○ |
| C-07 | "Thread: ${thread.id%tid}" フォーマットを使用 | E-01 | ○ |
| C-08 | プロセス終了時は終了ステータスを表示 | E-02 | ○ |
| C-09 | スレッド情報は40カラム目に表示 | E-02 | ○ |
| C-10 | フレーム情報は60カラム目に表示 | E-02 | ○ |
| C-11 | 情報表示専用でユーザー操作は受け付けない | E-01 | ○ |
| C-12 | 機能No.8 LLDBが主機能として関連 | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全ての主張がソースコードまたは設計ドキュメントから確認できる。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] StatusBarWindowDelegateクラスの定義を確認（6731行〜）
- [ ] WindowDelegateDrawの表示処理を確認（6739行〜）
- [ ] フォーマット文字列の確認（6734行）
- [ ] 画面機能マッピングとの整合性を確認
