---
generated_at: 2026-02-01 10:30:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：7-ヘルプダイアログ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. 特になし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `lldb/source/Core/IOHandlerCursesGUI.cpp` 332-349行（HelpDialogDelegateクラス宣言）
- E-02: `lldb/source/Core/IOHandlerCursesGUI.cpp` 284-287行（KeyHelp構造体定義）
- E-03: `lldb/source/Core/IOHandlerCursesGUI.cpp` 6218-6233行（コンストラクタ実装）
- E-04: `lldb/source/Core/IOHandlerCursesGUI.cpp` 6237-6259行（WindowDelegateDraw実装）
- E-05: `lldb/source/Core/IOHandlerCursesGUI.cpp` 6261-6310行（WindowDelegateHandleChar実装）
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv` 7行目（ヘルプダイアログ情報）
- E-07: `docs/code-to-docs/画面遷移図.md`（画面遷移情報）
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 12行目（機能マッピング）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HelpDialogDelegateクラスで実装されている | E-01, E-06 | ○ |
| C-02 | WindowDelegateを継承している | E-01 | ○ |
| C-03 | hキーで表示される | E-06, E-07 | ○ |
| C-04 | 上下矢印キーでスクロールできる | E-05 | ○ |
| C-05 | Page Up/Downでページスクロールできる | E-05 | ○ |
| C-06 | スクロール不要時は任意のキーで閉じる | E-04, E-05 | ○ |
| C-07 | "Press any key to exit" と表示される（スクロール不要時） | E-04 | ○ |
| C-08 | "Use arrows to scroll, any other key to exit" と表示される（スクロール可能時） | E-04 | ○ |
| C-09 | ヘルプテキストは行に分割して保持 | E-03 | ○ |
| C-10 | "{キー名} - {説明}" 形式でフォーマット | E-03 | ○ |
| C-11 | CursesKeyToCStringでキーコードを文字列に変換 | E-03 | ○ |
| C-12 | m_first_visible_lineでスクロール位置を管理 | E-01, E-05 | ○ |
| C-13 | ESCキーでダイアログを閉じる | E-07 | ○ |
| C-14 | 機能No.8 LLDBが主機能として関連 | E-08 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全ての主張がソースコードまたは設計ドキュメントから確認できる。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] HelpDialogDelegateクラスの宣言を確認（332行〜）
- [ ] コンストラクタのテキスト処理を確認（6218行〜）
- [ ] WindowDelegateDrawの描画処理を確認（6237行〜）
- [ ] WindowDelegateHandleCharのキー処理を確認（6261行〜）
- [ ] 画面遷移図との整合性を確認
