---
generated_at: 2026-02-01 10:40:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：9-プロセスアタッチフォーム

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. 特になし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `lldb/source/Core/IOHandlerCursesGUI.cpp` 2909-2988行（ProcessAttachFormDelegateクラス定義）
- E-02: `lldb/source/Core/IOHandlerCursesGUI.cpp` 2910-2928行（コンストラクタ）
- E-03: `lldb/source/Core/IOHandlerCursesGUI.cpp` 2932-2951行（UpdateFieldsVisibility）
- E-04: `lldb/source/Core/IOHandlerCursesGUI.cpp` 2967-2988行（StopRunningProcess）
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` 9行目（プロセスアタッチフォーム情報）
- E-06: `docs/code-to-docs/画面遷移図.md`（画面遷移情報）
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 15-16行目（機能マッピング）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ProcessAttachFormDelegateクラスで実装されている | E-01, E-05 | ○ |
| C-02 | FormDelegateを継承している | E-01 | ○ |
| C-03 | F3 > Process > Attachで表示される | E-06 | ○ |
| C-04 | Attach Byで Name/PID を選択できる | E-02 | ○ |
| C-05 | PIDフィールドはPID選択時のみ表示 | E-03 | ○ |
| C-06 | Process NameフィールドはName選択時のみ表示 | E-03 | ○ |
| C-07 | Wait for process to launchオプションがある | E-02 | ○ |
| C-08 | Include existing processesオプションがある | E-02 | ○ |
| C-09 | Continue once attachedオプションがある | E-02 | ○ |
| C-10 | 詳細設定でプロセスプラグインを選択できる | E-02 | ○ |
| C-11 | Attachボタンでアタッチ実行 | E-02 | ○ |
| C-12 | 実行中プロセスがある場合はデタッチ/キル確認フォームを表示 | E-04, E-06 | ○ |
| C-13 | Target::Attachでアタッチ実行 | E-07 | ○ |
| C-14 | デフォルトプロセス名はターゲットの実行ファイル名 | E-01 | ○ |
| C-15 | フォームタイトルは"Attach Process" | E-01 | ○ |
| C-16 | 機能No.8 LLDBが主機能および遷移先機能として関連 | E-07 | ○ |
| C-17 | UpdateFieldsVisibilityでフィールド表示を制御 | E-03 | ○ |
| C-18 | Show advanced settingsでプラグインフィールドを表示/非表示 | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全ての主張がソースコードまたは設計ドキュメントから確認できる。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] ProcessAttachFormDelegateクラスの定義を確認（2909行〜）
- [ ] コンストラクタのフィールド追加を確認（2910行〜）
- [ ] UpdateFieldsVisibilityの表示制御を確認（2932行〜）
- [ ] StopRunningProcessの処理を確認（2967行〜）
- [ ] 画面遷移図との整合性を確認
