---
generated_at: 2026-02-01 23:45:00
metrics:
  claims_total: 40
  claims_with_evidence: 38
  claims_without_evidence: 2
confidence_derived: 0.95
---

# 根拠レポート：結合テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：38 / 40、根拠なし：2
- 優先レビュー（高）
  1. **IT-031 Cocoaフレームワーク結合テスト**：macOS固有のため実行環境依存
  2. **IT-033 OpenMPターゲットデバイステスト**：GPUデバイス依存のため実行環境確認必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `cross-project-tests/CMakeLists.txt` - クロスプロジェクトテストの構成定義
- E-02: `cross-project-tests/lit.cfg.py` - LITテスト設定とDexter設定
- E-03: `cross-project-tests/debuginfo-tests/README.txt` - デバッグ情報テストの説明
- E-04: `cross-project-tests/debuginfo-tests/clang_llvm_roundtrip/simplified_template_names.test`
- E-05: `cross-project-tests/debuginfo-tests/dexter/feature_tests/unittests/run.test`
- E-06: `cross-project-tests/debuginfo-tests/llgdb-tests/asan.c`
- E-07: `cross-project-tests/debuginfo-tests/dexter-tests/ctor.cpp`
- E-08: `cross-project-tests/debuginfo-tests/dexter-tests/namespace.cpp`
- E-09: `cross-project-tests/debuginfo-tests/dexter-tests/nrvo.cpp`
- E-10: `cross-project-tests/debuginfo-tests/dexter-tests/inline-line-gap.cpp`
- E-11: `cross-project-tests/dtlto/multimodule.test`
- E-12: `cross-project-tests/dtlto/dtlto-cache.test`
- E-13: `cross-project-tests/dtlto/link-archive-thin.test`
- E-14: `libc/test/IntegrationTest/test.h` - 結合テストフレームワーク定義
- E-15: `libc/test/integration/src/pthread/pthread_create_test.cpp`
- E-16: `libc/test/integration/src/pthread/pthread_mutex_test.cpp`
- E-17: `libc/test/integration/src/pthread/pthread_rwlock_test.cpp`
- E-18: `libc/test/integration/src/pthread/pthread_barrier_test.cpp`
- E-19: `libc/test/integration/src/threads/thrd_test.cpp`
- E-20: `libc/test/integration/src/threads/mtx_test.cpp`
- E-21: `libc/test/integration/src/threads/cnd_test.cpp`
- E-22: `libc/test/integration/src/unistd/fork_test.cpp`
- E-23: `libc/test/integration/src/unistd/execv_test.cpp`
- E-24: `libc/test/integration/src/spawn/posix_spawn_test.cpp`
- E-25: `libc/test/integration/startup/linux/tls_test.cpp`
- E-26: `libc/test/integration/startup/linux/init_fini_array_test.cpp`
- E-27: `libc/test/integration/startup/gpu/args_test.cpp`
- E-28: `libc/test/integration/startup/gpu/rpc_test.cpp`
- E-29: `mlir/test/Integration/GPU/CUDA/all-reduce-op.mlir`
- E-30: `mlir/test/Integration/GPU/CUDA/printf.mlir`
- E-31: `mlir/test/Integration/GPU/CUDA/TensorCore/wmma-matmul-f32.mlir`
- E-32: `mlir/test/Integration/GPU/Vulkan/addf.mlir`
- E-33: `mlir/test/Integration/GPU/ROCM/vecadd.mlir`
- E-34: `clang/test/Integration/thinlto_profile_sample_accurate.c`
- E-35: `clang/test/Integration/cocoa.m`
- E-36: `flang/test/Integration/iso-fortran-binding.cpp`
- E-37: `flang/test/Integration/OpenMP/target-filtering.f90`
- E-38: `cross-project-tests/debuginfo-tests/llvm-prettyprinters/lldb/arrayref.test`
- E-39: `cross-project-tests/debuginfo-tests/llvm-prettyprinters/lldb/pointer-union.test`
- E-40: `libc/test/integration/scudo/integration_test.cpp`
- E-41: `libc/test/integration/scudo/gwp_asan_should_crash.cpp`
- E-42: `libc/test/integration/src/__support/GPU/shuffle.cpp`
- E-43: `libc/test/integration/src/__support/GPU/match.cpp`
- E-44: `libc/test/integration/src/__support/threads/thread_tls_test.cpp`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IT-001: デバッグ情報ラウンドトリップテストはテンプレート名簡略化を検証 | E-01, E-04 | ○ |
| C-02 | IT-002: Dexterユニットテストは内部テストフレームワークを検証 | E-02, E-05 | ○ |
| C-03 | IT-003: ASANデバッグ情報テストは構造体配列メンバを検証 | E-06 | ○ |
| C-04 | IT-004: コンストラクタデバッグテストはthisポインタを検証 | E-07 | ○ |
| C-05 | IT-005: 名前空間デバッグテストは変数スコープを検証 | E-08 | ○ |
| C-06 | IT-006: NRVOデバッグテストは戻り値最適化時の変数追跡を検証 | E-09 | ○ |
| C-07 | IT-007: インライン行ギャップテストは行番号維持を検証 | E-10 | ○ |
| C-08 | IT-008: マルチモジュールThinLTOテストはDTLTO連携を検証 | E-11 | ○ |
| C-09 | IT-009: DTLTOキャッシュテストはキャッシュ機能を検証 | E-12 | ○ |
| C-10 | IT-010: アーカイブThinLTOテストは薄いアーカイブ処理を検証 | E-13 | ○ |
| C-11 | IT-011: pthread_create結合テストはスレッド属性を検証 | E-14, E-15 | ○ |
| C-12 | IT-012: pthread_mutex結合テストは排他制御を検証 | E-16 | ○ |
| C-13 | IT-013: pthread_rwlock結合テストは読み書きロックを検証 | E-17 | ○ |
| C-14 | IT-014: pthread_barrier結合テストはバリア同期を検証 | E-18 | ○ |
| C-15 | IT-015: thrd結合テストはC11スレッドを検証 | E-19 | ○ |
| C-16 | IT-016: mtx結合テストはC11 mutexを検証 | E-20 | ○ |
| C-17 | IT-017: cnd結合テストは条件変数を検証 | E-21 | ○ |
| C-18 | IT-018: fork結合テストはプロセス分岐を検証 | E-22 | ○ |
| C-19 | IT-019: execv結合テストはプログラム置換を検証 | E-23 | ○ |
| C-20 | IT-020: posix_spawn結合テストはプロセス生成を検証 | E-24 | ○ |
| C-21 | IT-021: TLS初期化テストはスレッドローカルストレージを検証 | E-25 | ○ |
| C-22 | IT-022: init/fini配列テストは初期化/終了処理順序を検証 | E-26 | ○ |
| C-23 | IT-023: GPUスタートアップ引数テストはGPUコマンドライン引数を検証 | E-27 | ○ |
| C-24 | IT-024: GPU RPCテストはGPU-ホスト間通信を検証 | E-28 | ○ |
| C-25 | IT-025: CUDA all-reduce演算テストは集合演算を検証 | E-29 | ○ |
| C-26 | IT-026: CUDA printfテストはデバイス出力を検証 | E-30 | ○ |
| C-27 | IT-027: CUDA TensorCoreマトリックス乗算テストはwmma演算を検証 | E-31 | ○ |
| C-28 | IT-028: Vulkan加算演算テストはSPIRV変換を検証 | E-32 | ○ |
| C-29 | IT-029: ROCM vecaddテストはHSACO生成を検証 | E-33 | ○ |
| C-30 | IT-030: ThinLTOプロファイルサンプル精度テストはプロファイル適用を検証 | E-34 | ○ |
| C-31 | IT-031: Cocoaフレームワーク結合テストはObjective-C連携を検証 | E-35 | △ |
| C-32 | IT-032: Fortran-C結合テストはISO_C_BINDING相互運用を検証 | E-36 | ○ |
| C-33 | IT-033: OpenMPターゲットデバイステストはオフロード実行を検証 | E-37 | △ |
| C-34 | IT-034: LLDB ArrayRef prettyプリンタテストはデバッガ表示を検証 | E-38 | ○ |
| C-35 | IT-035: LLDB PointerUnion prettyプリンタテストはデバッガ表示を検証 | E-39 | ○ |
| C-36 | IT-036: Scudoメモリアロケータ結合テストはアロケータ動作を検証 | E-40 | ○ |
| C-37 | IT-037: GWP-ASANクラッシュテストはメモリエラー検出を検証 | E-41 | ○ |
| C-38 | IT-038: GPUシャッフル操作テストはワープ内データ交換を検証 | E-42 | ○ |
| C-39 | IT-039: GPUマッチ操作テストはワープ内条件マッチを検証 | E-43 | ○ |
| C-40 | IT-040: スレッドTLS結合テストはスレッド固有値を検証 | E-44 | ○ |

## 4) 不足情報（Unknown / Missing）
- **IT-031 Cocoaフレームワーク結合テスト**：macOS固有の環境依存テストであり、テストの詳細な期待結果が環境によって異なる可能性がある
  - 候補：macOS SDK バージョン情報 / 対応アーキテクチャ / Xcode バージョン要件
- **IT-033 OpenMPターゲットデバイステスト**：GPUオフロード先デバイスに依存するため、サポートデバイスの明確な仕様が必要
  - 候補：サポートGPUリスト / OpenMPランタイムバージョン / ドライバ要件

## 5) リスクフラグ（レビュー観点）
- **リスク0（低リスク）**：IT-001〜IT-010, IT-011〜IT-030, IT-034〜IT-040 - ソースコードから直接確認可能
- **リスク1（中リスク）**：IT-031, IT-033 - 実行環境依存の検証が必要
  - CocoaテストはmacOS環境でのみ実行可能
  - OpenMPターゲットテストは対応GPUが必要

## 6) レビュアーチェックリスト（最小）
- [ ] 各テストケースのテストIDが一意であること
- [ ] テスト種別の分類が適切であること（クロスプロジェクト連携、デバッガ連携、libc結合、GPU連携、Clang連携、Flang連携）
- [ ] 前提条件が実行可能な形で記述されていること
- [ ] テスト手順が再現可能な形で記述されていること
- [ ] 期待結果が検証可能な形で記述されていること
- [ ] 優先度が適切に設定されていること（高：コア機能、中：重要機能、低：補助機能）
- [ ] 備考欄のファイルパスが実際に存在するソースファイルを参照していること
- [ ] IT-031（Cocoa）とIT-033（OpenMP）の環境依存性について追加確認が必要かどうか
