---
generated_at: 2026-02-01 12:00:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：通知一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  1. なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `clang-tools-extra/clangd/ClangdLSPServer.h` - LSP通知定義（OutgoingNotification）
- E-02: `clang-tools-extra/clangd/ClangdLSPServer.cpp` - LSP通知実装（bindMethods）
- E-03: `clang-tools-extra/clangd/Protocol.h` - LSPプロトコル構造体定義
- E-04: `clang-tools-extra/clangd/LSPBinder.h` - LSP通知バインディング機構
- E-05: `clang-tools-extra/clangd/Transport.h` - トランスポート層通知インターフェース
- E-06: `clang/include/clang/DirectoryWatcher/DirectoryWatcher.h` - ディレクトリ監視イベント定義
- E-07: `clang/lib/DirectoryWatcher/linux/DirectoryWatcher-linux.cpp` - Linux実装
- E-08: `clang/lib/DirectoryWatcher/mac/DirectoryWatcher-mac.cpp` - macOS実装
- E-09: `clang/lib/DirectoryWatcher/windows/DirectoryWatcher-windows.cpp` - Windows実装
- E-10: `.github/workflows/llvm-bugs.yml` - バグ通知ワークフロー
- E-11: `.github/workflows/new-prs.yml` - PR通知ワークフロー
- E-12: `clang-tools-extra/clangd/support/Threading.h` - Notificationクラス定義
- E-13: `clang-tools-extra/clangd/support/Threading.cpp` - Notificationクラス実装

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | PublishDiagnostics通知はドキュメントの診断情報をクライアントに送信 | E-01, E-02, E-03 | ○ |
| C-02 | ShowMessage通知はメッセージをUIで表示するよう通知 | E-01, E-02, E-03 | ○ |
| C-03 | NotifyFileStatus通知はファイルの状態を通知（clangd拡張） | E-01, E-02 | ○ |
| C-04 | PublishInactiveRegions通知は非アクティブ領域を通知（clangd拡張） | E-01, E-02, E-03 | ○ |
| C-05 | BeginWorkDoneProgress通知は長時間処理の開始を通知 | E-01, E-02, E-03 | ○ |
| C-06 | ReportWorkDoneProgress通知は進捗状況を通知 | E-01, E-02, E-03 | ○ |
| C-07 | EndWorkDoneProgress通知は長時間処理の完了を通知 | E-01, E-02, E-03 | ○ |
| C-08 | SemanticTokensRefresh通知はトークン更新をリクエスト | E-01, E-02 | ○ |
| C-09 | DirectoryWatcher Modified通知はファイル変更を検出 | E-06, E-07, E-08, E-09 | ○ |
| C-10 | DirectoryWatcher Removed通知はファイル削除を検出 | E-06, E-07, E-08, E-09 | ○ |
| C-11 | DirectoryWatcher WatchedDirRemoved通知はディレクトリ削除を検出 | E-06, E-07, E-08, E-09 | ○ |
| C-12 | DirectoryWatcher WatcherGotInvalidated通知はWatcher無効化を通知 | E-06, E-07, E-08, E-09 | ○ |
| C-13 | LLVM Bugs notifier は新規Issue時にメール通知 | E-10 | ○ |
| C-14 | PR Greeter は新規コントリビューターに歓迎コメントを通知 | E-11 | ○ |
| C-15 | Notificationクラスはスレッド間同期機構を提供 | E-12, E-13 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての通知機能について、ソースコードから根拠を確認済み）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認可能
- 注意点：LSPメソッド名はLSP仕様準拠（標準）とclangd拡張があるため、クライアント互換性に注意

## 6) レビュアーチェックリスト（最小）
- [ ] LSP通知がProtocol.hの構造体定義と一致しているか
- [ ] DirectoryWatcherのEventKindが全プラットフォームで一貫しているか
- [ ] GitHub Workflowの通知先（メールアドレス、secrets）が適切か
- [ ] clangd拡張通知がクライアントで正しくハンドリングされるか
