# 通知設計書 13-LLVM Bugs notifier

## 概要

本ドキュメントは、LLVM ProjectのGitHub RepositoryにおけるIssue作成時のメール通知ワークフローの設計仕様を記述する。新規Issueが作成された際に、llvm-bugs@lists.llvm.orgメーリングリストへ自動的にメール通知を送信するGitHub Actionsワークフローである。

### 本通知の処理概要

LLVM Bugs notifierは、LLVM Projectのバグトラッキングシステムにおいて、新規Issueが報告された際にメーリングリストを通じて開発者コミュニティに通知するための自動化ワークフローである。

**業務上の目的・背景**：LLVMは大規模なオープンソースプロジェクトであり、多くの開発者がIssueを監視する必要がある。従来はBugzillaを使用していたが、GitHubへ移行した後もメーリングリストベースの通知フローを維持するため、このワークフローが必要となった。llvm-bugs@lists.llvm.orgは歴史的に重要なチャンネルであり、多くの開発者がこのリストを購読してバグの報告を追跡している。

**通知の送信タイミング**：GitHub上でIssueが新規作成（opened）された時点でトリガーされる。Issueの更新、クローズ、再オープンなどのイベントでは送信されない。リポジトリが`llvm/llvm-project`である場合のみ実行される。

**通知の受信者**：llvm-bugs@lists.llvm.org メーリングリストの購読者全員が受信者となる。これはLLVMプロジェクトのバグ報告専用メーリングリストである。

**通知内容の概要**：Issueの番号、タイトル、作成者、URL、ラベル、担当者、本文が含まれる。本文が15,000文字を超える場合は切り詰められる。Mailgunのテンプレート「new-github-issue」を使用してフォーマットされる。

**期待されるアクション**：メーリングリスト購読者は、自分の専門分野に関連するバグ報告を確認し、必要に応じてGitHubのIssueにコメントしたり、修正に取り組むことが期待される。

## 通知種別

メール通知（Mailgun API経由）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（GitHub Actions） |
| 優先度 | 中 |
| リトライ | GitHub Actionsのデフォルト動作に依存 |

### 送信先決定ロジック

固定の送信先として`llvm-bugs@lists.llvm.org`が使用される。条件分岐や動的な送信先決定は行わない。

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | llvm-bugs@email.llvm.org |
| 送信元名称 | LLVM Bugs |
| 件名 | `[Bug {issue.number}] {issue.title}` |
| 形式 | Mailgunテンプレート（new-github-issue） |

### 本文テンプレート

```
Mailgunテンプレート「new-github-issue」を使用
変数として以下がJSON形式で渡される:
- author: Issue作成者のログイン名
- issue: Issue番号
- title: Issueタイトル
- url: IssueのHTML URL
- labels: ラベル名の配列
- assignee: 担当者ログイン名の配列
- body: Issue本文（最大15,000文字）
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 添付ファイルは使用しない |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| author | Issue作成者 | `issue.data.user.login` | Yes |
| issue | Issue番号 | `issue.data.number` | Yes |
| title | Issueタイトル | `issue.data.title` | Yes |
| url | IssueのURL | `issue.data.html_url` | Yes |
| labels | ラベル一覧 | `issue.data.labels.map(label => label.name)` | Yes |
| assignee | 担当者一覧 | `issue.data.assignees.map(assignee => assignee.login)` | Yes |
| body | Issue本文 | `issue.data.body`（15,000文字で切り詰め） | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| GitHubイベント | issues.opened | repository == 'llvm/llvm-project' | 新規Issue作成時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| リポジトリが異なる | llvm/llvm-project以外のリポジトリでは実行されない |
| APIキーが未設定 | LLVM_BUGS_KEY シークレットがない場合はエラー終了 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[Issue作成イベント] --> B{リポジトリチェック}
    B -->|llvm/llvm-project| C[Node.js環境セットアップ]
    B -->|その他| D[処理スキップ]
    C --> E[mailgun.js / form-data インストール]
    E --> F[GitHub APIでIssue詳細取得]
    F --> G{本文長チェック}
    G -->|15000文字超| H[本文を切り詰め]
    G -->|15000文字以下| I[そのまま使用]
    H --> J[ペイロード構築]
    I --> J
    J --> K[Mailgun API呼び出し]
    K --> L[メール送信]
    L --> M[完了ログ出力]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（GitHubとMailgun APIのみ使用）

### 更新テーブル一覧

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| API認証エラー | LLVM_BUGS_KEY が無効 | ワークフロー失敗としてログ記録 |
| Mailgun送信エラー | ネットワークエラー、APIエラー | ワークフロー失敗としてログ記録 |
| GitHub API エラー | Issue情報取得失敗 | ワークフロー失敗としてログ記録 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | GitHub Actionsのデフォルト（0回） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし（手動再実行が必要） |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | Mailgun APIの制限に依存 |
| 1日あたり上限 | Mailgun APIの制限に依存 |

### 配信時間帯

24時間常時（Issueイベント発生時に即時実行）

## セキュリティ考慮事項

- LLVM_BUGS_KEY はGitHub Secretsで管理され、ワークフローログには出力されない
- ワークフローはcontents:read、issues:read権限のみで動作（最小権限）
- メールのクリックトラッキングは無効化されている（o:tracking-clicks: 'no'）

## 備考

- Mailgunドメインは`email.llvm.org`
- テンプレート名は`new-github-issue`（Mailgun側で管理）
- Node.js 24を使用
- actions/setup-node@v6.1.0、actions/github-script@v8.0.0を使用

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: ワークフロー定義を理解する

まず、GitHub Actionsワークフローの全体構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | llvm-bugs.yml | `.github/workflows/llvm-bugs.yml` | ワークフロー全体の構造、トリガー条件、ジョブ定義を確認 |

**読解のコツ**: YAMLファイルの構造に注意。`on.issues.types`でトリガーイベントを定義し、`jobs.auto-subscribe.if`で実行条件を指定している。

#### Step 2: トリガー条件を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | llvm-bugs.yml | `.github/workflows/llvm-bugs.yml` | 行7-10でissues.openedイベントをトリガーとして定義、行15でリポジトリチェック |

**主要処理フロー**:
1. **行7-10**: `on: issues: types: - opened` でIssue作成をトリガーに設定
2. **行15**: `if: github.repository == 'llvm/llvm-project'` でリポジトリを限定

#### Step 3: 環境セットアップを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | llvm-bugs.yml | `.github/workflows/llvm-bugs.yml` | 行16-21でNode.js環境とnpmパッケージのセットアップを確認 |

**主要処理フロー**:
- **行17-20**: actions/setup-node@v6.1.0でNode.js 24をセットアップ
- **行21**: `npm install mailgun.js form-data` でMailgunライブラリをインストール

#### Step 4: メール送信処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | llvm-bugs.yml | `.github/workflows/llvm-bugs.yml` | 行22-69でactions/github-scriptを使用したメール送信処理を確認 |

**主要処理フロー**:
- **行28-34**: Mailgunクライアントの初期化
- **行36-56**: GitHub APIでIssue詳細を取得し、ペイロードを構築
- **行42-47**: 本文が15,000文字を超える場合は切り詰め
- **行58-65**: Mailgun APIでメール送信（テンプレート: new-github-issue）
- **行67**: `mg.messages.create(DOMAIN, data)` でメール送信実行

### プログラム呼び出し階層図

```
GitHub Actions (llvm-bugs.yml)
    │
    ├─ on: issues.opened
    │      └─ if: github.repository == 'llvm/llvm-project'
    │
    ├─ actions/setup-node@v6.1.0
    │      └─ node-version: 24
    │
    ├─ npm install
    │      ├─ mailgun.js
    │      └─ form-data
    │
    └─ actions/github-script@v8.0.0
           │
           ├─ Mailgun client initialization
           │      └─ api key: LLVM_BUGS_KEY
           │
           ├─ github.rest.issues.get()
           │      └─ Issue詳細取得
           │
           ├─ Payload construction
           │      └─ body truncation (15000 chars)
           │
           └─ mg.messages.create()
                  └─ template: 'new-github-issue'
```

### データフロー図

```
[入力]                    [処理]                          [出力]

GitHub Issue ─────────▶ GitHub API ──────────▶ Issue詳細JSON
    │                       │
    │                       ▼
    │                  ペイロード構築
    │                       │
    │                       ├─ author
    │                       ├─ issue number
    │                       ├─ title
    │                       ├─ url
    │                       ├─ labels[]
    │                       ├─ assignees[]
    │                       └─ body (truncated)
    │                           │
    │                           ▼
    │                  Mailgun API ───────────▶ メール送信
    │                       │
    └───────────────────────┴────────────────▶ llvm-bugs@lists.llvm.org
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| llvm-bugs.yml | `.github/workflows/llvm-bugs.yml` | ワークフロー | メイン処理定義 |
| (Mailgunテンプレート) | Mailgun管理画面 | テンプレート | new-github-issueテンプレート（外部管理） |
