# 通知設計書 14-PR Greeter

## 概要

本ドキュメントは、LLVM ProjectのGitHub Repositoryにおける新規コントリビューターのPR作成時に歓迎コメントを自動投稿するGitHub Actionsワークフローの設計仕様を記述する。初めてPRを作成したコントリビューターに対して、ガイドラインとコミュニティリソースへのリンクを含む歓迎メッセージを投稿する。

### 本通知の処理概要

PR Greeterは、LLVM Projectに初めて貢献する開発者を歓迎し、プロジェクトへの参加をサポートするための自動化ワークフローである。新規コントリビューターがPRを作成した際に、自動的に歓迎コメントを投稿する。

**業務上の目的・背景**：LLVMは大規模なオープンソースプロジェクトであり、新規コントリビューターにとって貢献プロセスは複雑に感じられることがある。この自動化により、初回PRを作成したコントリビューターに対して即座にフィードバックを提供し、レビュー依頼の方法、コミュニケーションチャンネル（Discord、フォーラム）、ドキュメントへのリンクなど、必要な情報を提供する。これにより、コントリビューターの離脱を防ぎ、コミュニティへの参加を促進する。

**通知の送信タイミング**：PRが新規作成（opened）された時点でトリガーされる。ただし、作成者が既存のコントリビューター（COLLABORATOR, CONTRIBUTOR, MANNEQUIN, MEMBER, OWNER）である場合は送信されない。新規コントリビューター（NONE, FIRST_TIMER, FIRST_TIME_CONTRIBUTOR相当）に対してのみ実行される。

**通知の受信者**：PRの作成者（新規コントリビューター）が通知の対象となる。PR作成者に対してGitHubコメントとして通知が届く。

**通知内容の概要**：歓迎メッセージ、レビュアー依頼方法、Ping（再確認）の推奨頻度、LLVM GitHub User Guideへのリンク、Discord・フォーラムへのリンクが含まれる。Markdownフォーマットで整形された読みやすいコメントとなる。

**期待されるアクション**：新規コントリビューターは、コメント内のガイドラインを参照してレビュアーを設定したり、質問がある場合はDiscordやフォーラムで質問することが期待される。週に1回程度の頻度でPingすることも推奨される。

## 通知種別

GitHubコメント通知

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（GitHub Actions内で即時実行） |
| 優先度 | 中 |
| リトライ | GitHub Actionsのデフォルト動作に依存 |

### 送信先決定ロジック

PR作成者のauthor_associationをチェックし、以下の条件を満たす場合のみコメントを投稿する:
- COLLABORATOR ではない
- CONTRIBUTOR ではない
- MANNEQUIN ではない
- MEMBER ではない
- OWNER ではない

これにより、実質的にNONE（初回PRの作成者）に対してのみ通知が行われる。

## 通知テンプレート

### GitHubコメントの場合

| 項目 | 内容 |
|-----|------|
| 投稿者 | github-actions[bot]（GITHUB_TOKEN使用） |
| コメント形式 | Markdown |
| 識別タグ | `<!--LLVM NEW CONTRIBUTOR COMMENT-->` |

### 本文テンプレート

```markdown
<!--LLVM NEW CONTRIBUTOR COMMENT-->
Thank you for submitting a Pull Request (PR) to the LLVM Project!

This PR will be automatically labeled and the relevant teams will be notified.

If you wish to, you can add reviewers by using the "Reviewers" section on this page.

If this is not working for you, it is probably because you do not have write permissions for the repository. In which case you can instead tag reviewers by name in a comment by using `@` followed by their GitHub username.

If you have received no comments on your PR for a week, you can request a review by "ping"ing the PR by adding a comment "Ping". The common courtesy "ping" rate is once a week. Please remember that you are asking for valuable time from other developers.

If you have further questions, they may be answered by the [LLVM GitHub User Guide](https://llvm.org/docs/GitHub.html).

You can also ask questions in a comment on this PR, on the [LLVM Discord](https://discord.com/invite/xS7Z362) or on the [forums](https://discourse.llvm.org/).
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 添付ファイルは使用しない |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| (固定テキスト) | 歓迎メッセージ | PRGreeterクラス内で定義 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| GitHubイベント | pull_request_target.opened | author_associationがNONE相当 | 新規コントリビューターによるPR作成時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| COLLABORATOR | リポジトリのコラボレーターである |
| CONTRIBUTOR | 過去にコントリビューション経験がある |
| MANNEQUIN | インポートされたユーザー（GitHub移行時など） |
| MEMBER | 組織メンバーである |
| OWNER | リポジトリオーナーである |
| 再オープン/同期/下書き解除 | openedイベント以外では実行されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[PR作成イベント] --> B{アクション種別}
    B -->|opened| C{author_associationチェック}
    B -->|その他| D[処理スキップ]
    C -->|NONE相当| E[リポジトリチェックアウト]
    C -->|既存コントリビューター| D
    E --> F[Python環境セットアップ]
    F --> G[github-automation.py実行]
    G --> H[PRGreeter.run実行]
    H --> I[歓迎コメント投稿]
    I --> J[処理完了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（GitHub APIのみ使用）

### 更新テーブル一覧

該当なし（GitHubコメントのみ）

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| GitHub APIエラー | コメント投稿失敗 | ワークフロー失敗としてログ記録 |
| 認証エラー | GITHUB_TOKENが無効 | ワークフロー失敗としてログ記録 |
| Python実行エラー | スクリプト実行失敗 | ワークフロー失敗としてログ記録 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | GitHub Actionsのデフォルト（0回） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし（手動再実行が必要） |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | GitHub APIの制限に依存 |
| 1日あたり上限 | GitHub APIの制限に依存 |

### 配信時間帯

24時間常時（PRイベント発生時に即時実行）

## セキュリティ考慮事項

- pull_request_targetを使用しており、フォークからのPRでも安全に動作
- ワークフローはcontents:readとpull-requests:write権限で動作
- PRのコードをチェックアウト・実行しないため、悪意あるコードの実行リスクはない
- mainブランチのスクリプトのみを使用（ref: main）

## 備考

- `<!--LLVM NEW CONTRIBUTOR COMMENT-->`タグにより、コメントの重複投稿を検出可能
- PRBuildbotInformationでもこのタグを使用して、新規コントリビューターかどうかを判定
- greeterジョブ完了後にautomate-prs-labelsジョブが実行される
- コミット数が10以上のPRはラベル付けジョブでスキップされる

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: ワークフロー定義を理解する

まず、GitHub Actionsワークフローの全体構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | new-prs.yml | `.github/workflows/new-prs.yml` | ワークフロー全体の構造、トリガー条件、ジョブ定義を確認 |

**読解のコツ**: YAMLファイルの`on.pull_request_target`に注意。これはフォークからのPRでも安全に動作するトリガーである。

#### Step 2: トリガー条件とフィルタを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | new-prs.yml | `.github/workflows/new-prs.yml` | 行10-14でトリガーイベント、行28-34でauthor_associationフィルタを確認 |

**主要処理フロー**:
1. **行10-14**: `pull_request_target: types: [opened, reopened, ready_for_review, synchronize]`
2. **行28-34**: author_associationが特定の値でないことを確認（NONE相当の検出）
3. **行29**: `github.event.action == 'opened'` でopenedイベントのみに限定

#### Step 3: Pythonスクリプトの実行フローを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | new-prs.yml | `.github/workflows/new-prs.yml` | 行36-53でリポジトリチェックアウト、Python環境セットアップ、スクリプト実行を確認 |

**主要処理フロー**:
- **行36-40**: llvm/utils/git/ディレクトリのみをsparse-checkoutでチェックアウト（mainブランチ）
- **行42-45**: requirements.txtからPython依存関係をインストール
- **行47-53**: github-automation.py pr-greeterサブコマンドを実行

#### Step 4: PRGreeterクラスを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | github-automation.py | `llvm/utils/git/github-automation.py` | 行229-258でPRGreeterクラスの実装を確認 |

**主要処理フロー**:
- **行230**: `COMMENT_TAG = "<!--LLVM NEW CONTRIBUTOR COMMENT-->\n"` で識別タグを定義
- **行232-234**: コンストラクタでrepoとprオブジェクトを取得
- **行236-258**: run()メソッドで歓迎コメントを生成・投稿
- **行242-256**: Markdownフォーマットの歓迎メッセージテンプレート
- **行257**: `self.pr.as_issue().create_comment(comment)` でコメント投稿

#### Step 5: 関連クラス（PRBuildbotInformation）を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | github-automation.py | `llvm/utils/git/github-automation.py` | 行322-368でPRBuildbotInformationクラスがPRGreeter.COMMENT_TAGを参照していることを確認 |

**主要処理フロー**:
- **行330-344**: should_comment()メソッドで、過去にPRGreeterのコメントがあったかを確認
- **行336-337**: PRGreeter.COMMENT_TAGがあれば新規コントリビューターと判定

### プログラム呼び出し階層図

```
GitHub Actions (new-prs.yml)
    │
    ├─ on: pull_request_target.opened
    │      └─ if: author_association != (COLLABORATOR|CONTRIBUTOR|MANNEQUIN|MEMBER|OWNER)
    │
    ├─ actions/checkout@v6.0.1
    │      ├─ sparse-checkout: llvm/utils/git/
    │      └─ ref: main
    │
    ├─ pip install -r requirements.txt
    │
    └─ github-automation.py pr-greeter
           │
           └─ PRGreeter
                  │
                  ├─ __init__(token, repo, pr_number)
                  │      └─ repo.get_issue(pr_number).as_pull_request()
                  │
                  └─ run()
                         └─ pr.as_issue().create_comment(comment)
```

### データフロー図

```
[入力]                    [処理]                          [出力]

PRイベント ───────────▶ author_association判定 ──────▶ (スキップ or 続行)
    │                       │
    │                       ▼
    │               PRGreeterクラス
    │                       │
    │                       ├─ COMMENT_TAG生成
    │                       │
    │                       └─ 歓迎コメント生成
    │                              │
    │                              ├─ レビュアー依頼方法
    │                              ├─ Ping推奨頻度
    │                              ├─ GitHub User Guideリンク
    │                              ├─ Discordリンク
    │                              └─ フォーラムリンク
    │                                     │
    └─────────────────────────────────────┴──▶ PRコメント投稿
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| new-prs.yml | `.github/workflows/new-prs.yml` | ワークフロー | メイン処理定義、greeterジョブ（行17-53） |
| github-automation.py | `llvm/utils/git/github-automation.py` | Pythonスクリプト | PRGreeterクラス（行229-258） |
| requirements.txt | `llvm/utils/git/requirements.txt` | 依存関係 | Python依存パッケージ定義 |
