# 通知設計書 3-NotifyFileStatus

## 概要

本ドキュメントは、clangdが実装するclangd拡張メソッド `textDocument/clangd.fileStatus` の通知仕様を定義する。この通知は、ファイルの処理状態（解析中、完了等）をクライアントに通知するために使用されるclangd独自の拡張機能である。

### 本通知の処理概要

NotifyFileStatus通知は、clangdがソースファイルを処理している状態をリアルタイムでエディタに伝えるための機能である。プリアンブル構築やAST構築の進行状況をユーザーに可視化する。

**業務上の目的・背景**：大規模なC/C++プロジェクトでは、ファイルの解析に時間がかかることがある。開発者がclangdの処理状態を把握できることで、「なぜ補完が遅いのか」「いつ診断が利用可能になるのか」といった疑問を解消できる。この情報により、開発者はclangdの動作状況を理解し、適切なタイミングで作業を進めることができる。

**通知の送信タイミング**：ファイルの処理状態が変化したときに送信される。具体的には、(1) プリアンブル構築開始/完了、(2) AST構築開始/完了、(3) アクション実行中の状態変化時。ただし、頻繁な状態変化（BuildingFile、RunningAction）は通知されず、安定した状態のみが通知される。

**通知の受信者**：この拡張をサポートするLSPクライアントが受信者となる。クライアントはinitializationOptionsでFileStatus=trueを設定することでこの機能を有効化する。主にVSCode用clangd拡張で使用される。

**通知内容の概要**：ファイルのURIと現在の状態を表す人間可読な文字列が含まれる。状態文字列は「idle」「parsing includes」「parsing」などの値を取る。

**期待されるアクション**：クライアントは受信した状態をステータスバーやUI要素に表示する。ユーザーはこの情報を参照してclangdの処理状況を把握できる。

## 通知種別

LSP Notification（clangd拡張：サーバーからクライアントへの一方向通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期 |
| 優先度 | 低 |
| リトライ | なし（通知は一方向のため） |

### 送信先決定ロジック

FileStatus機能を有効化したLSPクライアントに送信される。initializationOptions.clangdFileStatus=trueの場合のみ有効。

## 通知テンプレート

### LSP Notification形式

| 項目 | 内容 |
|-----|------|
| メソッド名 | `textDocument/clangd.fileStatus` |
| 形式 | JSON-RPC 2.0 Notification |

### 本文テンプレート

```json
{
  "jsonrpc": "2.0",
  "method": "textDocument/clangd.fileStatus",
  "params": {
    "uri": "file:///path/to/source.cpp",
    "state": "idle"
  }
}
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| uri | 対象ファイルのURI | URIForFile | Yes |
| state | ファイルの処理状態を表す文字列 | TUStatus::render() | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 内部処理 | TUStatus変更 | SupportFileStatus=true && 状態が安定 | プリアンブル/AST処理状態の変化 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| SupportFileStatus=false | クライアントがFileStatus拡張をサポートしていない場合 |
| BuildingFile状態 | AST構築中の一時的な状態は通知されない |
| RunningAction状態 | アクション実行中の一時的な状態は通知されない |
| サーバー未初期化 | initializeリクエスト完了前は送信されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[TUScheduler状態変更] --> B[onFileUpdated コールバック]
    B --> C{SupportFileStatus?}
    C -->|No| D[処理終了]
    C -->|Yes| E{状態が安定?}
    E -->|No| D
    E -->|Yes| F[TUStatus::render]
    F --> G[FileStatus構築]
    G --> H[NotifyFileStatus送信]
    H --> I[クライアントでUI表示]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（LSPサーバーはインメモリで動作）

### 更新テーブル一覧

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| Transport失敗 | クライアントとの接続断 | ログ出力、再接続待機 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（状態変化駆動、ただし頻繁な変化は抑止） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（リアルタイム配信）

## セキュリティ考慮事項

- ファイルパスがURIとして送信されるため、ローカルファイルシステム構造が露出する
- LSP通信はローカルプロセス間通信が基本であり、外部ネットワークへの送信は想定していない

## 備考

- clangd独自の拡張機能であり、LSP標準には含まれない
- クライアント側でのサポートが必要（VSCode clangd拡張等）
- 状態文字列の例：「idle」「parsing includes」「parsing」「queued」
- UI表示の頻繁な更新を避けるため、一時的な状態変化は通知されない

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

FileStatus構造体の定義を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Protocol.h | `clang-tools-extra/clangd/Protocol.h` | FileStatus構造体定義（行1849-1858） |
| 1-2 | Protocol.cpp | `clang-tools-extra/clangd/Protocol.cpp` | toJSON(FileStatus)実装（行1279-1284） |

**読解のコツ**: FileStatusはuri（URIForFile）とstate（string）の2フィールドのみの簡潔な構造。

#### Step 2: エントリーポイントを理解する

FileStatus通知の送信箇所を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ClangdLSPServer.h | `clang-tools-extra/clangd/ClangdLSPServer.h` | NotifyFileStatus通知のバインド宣言（行196） |
| 2-2 | ClangdLSPServer.cpp | `clang-tools-extra/clangd/ClangdLSPServer.cpp` | NotifyFileStatusバインド（行1738） |
| 2-3 | ClangdLSPServer.cpp | `clang-tools-extra/clangd/ClangdLSPServer.cpp` | onFileUpdatedコールバック（行1924-1936） |

**主要処理フロー**:
1. **行1738**: `Bind.outgoingNotification("textDocument/clangd.fileStatus")`でバインド
2. **行1924**: `onFileUpdated`コールバック開始
3. **行1925-1926**: SupportFileStatusチェック
4. **行1931-1934**: 一時的な状態変化の抑止条件チェック
5. **行1935**: `NotifyFileStatus(Status.render(File))`で送信

#### Step 3: 有効化条件を理解する

FileStatus機能の有効化フローを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Protocol.h | `clang-tools-extra/clangd/Protocol.h` | InitializationOptions::FileStatus（行610） |
| 3-2 | ClangdLSPServer.cpp | `clang-tools-extra/clangd/ClangdLSPServer.cpp` | onInitializeでのSupportFileStatus設定（行540） |

**主要処理フロー**:
- **行540**: `SupportFileStatus = Params.initializationOptions.FileStatus`

### プログラム呼び出し階層図

```
TUScheduler (AST/プリアンブル処理)
    │
    └─ ClangdServer::Callbacks::onFileUpdated()
           │
           └─ ClangdLSPServer::onFileUpdated()
                  │
                  ├─ [SupportFileStatus確認]
                  ├─ [状態安定性確認]
                  └─ NotifyFileStatus(Status.render(File))
                         └─ ClangdLSPServer::notify()
                                └─ Transport::notify()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

TUStatus (内部状態) ───▶ 状態フィルタリング ───▶ FileStatus
    │                      │                        │
    │                      ▼                        ▼
    │               Status.render(File)         toJSON()
    │                      │                        │
    │                      ▼                        ▼
    └──────────────▶ uri + state文字列 ───▶ JSON-RPC通知
                                                    │
                                                    ▼
                                              [LSPクライアント]
                                              ステータスバー表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Protocol.h | `clang-tools-extra/clangd/Protocol.h` | ヘッダ | FileStatus, InitializationOptions定義 |
| Protocol.cpp | `clang-tools-extra/clangd/Protocol.cpp` | ソース | JSON変換実装 |
| ClangdLSPServer.h | `clang-tools-extra/clangd/ClangdLSPServer.h` | ヘッダ | NotifyFileStatus通知宣言 |
| ClangdLSPServer.cpp | `clang-tools-extra/clangd/ClangdLSPServer.cpp` | ソース | FileStatus送信ロジック |
| TUScheduler.h | `clang-tools-extra/clangd/TUScheduler.h` | ヘッダ | TUStatus定義 |
| LSPBinder.h | `clang-tools-extra/clangd/LSPBinder.h` | ヘッダ | LSPメソッドバインディング |
| Transport.h | `clang-tools-extra/clangd/Transport.h` | ヘッダ | 通信層インターフェース |
