# 通知設計書 7-EndWorkDoneProgress

## 概要

本ドキュメントは、clangd Language Serverが実装するLSP標準メソッド `$/progress` （WorkDoneProgressEnd）の通知仕様を定義する。この通知は、長時間処理の完了をクライアントに通知するために使用される。

### 本通知の処理概要

EndWorkDoneProgress通知は、バックグラウンドインデックス構築などの長時間処理が完了したことをエディタに伝え、プログレスバーを終了させる機能である。

**業務上の目的・背景**：大規模なC/C++プロジェクトのインデックス構築完了を開発者に通知することで、コード補完やシンボルジャンプなどの機能が完全に利用可能になったことを示す。プログレスバーが消えることで、開発者は処理完了を視覚的に把握できる。

**通知の送信タイミング**：バックグラウンドインデックスの処理が全て完了したタイミングで送信される。具体的には、`onBackgroundIndexProgress`コールバックでCompleted >= Enqueuedとなった時に送信される。

**通知の受信者**：WorkDoneProgress機能をサポートするLSPクライアントが受信者となる。BeginWorkDoneProgressを受信しているセッションに対して送信される。

**通知内容の概要**：プログレストークンと、オプションの終了メッセージが含まれる。

**期待されるアクション**：クライアントは受信した通知に基づいてプログレスバーを非表示にする。

## 通知種別

LSP Notification（サーバーからクライアントへの一方向通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期 |
| 優先度 | 低 |
| リトライ | なし（通知は一方向のため） |

### 送信先決定ロジック

WorkDoneProgress機能をサポートし、BeginWorkDoneProgressを受信しているLSPクライアントに送信される。

## 通知テンプレート

### LSP Notification形式

| 項目 | 内容 |
|-----|------|
| メソッド名 | `$/progress` |
| 形式 | JSON-RPC 2.0 Notification |

### 本文テンプレート

```json
{
  "jsonrpc": "2.0",
  "method": "$/progress",
  "params": {
    "token": "backgroundIndexProgress",
    "value": {
      "kind": "end"
    }
  }
}
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| token | プログレス識別トークン | 固定値 "backgroundIndexProgress" | Yes |
| value.kind | 進捗の種類 | 固定値 "end" | Yes |
| value.message | 終了メッセージ | オプション（未設定） | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 内部処理 | BackgroundQueue進捗更新 | State==Live && Completed >= Enqueued | インデックス処理完了時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| BackgroundIndexProgressState!=Live | プログレスバーが開始されていない場合 |
| Completed < Enqueued | 処理がまだ進行中の場合（Reportを送信） |
| サーバー未初期化 | initializeリクエスト完了前は送信されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[BackgroundQueue進捗更新] --> B[onBackgroundIndexProgress コールバック]
    B --> C{State==Live?}
    C -->|No| D[他の状態処理]
    C -->|Yes| E[NotifyProgress]
    E --> F{Completed >= Enqueued?}
    F -->|No| G[ReportWorkDoneProgress送信]
    F -->|Yes| H[EndWorkDoneProgress送信]
    H --> I[State=Empty]
    I --> J[プログレスバー終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（LSPサーバーはインメモリで動作）

### 更新テーブル一覧

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| Transport失敗 | クライアントとの接続断 | ログ出力、再接続待機 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（イベント駆動） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（リアルタイム配信）

## セキュリティ考慮事項

- プログレス情報には機密データは含まれない
- LSP通信はローカルプロセス間通信が基本であり、外部ネットワークへの送信は想定していない

## 備考

- LSP標準メソッドの一部（$/progress）
- WorkDoneProgressBegin, WorkDoneProgressReport, WorkDoneProgressEndの3種類の通知がある
- End送信後、BackgroundIndexProgressStateはEmptyにリセットされる
- 次回のインデックス処理開始時に再度Beginから開始される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

WorkDoneProgressEnd構造体の定義を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Protocol.h | `clang-tools-extra/clangd/Protocol.h` | WorkDoneProgressEnd構造体定義（行725-729） |
| 1-2 | Protocol.cpp | `clang-tools-extra/clangd/Protocol.cpp` | toJSON(WorkDoneProgressEnd)実装（行612-618） |

**読解のコツ**: messageはオプショナルフィールド。kindは"end"固定でシリアライズされる。

#### Step 2: エントリーポイントを理解する

EndWorkDoneProgress通知の送信箇所を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ClangdLSPServer.h | `clang-tools-extra/clangd/ClangdLSPServer.h` | EndWorkDoneProgress通知のバインド宣言（行204-205） |
| 2-2 | ClangdLSPServer.cpp | `clang-tools-extra/clangd/ClangdLSPServer.cpp` | EndWorkDoneProgressバインド（行1742） |
| 2-3 | ClangdLSPServer.cpp | `clang-tools-extra/clangd/ClangdLSPServer.cpp` | NotifyProgress内のEnd送信（行1879-1883） |

**主要処理フロー**:
1. **行1742**: `Bind.outgoingNotification("$/progress")`でバインド
2. **行1879-1880**: Completed >= Enqueuedの条件確認（assert含む）
3. **行1881**: `EndWorkDoneProgress({ProgressToken, WorkDoneProgressEnd()})`で送信
4. **行1882**: `BackgroundIndexProgressState = BackgroundIndexProgress::Empty`で状態リセット

#### Step 3: 状態遷移を理解する

End送信後の状態遷移を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ClangdLSPServer.cpp | `clang-tools-extra/clangd/ClangdLSPServer.cpp` | 状態リセット処理（行1882） |

**主要処理フロー**:
- **行1882**: End送信後にStateをEmptyにリセット
- 次のインデックス処理開始時にEmpty状態から再びBeginが送信される

### プログラム呼び出し階層図

```
BackgroundQueue (インデックス処理)
    │
    └─ ClangdServer::Callbacks::onBackgroundIndexProgress()
           │
           └─ ClangdLSPServer::onBackgroundIndexProgress()
                  │
                  └─ NotifyProgress(Stats)
                         │
                         ├─ [Completed < Enqueued]
                         │      └─ ReportWorkDoneProgress送信
                         │
                         └─ [Completed >= Enqueued]
                                ├─ EndWorkDoneProgress送信
                                └─ State = Empty
```

### データフロー図

```
[入力]                    [処理]                         [出力]

BackgroundQueue::Stats ───▶ 完了判定 ───▶ ProgressParams<WorkDoneProgressEnd>
    │                           │                        │
    │ Completed                 ▼                        ▼
    │ Enqueued         Completed >= Enqueued?          toJSON()
    │                           │                        │
    │                           ▼                        ▼
    │                  WorkDoneProgressEnd構築     JSON-RPC通知
    │                  kind = "end"                      │
    │                                                    ▼
    └──────────────────────────────────────▶ [LSPクライアント]
                                                   プログレスバー終了
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Protocol.h | `clang-tools-extra/clangd/Protocol.h` | ヘッダ | WorkDoneProgressEnd定義 |
| Protocol.cpp | `clang-tools-extra/clangd/Protocol.cpp` | ソース | JSON変換実装 |
| ClangdLSPServer.h | `clang-tools-extra/clangd/ClangdLSPServer.h` | ヘッダ | EndWorkDoneProgress通知宣言 |
| ClangdLSPServer.cpp | `clang-tools-extra/clangd/ClangdLSPServer.cpp` | ソース | Progress送信ロジック |
| LSPBinder.h | `clang-tools-extra/clangd/LSPBinder.h` | ヘッダ | LSPメソッドバインディング |
| Transport.h | `clang-tools-extra/clangd/Transport.h` | ヘッダ | 通信層インターフェース |
