---
generated_at: 2026-02-01 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：1-PublishDiagnostics

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **toLSPDiags関数の詳細実装**：Diagnostics.cppを直接確認していないため、変換ロジックの詳細は推測を含む

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `clang-tools-extra/clangd/Protocol.h` 行982-990 PublishDiagnosticsParams構造体定義
- E-02: `clang-tools-extra/clangd/Protocol.cpp` 行773-781 toJSON(PublishDiagnosticsParams)実装
- E-03: `clang-tools-extra/clangd/ClangdLSPServer.cpp` 行1809-1841 onDiagnosticsReady実装
- E-04: `clang-tools-extra/clangd/ClangdLSPServer.cpp` 行1734 PublishDiagnosticsバインド
- E-05: `clang-tools-extra/clangd/ClangdLSPServer.cpp` 行469-474 notify関数
- E-06: `clang-tools-extra/clangd/ClangdLSPServer.cpp` 行932-953 onDocumentDidClose（空診断送信）
- E-07: `clang-tools-extra/clangd/Protocol.h` 行931-976 Diagnostic構造体定義
- E-08: `clang-tools-extra/clangd/ClangdLSPServer.h` 行195 PublishDiagnostics宣言
- E-09: `clang-tools-extra/clangd/Protocol.cpp` 行733-757 toJSON(Diagnostic)実装

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | メソッド名は textDocument/publishDiagnostics | E-04 | ○ |
| C-02 | PublishDiagnosticsParamsにuri, version, diagnosticsが含まれる | E-01 | ○ |
| C-03 | onDiagnosticsReadyコールバックで診断が処理される | E-03 | ○ |
| C-04 | ドキュメントを閉じた時に空の診断リストを送信 | E-06 | ○ |
| C-05 | Diagnostic構造体にrange, severity, code, message等が含まれる | E-07 | ○ |
| C-06 | notify関数がTransport層へ通知を送信 | E-05 | ○ |
| C-07 | clangd拡張としてcategoryフィールドをサポート | E-07, E-09 | ○ |
| C-08 | clangd拡張としてcodeActionsフィールドをサポート | E-07, E-09 | ○ |
| C-09 | severityは1=Error, 2=Warning, 3=Info, 4=Hint | E-07 | ○ |
| C-10 | versionフィールドはオプショナル | E-01, E-02 | ○ |
| C-11 | バインドはBind.outgoingNotificationで行われる | E-04 | ○ |
| C-12 | DiagRefMapで診断のキャッシュを管理 | E-03 | ○ |
| C-13 | toLSPDiagsで内部診断をLSP形式に変換 | E-03 | ○ |
| C-14 | relatedInformationフィールドをサポート | E-07 | ○ |
| C-15 | codeDescriptionフィールドをサポート | E-07 | ○ |
| C-16 | tagsフィールド（Deprecated, Unnecessary等）をサポート | E-07 | ○ |
| C-17 | didOpen/didChangeでドキュメント変更時に診断送信 | E-03 | ○ |
| C-18 | toLSPDiags関数の詳細な変換ロジック | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Diagnostics.cppを直接読み込んでいないため、toLSPDiags関数の詳細実装は未確認
  - 候補：`clang-tools-extra/clangd/Diagnostics.cpp` / `clang-tools-extra/clangd/Diagnostics.h`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - LSP標準仕様に準拠した通知であり、Protocol.h/cppで明確に定義されている
- 0: 低リスク - onDiagnosticsReadyの実装が明確に確認できる
- 1: 中リスク - toLSPDiags関数の詳細実装は別ファイルにあり、変換ロジックの完全な把握には追加調査が必要

## 6) レビュアーチェックリスト（最小）
- [ ] Protocol.h行982-990のPublishDiagnosticsParams定義が設計書と一致するか確認
- [ ] ClangdLSPServer.cpp行1809-1841のonDiagnosticsReady実装フローが正確か確認
- [ ] Diagnostics.cppのtoLSPDiags関数を確認し、変換ロジックの詳細を補完
- [ ] LSP仕様書との整合性確認（severity値のマッピング等）
