---
generated_at: 2026-02-01 11:15:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：10-DirectoryWatcher Removed

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `clang/include/clang/DirectoryWatcher/DirectoryWatcher.h` 行66-100 Event構造体定義
- E-02: `clang/include/clang/DirectoryWatcher/DirectoryWatcher.h` 行68 EventKind::Removed定義
- E-03: `clang/include/clang/DirectoryWatcher/DirectoryWatcher.h` 行34-36 既知の不整合についてのコメント
- E-04: `clang/lib/DirectoryWatcher/linux/DirectoryWatcher-linux.cpp` 行255-257 Removed判定条件
- E-05: `clang/lib/DirectoryWatcher/linux/DirectoryWatcher-linux.cpp` 行258-262 WatchedDirRemoved判定
- E-06: `clang/lib/DirectoryWatcher/mac/DirectoryWatcher-mac.cpp` 行134-137 ItemRemoved判定
- E-07: `clang/lib/DirectoryWatcher/mac/DirectoryWatcher-mac.cpp` 行139-141 ファイル不存在でRemoved

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | EventKind::Removedが定義されている | E-02 | ○ |
| C-02 | Event構造体にKindとFilenameが含まれる | E-01 | ○ |
| C-03 | Linux: IN_DELETE/MOVED_FROMでRemoved発行 | E-04 | ○ |
| C-04 | Linux: Queue.push_backでイベントをキューイング | E-04 | ○ |
| C-05 | Linux: IN_DELETE_SELF/MOVE_SELFでWatchedDirRemoved | E-05 | ○ |
| C-06 | macOS: kFSEventStreamEventFlagItemRemovedでRemoved発行 | E-06 | ○ |
| C-07 | macOS: ファイル不存在でもRemoved発行 | E-07 | ○ |
| C-08 | macOS: Events.emplace_backでイベント配列に追加 | E-06 | ○ |
| C-09 | macOS: llvm::sys::path::filenameでファイル名取得 | E-06 | ○ |
| C-10 | 初期スキャン前削除でAdded通知なしにRemoved通知可能 | E-03 | ○ |
| C-11 | Receiverコールバックでイベント配信 | E-01 | ○ |
| C-12 | サブディレクトリ非サポート | E-01 | ○ |
| C-13 | Linux: epoll_waitでイベント待機 | E-04 | ○ |
| C-14 | WatchedDirRemovedは別イベントとして処理 | E-05 | ○ |
| C-15 | create()静的メソッドでインスタンス作成 | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 公開APIインターフェースが明確に定義されている
- 0: 低リスク - プラットフォーム依存の実装が明確に分離されている
- 1: 中リスク - 初期スキャン前のファイル削除でAdded通知なしにRemoved通知が発生する可能性（受信者側での対応が必要）

## 6) レビュアーチェックリスト（最小）
- [ ] DirectoryWatcher.h行66-100のEvent構造体定義が設計書と一致するか確認
- [ ] DirectoryWatcher-linux.cpp行255-257のRemoved判定条件を確認
- [ ] DirectoryWatcher-mac.cpp行134-137のRemoved判定条件を確認
- [ ] DirectoryWatcher-mac.cpp行139-141のファイル不存在時のRemoved処理を確認
- [ ] 初期スキャン前削除の処理方針を確認
