---
generated_at: 2026-02-01 23:15:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：11-DirectoryWatcher_WatchedDirRemoved

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. 該当なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `clang/include/clang/DirectoryWatcher/DirectoryWatcher.h` 行66-100（Event構造体・EventKind定義）
- E-02: `clang/include/clang/DirectoryWatcher/DirectoryWatcher.h` 行72-90（WatchedDirRemovedコメント説明）
- E-03: `clang/lib/DirectoryWatcher/linux/DirectoryWatcher-linux.cpp` 行258-261（Linux実装のWatchedDirRemoved生成）
- E-04: `clang/lib/DirectoryWatcher/linux/DirectoryWatcher-linux.cpp` 行164-168（StopWork実装）
- E-05: `clang/lib/DirectoryWatcher/mac/DirectoryWatcher-mac.cpp` 行124-131（macOS実装のWatchedDirRemoved生成）
- E-06: `clang/lib/DirectoryWatcher/linux/DirectoryWatcher-linux.cpp` 行333-340（inotifyイベントフラグ）
- E-07: `clang/lib/DirectoryWatcher/mac/DirectoryWatcher-mac.cpp` 行97-99（FSEventsフラグ定義）
- E-08: `clang/unittests/DirectoryWatcher/DirectoryWatcherTest.cpp` 行419-440（DeleteWatchedDirテスト）
- E-09: `clang/include/clang/DirectoryWatcher/DirectoryWatcher.h` 行106-111（create静的メソッド）
- E-10: `clang/lib/DirectoryWatcher/linux/DirectoryWatcher-linux.cpp` 行79-110（EventQueueクラス）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | WatchedDirRemovedはEventKind列挙型のメンバーである | E-01 | ○ |
| C-02 | 監視対象ディレクトリが削除されると発生する | E-02, E-03, E-05 | ○ |
| C-03 | Linuxではinotifyの`IN_DELETE_SELF`/`IN_MOVE_SELF`で検出 | E-03, E-06 | ○ |
| C-04 | macOSではFSEventsの`kFSEventStreamEventFlagItemRemoved`で検出 | E-05, E-07 | ○ |
| C-05 | Filenameは空文字列である | E-01, E-03, E-05 | ○ |
| C-06 | WatchedDirRemovedの後にWatcherGotInvalidatedが送信される | E-03, E-04, E-05 | ○ |
| C-07 | Receiverコールバックで通知される | E-09 | ○ |
| C-08 | create()でReceiverを登録する | E-09 | ○ |
| C-09 | 非同期でイベントキュー経由で送信（Linux） | E-04, E-10 | ○ |
| C-10 | StopWork()がWatcherGotInvalidatedをキューに追加 | E-04 | ○ |
| C-11 | テストでremove_directories()後にイベント発生を確認 | E-08 | ○ |
| C-12 | WatchedDirRemovedとWatcherGotInvalidatedの両方が期待される | E-08 | ○ |
| C-13 | Linux実装でepoll+inotifyを使用 | E-03 | ○ |
| C-14 | macOS実装でdispatch_queue+FSEventsを使用 | E-05 | ○ |
| C-15 | ファイルディスクリプタはCLOEXECで保護 | E-06 | ○ |
| C-16 | Event構造体はKindとFilenameを持つ | E-01 | ○ |
| C-17 | IsInitialフラグはfalse（実行時イベント） | E-08 | ○ |
| C-18 | サブディレクトリはサポート外 | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] EventKind::WatchedDirRemovedの定義が正しいことを確認（DirectoryWatcher.h 行72）
- [ ] Linux実装のIN_DELETE_SELF/IN_MOVE_SELF処理を確認（DirectoryWatcher-linux.cpp 行258-261）
- [ ] macOS実装のkFSEventStreamEventFlagItemRemoved処理を確認（DirectoryWatcher-mac.cpp 行124-131）
- [ ] テストケースDeleteWatchedDirが期待動作を確認していることを確認（DirectoryWatcherTest.cpp 行419-440）
