---
generated_at: 2026-02-01 23:20:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：12-DirectoryWatcher_WatcherGotInvalidated

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  1. 該当なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `clang/include/clang/DirectoryWatcher/DirectoryWatcher.h` 行73-90（WatcherGotInvalidated定義とコメント）
- E-02: `clang/lib/DirectoryWatcher/linux/DirectoryWatcher-linux.cpp` 行164-168（StopWork実装）
- E-03: `clang/lib/DirectoryWatcher/linux/DirectoryWatcher-linux.cpp` 行120-126（Linuxデストラクタ）
- E-04: `clang/lib/DirectoryWatcher/mac/DirectoryWatcher-mac.cpp` 行56-71（macOSデストラクタ）
- E-05: `clang/lib/DirectoryWatcher/mac/DirectoryWatcher-mac.cpp` 行97-99（StreamInvalidatingFlags定義）
- E-06: `clang/lib/DirectoryWatcher/mac/DirectoryWatcher-mac.cpp` 行117-120（StreamInvalidatingFlagsチェック）
- E-07: `clang/lib/DirectoryWatcher/linux/DirectoryWatcher-linux.cpp` 行258-265（IN_DELETE_SELF/IN_IGNORED処理）
- E-08: `clang/unittests/DirectoryWatcher/DirectoryWatcherTest.cpp` 行442-461（InvalidatedWatcherテスト）
- E-09: `clang/unittests/DirectoryWatcher/DirectoryWatcherTest.cpp` 行463-500（InvalidatedWatcherAsyncテスト）
- E-10: `clang/lib/DirectoryWatcher/mac/DirectoryWatcher-mac.cpp` 行128-131（ディレクトリ削除後のWatcherGotInvalidated）
- E-11: `clang/lib/DirectoryWatcher/mac/DirectoryWatcher-mac.cpp` 行150-152（不明イベント時のWatcherGotInvalidated）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | WatcherGotInvalidatedはEventKind列挙型のメンバーである | E-01 | ○ |
| C-02 | ライフタイム中に少なくとも1回は受信が保証される | E-01 | ○ |
| C-03 | リソース制限超過時に発生する | E-01, E-05, E-06 | ○ |
| C-04 | 監視対象ディレクトリ削除後に発生する | E-01, E-07, E-10 | ○ |
| C-05 | デストラクタ呼び出し時に発生する | E-01, E-03, E-04 | ○ |
| C-06 | Filenameは空文字列である | E-01, E-02, E-04 | ○ |
| C-07 | Linux実装でStopWork()がキューにプッシュ | E-02 | ○ |
| C-08 | macOS実装でdispatch_syncを使用 | E-04 | ○ |
| C-09 | StreamInvalidatingFlagsマスクで検出（macOS） | E-05, E-06 | ○ |
| C-10 | UserDropped/KernelDropped/MustScanSubDirsフラグを含む | E-05 | ○ |
| C-11 | IN_DELETE_SELF後にStopWork()が呼ばれる（Linux） | E-07 | ○ |
| C-12 | IN_IGNORED後にStopWork()が呼ばれる（Linux） | E-07 | ○ |
| C-13 | デストラクタでスレッドのjoinを待機（Linux） | E-03 | ○ |
| C-14 | デストラクタでdispatch_sync内でReceiver呼び出し（macOS） | E-04 | ○ |
| C-15 | 不明イベント時にもWatcherGotInvalidatedが生成される | E-11 | ○ |
| C-16 | テストでスコープ終了でWatcherGotInvalidatedが送信される | E-08 | ○ |
| C-17 | 非同期モードでもWatcherGotInvalidatedが正しく送信される | E-09 | ○ |
| C-18 | この通知後のWatcher動作は未定義 | E-01 | ○ |
| C-19 | WatchedDirRemovedの後にWatcherGotInvalidatedが送信される | E-07, E-10 | ○ |
| C-20 | InotifyPollingStopSignal.signal()でポーリングスレッドに停止通知 | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] WatcherGotInvalidatedの定義とコメントを確認（DirectoryWatcher.h 行73-90）
- [ ] Linux実装のStopWork()を確認（DirectoryWatcher-linux.cpp 行164-168）
- [ ] macOS実装のデストラクタでdispatch_sync使用を確認（DirectoryWatcher-mac.cpp 行56-71）
- [ ] StreamInvalidatingFlagsの定義を確認（DirectoryWatcher-mac.cpp 行97-99）
- [ ] InvalidatedWatcherテストを確認（DirectoryWatcherTest.cpp 行442-461）
