---
generated_at: 2026-02-01 23:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：14-PR_Greeter

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. 該当なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `.github/workflows/new-prs.yml` 行1（ワークフロー名: Labelling new pull requests）
- E-02: `.github/workflows/new-prs.yml` 行10-14（トリガー: pull_request_target）
- E-03: `.github/workflows/new-prs.yml` 行19-21（権限: pull-requests: write）
- E-04: `.github/workflows/new-prs.yml` 行28-34（author_associationフィルタ）
- E-05: `.github/workflows/new-prs.yml` 行29（条件: github.event.action == 'opened'）
- E-06: `.github/workflows/new-prs.yml` 行36-40（sparse-checkout: llvm/utils/git/、ref: main）
- E-07: `.github/workflows/new-prs.yml` 行42-45（pip install requirements.txt）
- E-08: `.github/workflows/new-prs.yml` 行47-53（github-automation.py pr-greeter実行）
- E-09: `llvm/utils/git/github-automation.py` 行229-230（PRGreeterクラスとCOMMENT_TAG定義）
- E-10: `llvm/utils/git/github-automation.py` 行232-234（コンストラクタ）
- E-11: `llvm/utils/git/github-automation.py` 行236-258（run()メソッドと歓迎コメント）
- E-12: `llvm/utils/git/github-automation.py` 行242-256（歓迎メッセージテンプレート）
- E-13: `llvm/utils/git/github-automation.py` 行257（create_comment呼び出し）
- E-14: `llvm/utils/git/github-automation.py` 行330-344（PRBuildbotInformation.should_comment）
- E-15: `llvm/utils/git/github-automation.py` 行847-848（pr-greeterサブコマンド定義）
- E-16: `llvm/utils/git/github-automation.py` 行920-922（pr-greeter実行部分）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | pull_request_targetイベントでトリガー | E-02 | ○ |
| C-02 | openedイベントでのみ実行 | E-05 | ○ |
| C-03 | author_associationがNONE相当の場合のみ実行 | E-04 | ○ |
| C-04 | COLLABORATOR, CONTRIBUTOR, MANNEQUIN, MEMBER, OWNERを除外 | E-04 | ○ |
| C-05 | pull-requests:write権限で動作 | E-03 | ○ |
| C-06 | llvm/utils/git/のみをsparse-checkout | E-06 | ○ |
| C-07 | mainブランチを参照 | E-06 | ○ |
| C-08 | requirements.txtから依存関係をインストール | E-07 | ○ |
| C-09 | github-automation.py pr-greeterを実行 | E-08 | ○ |
| C-10 | COMMENT_TAGは`<!--LLVM NEW CONTRIBUTOR COMMENT-->` | E-09 | ○ |
| C-11 | PRGreeterクラスが歓迎コメントを投稿 | E-11, E-13 | ○ |
| C-12 | 歓迎メッセージにレビュアー依頼方法を含む | E-12 | ○ |
| C-13 | 歓迎メッセージにPing推奨頻度を含む | E-12 | ○ |
| C-14 | 歓迎メッセージにGitHub User Guideリンクを含む | E-12 | ○ |
| C-15 | 歓迎メッセージにDiscord・フォーラムリンクを含む | E-12 | ○ |
| C-16 | pr.as_issue().create_comment()でコメント投稿 | E-13 | ○ |
| C-17 | PRBuildbotInformationがCOMMENT_TAGを参照 | E-14 | ○ |
| C-18 | pr-greeterサブコマンドがPRGreeterを実行 | E-15, E-16 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] トリガー条件（pull_request_target.opened）を確認（new-prs.yml 行10-14, 29）
- [ ] author_associationフィルタを確認（new-prs.yml 行28-34）
- [ ] PRGreeterクラスの歓迎メッセージを確認（github-automation.py 行242-256）
- [ ] COMMENT_TAGの定義を確認（github-automation.py 行230）
