---
generated_at: 2026-02-01 10:35:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：2-ShowMessage

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `clang-tools-extra/clangd/Protocol.h` 行732-741 MessageType enum定義
- E-02: `clang-tools-extra/clangd/Protocol.h` 行744-752 ShowMessageParams構造体定義
- E-03: `clang-tools-extra/clangd/Protocol.cpp` 行620-626 toJSON(MessageType), toJSON(ShowMessageParams)
- E-04: `clang-tools-extra/clangd/ClangdLSPServer.h` 行194 ShowMessage通知宣言
- E-05: `clang-tools-extra/clangd/ClangdLSPServer.cpp` 行1737 ShowMessageバインド
- E-06: `clang-tools-extra/clangd/ClangdLSPServer.cpp` 行819-824 onCommandApplyTweak内でのShowMessage使用

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | メソッド名は window/showMessage | E-05 | ○ |
| C-02 | ShowMessageParamsにtype, messageが含まれる | E-02 | ○ |
| C-03 | MessageTypeはError=1, Warning=2, Info=3, Log=4 | E-01 | ○ |
| C-04 | typeは整数値としてシリアライズされる | E-03 | ○ |
| C-05 | Tweak適用時にShowMessageが使用される | E-06 | ○ |
| C-06 | ShowMessageParams構築時にtype=MessageType::Infoを使用 | E-06 | ○ |
| C-07 | バインドはBind.outgoingNotificationで行われる | E-05 | ○ |
| C-08 | ShowMessage通知はLSPBinder::OutgoingNotification型 | E-04 | ○ |
| C-09 | Effect::ShowMessageの存在確認後に送信 | E-06 | ○ |
| C-10 | messageフィールドにR->ShowMessageの値を設定 | E-06 | ○ |
| C-11 | notify関数経由でTransportに送信 | E-05 | ○ |
| C-12 | ShowMessageはドキュメント固有ではないセッション全体への通知 | E-02, E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - LSP標準仕様に準拠した通知であり、Protocol.h/cppで明確に定義されている
- 0: 低リスク - 使用箇所が明確に特定できる（主にTweak機能）

## 6) レビュアーチェックリスト（最小）
- [ ] Protocol.h行732-741のMessageType enum値が設計書と一致するか確認
- [ ] Protocol.h行744-752のShowMessageParams定義が設計書と一致するか確認
- [ ] ClangdLSPServer.cpp行819-824のShowMessage使用箇所が正確か確認
- [ ] LSP仕様書との整合性確認（MessageType値のマッピング等）
