---
generated_at: 2026-02-01 10:40:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：3-NotifyFileStatus

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **TUStatus::render()の詳細実装**：TUScheduler.hを直接確認していないため、状態文字列の詳細は推測を含む

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `clang-tools-extra/clangd/Protocol.h` 行1849-1858 FileStatus構造体定義
- E-02: `clang-tools-extra/clangd/Protocol.cpp` 行1279-1284 toJSON(FileStatus)実装
- E-03: `clang-tools-extra/clangd/ClangdLSPServer.h` 行196 NotifyFileStatus通知宣言
- E-04: `clang-tools-extra/clangd/ClangdLSPServer.cpp` 行1738 NotifyFileStatusバインド
- E-05: `clang-tools-extra/clangd/ClangdLSPServer.cpp` 行1924-1936 onFileUpdatedコールバック
- E-06: `clang-tools-extra/clangd/ClangdLSPServer.cpp` 行540 SupportFileStatus設定
- E-07: `clang-tools-extra/clangd/Protocol.h` 行610 InitializationOptions::FileStatus

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | メソッド名は textDocument/clangd.fileStatus | E-04 | ○ |
| C-02 | FileStatusにuri, stateが含まれる | E-01 | ○ |
| C-03 | SupportFileStatus=falseの場合は通知されない | E-05 | ○ |
| C-04 | BuildingFile状態は通知されない | E-05 | ○ |
| C-05 | RunningAction状態は通知されない | E-05 | ○ |
| C-06 | initializationOptions.FileStatusで有効化 | E-06, E-07 | ○ |
| C-07 | バインドはBind.outgoingNotificationで行われる | E-04 | ○ |
| C-08 | Status.render(File)で状態文字列を生成 | E-05 | ○ |
| C-09 | PreambleActivity==Idleの条件チェック | E-05 | ○ |
| C-10 | ASTActivity.K==Buildingの条件チェック | E-05 | ○ |
| C-11 | ASTActivity.K==RunningActionの条件チェック | E-05 | ○ |
| C-12 | clangd独自の拡張機能 | E-04 | ○ |
| C-13 | FileStatusはLSPBinder::OutgoingNotification型 | E-03 | ○ |
| C-14 | 状態文字列の具体的な値（idle, parsing等） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- TUScheduler.hおよびTUStatus::render()の実装を直接確認していないため、状態文字列の具体的な値は推測を含む
  - 候補：`clang-tools-extra/clangd/TUScheduler.h` / `clang-tools-extra/clangd/TUScheduler.cpp`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - clangd拡張機能であり、Protocol.h/cppで定義が確認できる
- 0: 低リスク - onFileUpdatedコールバックの実装が明確に確認できる
- 1: 中リスク - TUStatus::render()の詳細実装は別ファイルにあり、状態文字列の完全な把握には追加調査が必要

## 6) レビュアーチェックリスト（最小）
- [ ] Protocol.h行1849-1858のFileStatus定義が設計書と一致するか確認
- [ ] ClangdLSPServer.cpp行1924-1936のonFileUpdated実装フローが正確か確認
- [ ] TUScheduler.hのTUStatus::render()を確認し、状態文字列の詳細を補完
- [ ] InitializationOptions.FileStatusの設定フローを確認
