---
generated_at: 2026-02-01 10:45:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：4-PublishInactiveRegions

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `clang-tools-extra/clangd/Protocol.h` 行1933-1941 InactiveRegionsParams構造体定義
- E-02: `clang-tools-extra/clangd/Protocol.cpp` 行1342-1346 toJSON(InactiveRegionsParams)実装
- E-03: `clang-tools-extra/clangd/ClangdLSPServer.h` 行197 PublishInactiveRegions通知宣言
- E-04: `clang-tools-extra/clangd/ClangdLSPServer.cpp` 行1735-1736 PublishInactiveRegions条件付きバインド
- E-05: `clang-tools-extra/clangd/ClangdLSPServer.cpp` 行1843-1850 onInactiveRegionsReadyコールバック
- E-06: `clang-tools-extra/clangd/Protocol.h` 行567-570 ClientCapabilities::InactiveRegions
- E-07: `clang-tools-extra/clangd/ClangdLSPServer.cpp` 行550 Opts.PublishInactiveRegions設定
- E-08: `clang-tools-extra/clangd/ClangdLSPServer.cpp` 行650 サーバーcapabilities設定

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | メソッド名は textDocument/inactiveRegions | E-04 | ○ |
| C-02 | InactiveRegionsParamsにTextDocument, regionsが含まれる | E-01 | ○ |
| C-03 | regionsはRange配列として送信される | E-01, E-02 | ○ |
| C-04 | Caps.InactiveRegionsで条件付きバインド | E-04 | ○ |
| C-05 | onInactiveRegionsReadyコールバックで処理 | E-05 | ○ |
| C-06 | ClientCapabilities::InactiveRegionsでサポート判定 | E-06 | ○ |
| C-07 | Opts.PublishInactiveRegionsで有効化 | E-07 | ○ |
| C-08 | inactiveRegionsProvider: trueをサーバーcapabilitiesで設定 | E-08 | ○ |
| C-09 | TextDocument.uriにURIForFile::canonicalizeを使用 | E-05 | ○ |
| C-10 | clangd独自の拡張機能 | E-04 | ○ |
| C-11 | PublishInactiveRegionsはLSPBinder::OutgoingNotification型 | E-03 | ○ |
| C-12 | バインドはBind.outgoingNotificationで行われる | E-04 | ○ |
| C-13 | 条件付きでバインドされる（if文で囲まれている） | E-04 | ○ |
| C-14 | InactiveRegionsにstd::vector<Range>を設定 | E-05 | ○ |
| C-15 | toJSONでtextDocument, regionsをシリアライズ | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - clangd拡張機能であり、Protocol.h/cppで定義が確認できる
- 0: 低リスク - onInactiveRegionsReadyコールバックの実装が明確に確認できる
- 0: 低リスク - 条件付きバインドのロジックが明確

## 6) レビュアーチェックリスト（最小）
- [ ] Protocol.h行1933-1941のInactiveRegionsParams定義が設計書と一致するか確認
- [ ] ClangdLSPServer.cpp行1843-1850のonInactiveRegionsReady実装フローが正確か確認
- [ ] ClangdLSPServer.cpp行1735-1736の条件付きバインドロジックを確認
- [ ] ClientCapabilities::InactiveRegionsの設定フローを確認
