---
generated_at: 2026-02-01 11:05:00
metrics:
  claims_total: 11
  claims_with_evidence: 11
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：8-SemanticTokensRefresh

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：11 / 11、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `clang-tools-extra/clangd/Protocol.h` 行559 SemanticTokenRefreshSupport定義
- E-02: `clang-tools-extra/clangd/Protocol.cpp` 行480-482 refreshSupportパース実装
- E-03: `clang-tools-extra/clangd/ClangdLSPServer.h` 行206 SemanticTokensRefresh宣言
- E-04: `clang-tools-extra/clangd/ClangdLSPServer.cpp` 行1743-1744 条件付きバインド
- E-05: `clang-tools-extra/clangd/ClangdLSPServer.cpp` 行1938-1946 onSemanticsMaybeChanged実装

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | メソッド名は workspace/semanticTokens/refresh | E-04 | ○ |
| C-02 | NoParamsで送信される | E-03, E-05 | ○ |
| C-03 | Caps.SemanticTokenRefreshSupportで条件付きバインド | E-04 | ○ |
| C-04 | onSemanticsMaybeChangedコールバックで送信 | E-05 | ○ |
| C-05 | SemanticTokenRefreshSupportはClientCapabilitiesで定義 | E-01 | ○ |
| C-06 | workspace.semanticTokens.refreshSupportでパース | E-02 | ○ |
| C-07 | LSPBinder::OutgoingMethod型 | E-03 | ○ |
| C-08 | Bind.outgoingMethodでバインド | E-04 | ○ |
| C-09 | 失敗時にelogでエラーログ出力 | E-05 | ○ |
| C-10 | レスポンスはstd::nullptr_t | E-03 | ○ |
| C-11 | SemanticTokensRefresh有効性をif文で確認 | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - LSP標準仕様に準拠したリクエストであり、実装が明確に確認できる
- 0: 低リスク - 条件付きバインドのロジックが明確

## 6) レビュアーチェックリスト（最小）
- [ ] Protocol.h行559のSemanticTokenRefreshSupport定義が設計書と一致するか確認
- [ ] ClangdLSPServer.cpp行1743-1744の条件付きバインドロジックを確認
- [ ] ClangdLSPServer.cpp行1938-1946のonSemanticsMaybeChanged実装フローが正確か確認
- [ ] LSP仕様書との整合性確認
