---
generated_at: 2026-02-01 23:30:00
metrics:
  claims_total: 45
  claims_with_evidence: 38
  claims_without_evidence: 7
confidence_derived: 0.84
---

# 根拠レポート：運用マニュアル

## 本レポートについて

### 目的
本レポートは、生成された運用マニュアルの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.84**
  - 根拠あり：38 / 45、根拠なし：7
- 優先レビュー（高）
  1. **対応プラットフォーム詳細**：動作環境の詳細仕様が確認できない
  2. **コマンドラインオプション**：LLDBのコマンドラインオプションの完全性
  3. **トラブルシューティング詳細**：エラーメッセージと対処法の網羅性

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `docs/code-to-docs/画面設計書/1-メインウィンドウ.md`
- E-02: `docs/code-to-docs/画面設計書/2-メニューバー.md`
- E-03: `docs/code-to-docs/画面設計書/3-ソースビュー.md`
- E-04: `docs/code-to-docs/画面設計書/4-変数ビュー.md`
- E-05: `docs/code-to-docs/画面設計書/5-スレッドビュー.md`
- E-06: `docs/code-to-docs/画面設計書/6-ステータスバー.md`
- E-07: `docs/code-to-docs/画面設計書/7-ヘルプダイアログ.md`
- E-08: `docs/code-to-docs/画面設計書/8-ターゲット作成フォーム.md`
- E-09: `docs/code-to-docs/画面設計書/9-プロセスアタッチフォーム.md`
- E-10: `docs/code-to-docs/画面設計書/10-プロセス起動フォーム.md`
- E-11: `docs/code-to-docs/画面設計書/11-デタッチキル確認フォーム.md`
- E-12: `docs/code-to-docs/画面設計書/12-レジスタビュー.md`
- E-13: `docs/code-to-docs/画面設計書/13-ブレークポイントビュー.md`
- E-14: `docs/code-to-docs/画面設計書/14-検索ウィンドウ.md`
- E-15: `docs/code-to-docs/画面一覧/画面遷移図.md`
- E-16: `docs/code-to-docs/業務要件一覧/業務要件一覧.csv`
- E-17: `docs/code-to-docs/README.md`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | システム概要（LLDB Curses GUIはテキストベースGUI） | E-01, E-17 | ○ |
| C-02 | メインウィンドウのレイアウト構成 | E-01, E-15 | ○ |
| C-03 | TABキーでビュー切り替え | E-01 | ○ |
| C-04 | F1-F6キーでメニューアクセス | E-01, E-15 | ○ |
| C-05 | ESCキーで終了 | E-01, E-15 | ○ |
| C-06 | hキーでヘルプ表示 | E-01, E-07 | ○ |
| C-07 | ターゲット作成フォームの項目（Executable, Core File, Symbol File） | E-08 | ○ |
| C-08 | ターゲット作成の詳細設定項目 | E-08 | ○ |
| C-09 | プロセス起動フォームの項目 | E-10 | ○ |
| C-10 | プロセスアタッチフォームの項目 | E-09 | ○ |
| C-11 | プロセスアタッチ方式（Name/PID） | E-09 | ○ |
| C-12 | デタッチ/キル確認フォームの動作 | E-11 | ○ |
| C-13 | ソースビューのキーボードショートカット | E-03 | ○ |
| C-14 | bキーでブレークポイント設定 | E-03 | ○ |
| C-15 | ステップ実行操作（n/N/s/S/f） | E-03 | ○ |
| C-16 | cキーでプロセス続行 | E-03 | ○ |
| C-17 | u/dキーでフレーム移動 | E-03 | ○ |
| C-18 | Enterキーでワンショットブレークポイント実行 | E-03 | ○ |
| C-19 | 変数ビューの操作方法 | E-04 | ○ |
| C-20 | 変数フォーマット変更キー一覧 | E-04, E-12 | ○ |
| C-21 | スレッドビューの操作方法 | E-05 | ○ |
| C-22 | スレッドビューのツリー構造 | E-05 | ○ |
| C-23 | レジスタビューの表示方法（F5メニュー） | E-12 | ○ |
| C-24 | レジスタビューのフォーマット変更 | E-12 | ○ |
| C-25 | ブレークポイントビューの表示方法 | E-13 | ○ |
| C-26 | ブレークポイント詳細情報の内容 | E-13 | ○ |
| C-27 | ヘルプダイアログの表示方法 | E-01, E-07 | ○ |
| C-28 | 業務フロー（5ステップ構成） | E-16 | ○ |
| C-29 | デバッグ業務カテゴリ（ターゲット設定、プロセス制御、コード解析、実行制御、状態確認） | E-16 | ○ |
| C-30 | guiコマンドでGUIモード起動 | E-01 | ○ |
| C-31 | LLDB_ENABLE_CURSESが必要 | E-01 | ○ |
| C-32 | エラーメッセージ「Some fields are invalid!」 | E-08 | ○ |
| C-33 | エラーメッセージ「Unknown core file format!」 | E-08 | ○ |
| C-34 | メッセージ「There is a running process」 | E-09, E-10 | ○ |
| C-35 | Process メニュー項目（Continue, Halt, Kill, Detach等） | E-15 | ○ |
| C-36 | Thread メニュー項目（Step In, Step Over, Step Out） | E-15 | ○ |
| C-37 | View メニュー項目（Backtrace, Registers, Source, Variables, Breakpoints） | E-15 | ○ |
| C-38 | ソースファイルがない場合は逆アセンブリ表示 | E-03 | ○ |
| C-39 | 対応プラットフォーム（Linux, macOS, FreeBSD） | **根拠なし** | △ |
| C-40 | 推奨ターミナルサイズ（80x24） | **根拠なし** | △ |
| C-41 | LLDBコミュニティの連絡先URL | **根拠なし** | △ |
| C-42 | コアファイル解析のワークフロー | **根拠なし** | △ |
| C-43 | SSH経由でのリモートデバッグ対応 | **根拠なし** | △ |
| C-44 | パスワードリセット手順（該当なし） | **根拠なし** | △ |
| C-45 | バグ報告時に含める情報 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **対応プラットフォームの詳細仕様**：LLDBの動作プラットフォームについて、既存設計書では明示的な記載がなく、一般的なLLDBの知識に基づいて記載
  - 候補：LLDB公式ドキュメント / llvm-project/lldb/README.md / CMakeLists.txt
- **ターミナル要件**：最低限必要なターミナルサイズや対応ターミナルの詳細
  - 候補：ncurses依存関係の調査 / テスト環境の確認
- **コミュニティ連絡先**：LLVM/LLDBコミュニティの最新連絡先
  - 候補：LLVM公式サイト / GitHub README

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：画面操作関連の記載 - 画面設計書に詳細な根拠あり
- 0（低リスク）：キーボードショートカット - 画面設計書に根拠あり
- 1（中リスク）：業務フロー - デバッガとしての一般的なフローであり、妥当性は高いが明示的な根拠なし
- 1（中リスク）：トラブルシューティング - 一般的なデバッガの問題を想定しているが、実際のエラーメッセージは一部のみ確認
- 2（高リスク）：対応プラットフォーム・動作環境 - 既存設計書に根拠なし、要確認

## 6) レビュアーチェックリスト（最小）
- [ ] 対応プラットフォーム（Linux, macOS, FreeBSD）の記載が正確か確認
- [ ] 推奨ターミナルサイズ（80x24）が適切か確認
- [ ] LLDBコミュニティの連絡先URLが最新か確認
- [ ] トラブルシューティングのエラーメッセージが網羅的か確認
- [ ] SSH経由リモートデバッグの対応状況を確認
- [ ] 業務フローの5ステップ構成が実際のユースケースに適合しているか確認
- [ ] キーボードショートカット一覧が画面設計書と一致しているか確認
- [ ] メニュー項目一覧が画面遷移図と一致しているか確認
