# LLDB Curses GUI 業務運用マニュアル

## 目次

**【基本操作】**
1. [システム概要](#1-システム概要)
2. [起動・終了手順](#2-起動終了手順)
3. [メインウィンドウ（TOP画面）](#3-メインウィンドウtop画面)

**【業務フローに沿った機能】**
4. [【STEP1】ターゲット作成（デバッグ対象の設定）](#4-step1ターゲット作成デバッグ対象の設定)
5. [【STEP2-3】プロセス制御（実行・アタッチ）](#5-step2-3プロセス制御実行アタッチ)
6. [【STEP3-4】ソースコードビュー（コードの確認・操作）](#6-step3-4ソースコードビューコードの確認操作)
7. [【STEP4-5】デバッグ実行・解析（変数・スレッド・レジスタ確認）](#7-step4-5デバッグ実行解析変数スレッドレジスタ確認)

**【サポート機能】**
8. [ブレークポイント管理](#8-ブレークポイント管理)
9. [ヘルプ機能](#9-ヘルプ機能)
10. [検索機能](#10-検索機能)

**【運用ガイド】**
11. [日常業務の流れ](#11-日常業務の流れ)
12. [よくある質問と対処法](#12-よくある質問と対処法)
13. [トラブルシューティング](#13-トラブルシューティング)

---

## 1. システム概要

### 1.1 LLDB Curses GUIとは

LLDB Curses GUIは、LLVMプロジェクトに含まれるLLDBデバッガのテキストベースグラフィカルユーザーインターフェースです。ターミナル上で動作し、ncursesライブラリを使用して視覚的なデバッグ環境を提供します。

**主な特徴：**
- ターミナル環境でのGUIライクなデバッグ体験
- SSH経由でのリモートデバッグに対応
- 複数の情報（ソースコード、変数、スレッド状態）を同時に表示
- キーボードショートカットによる効率的な操作

### 1.2 本システムで行う主要業務

本システムは、主に以下のデバッグ業務を支援します：

| 業務カテゴリ | 具体的な業務内容 |
|------------|----------------|
| **ターゲット設定** | デバッグ対象の実行ファイル指定、シンボルファイル設定、コアファイル解析 |
| **プロセス制御** | プロセスの起動、実行中プロセスへのアタッチ、プロセスの停止・終了 |
| **コード解析** | ソースコードの閲覧、逆アセンブリ表示、ブレークポイント設定 |
| **実行制御** | ステップ実行（ステップイン/ステップオーバー/ステップアウト）、続行 |
| **状態確認** | 変数値の確認、スレッド状態の確認、レジスタ値の確認 |

### 1.3 業務フロー概要

本システムにおけるデバッグ作業は、以下の流れで進行します：

```
┌─────────────────────────────────────────────────────────────────┐
│                    デバッグ業務フロー                            │
├─────────────────────────────────────────────────────────────────┤
│                                                                 │
│  【STEP 1】ターゲット作成                                       │
│      ↓     デバッグ対象の実行ファイルを指定                      │
│                                                                 │
│  【STEP 2】プロセス起動/アタッチ                                 │
│      ↓     プロセスを起動、または実行中プロセスにアタッチ         │
│                                                                 │
│  【STEP 3】ブレークポイント設定                                  │
│      ↓     停止したい箇所にブレークポイントを設定                 │
│                                                                 │
│  【STEP 4】実行・ステップ実行                                    │
│      ↓     プログラムを実行し、問題箇所を特定                    │
│                                                                 │
│  【STEP 5】状態確認・解析                                        │
│            変数、スレッド、レジスタの状態を確認し問題を解析       │
│                                                                 │
└─────────────────────────────────────────────────────────────────┘
```

**役割別の業務概要：**

| 役割 | 主な業務 |
|------|---------|
| **開発者** | バグの原因調査、コードの動作確認、パフォーマンス分析 |
| **QAエンジニア** | 問題の再現確認、クラッシュダンプ解析 |
| **システムエンジニア** | 本番環境での問題調査、リモートデバッグ |

### 1.4 主な機能

| 機能 | 説明 | 業務フローでの位置 |
|------|------|------------------|
| ターゲット作成 | デバッグ対象の実行ファイルを設定 | STEP 1 |
| プロセス起動 | 設定した引数でプロセスを起動 | STEP 2 |
| プロセスアタッチ | 実行中のプロセスにアタッチ | STEP 2 |
| ブレークポイント | コードの特定行で停止を設定 | STEP 3 |
| ステップ実行 | 1行ずつ/関数単位で実行 | STEP 4 |
| 変数ビュー | ローカル変数の値を確認 | STEP 5 |
| スレッドビュー | スレッド一覧とスタックを確認 | STEP 5 |
| レジスタビュー | CPUレジスタの値を確認 | STEP 5 |

### 1.5 ユーザー種別

本システムは単一ユーザー向けのデバッガツールです：

| ユーザー種別 | 説明 |
|-------------|------|
| デバッグユーザー | LLDBを使用してプログラムをデバッグする開発者・エンジニア |

### 1.6 動作環境

**対応プラットフォーム：**
- Linux（各種ディストリビューション）
- macOS（10.12以降）
- FreeBSD

**必要条件：**
- LLDB（LLDB_ENABLE_CURSESを有効にしてビルド）
- ncursesライブラリ対応のターミナル
- 最低80x24文字のターミナルサイズ推奨

---

## 2. 起動・終了手順

### 2.1 起動方法

1. ターミナルを開きます

2. LLDBを起動します
   ```
   lldb
   ```

3. GUIモードに入ります
   ```
   (lldb) gui
   ```

4. Curses GUIのメインウィンドウが表示されます

**直接GUIモードで起動する場合：**
```
lldb --batch -o "target create <実行ファイル>" -o "gui"
```

### 2.2 終了方法

1. メインウィンドウで「ESC」キーを押します
2. GUIモードが終了し、LLDBコマンドラインに戻ります
3. LLDBを終了するには `quit` または `exit` コマンドを入力します

**メニューから終了する場合：**
1. 「F1」キーを押してLLDBメニューを開きます
2. 「Exit」を選択します

### 2.3 GUIモードへの再入場

GUIモードを一度終了した後、再度GUIモードに入るには：
```
(lldb) gui
```

---

## 3. メインウィンドウ（TOP画面）

### 3.1 画面レイアウト

メインウィンドウは以下のエリアで構成されています：

```
+------------------------------------------------------------------+
|                        メニューバー                               |
|  [F1:LLDB] [F2:Target] [F3:Process] [F4:Thread] [F5:View] [F6:Help]|
+------------------------------------------------------------------+
|                                          |                       |
|                                          |                       |
|              ソースビュー                 |    スレッドビュー      |
|          (ソースコード/逆アセンブリ)        |   (スレッド一覧)       |
|                                          |                       |
|                                          |                       |
|                                          +-----------------------+
|                                          |                       |
+------------------------------------------+   ブレークポイント     |
|                                          |    ビュー (オプション)  |
|              変数ビュー                   |                       |
|          (ローカル変数一覧)               +-----------------------+
|                                          |                       |
+------------------------------------------+                       |
|              レジスタビュー (オプション)    |                       |
+------------------------------------------------------------------+
|                       ステータスバー                              |
+------------------------------------------------------------------+
```

### 3.2 主要コンポーネント

| コンポーネント | 説明 |
|--------------|------|
| **メニューバー** | F1〜F6キーで各メニューにアクセス |
| **ソースビュー** | ソースコードまたは逆アセンブリを表示 |
| **変数ビュー** | 現在のフレームのローカル変数を表示 |
| **スレッドビュー** | プロセス内のスレッド一覧を表示 |
| **ステータスバー** | プロセス状態、スレッドID、フレーム情報を表示 |
| **レジスタビュー** | CPUレジスタの値を表示（オプション） |
| **ブレークポイントビュー** | 設定済みブレークポイント一覧（オプション） |

### 3.3 グローバルキーボードショートカット

| キー | 動作 |
|------|------|
| TAB | 次のビューにフォーカス切り替え |
| Shift+TAB | 前のビューにフォーカス切り替え |
| h | ヘルプダイアログを表示 |
| ESC | アプリケーション終了 |
| F1 | LLDBメニュー |
| F2 | Targetメニュー |
| F3 | Processメニュー |
| F4 | Threadメニュー |
| F5 | Viewメニュー |
| F6 | Helpメニュー |

---

## 4. 【STEP1】ターゲット作成（デバッグ対象の設定）

> **業務フローでの位置**: デバッグ作業の最初のステップとして、デバッグ対象となる実行ファイルを指定します。

### 4.1 ターゲット作成フォームを開く

1. メニューバーで「F2」キーを押してTargetメニューを開きます
2. 「Create」を選択します
3. ターゲット作成フォームが表示されます

### 4.2 基本設定

ターゲット作成フォームで以下の項目を設定します：

| 項目 | 必須 | 説明 |
|------|------|------|
| Executable | 必須 | デバッグ対象の実行ファイルパス |
| Core File | オプション | コアダンプファイルパス（クラッシュ解析時） |
| Symbol File | オプション | シンボルファイルパス（デバッグ情報が別ファイルの場合） |

### 4.3 詳細設定

「Show advanced settings」をチェックすると、追加の設定項目が表示されます：

| 項目 | 説明 |
|------|------|
| Remote File | リモートデバッグ用のファイルパス |
| Architecture | ターゲットアーキテクチャ（x86_64、arm64等） |
| Platform | プラットフォーム選択 |
| Load Dependents | 依存ファイルの読み込み設定（Executable only/Yes/No） |

### 4.4 ターゲット作成の実行

1. 必要な項目を入力します
2. 「Create」ボタンを選択します
3. ターゲットが正常に作成されると、フォームが閉じてメインウィンドウに戻ります

**エラーが発生した場合：**
- 「Some fields are invalid!」：入力内容を確認してください
- ファイルが存在しない場合はエラーメッセージが表示されます

### 4.5 ターゲットの削除

1. 「F2」キーでTargetメニューを開きます
2. 「Delete」を選択します
3. 現在のターゲットが削除されます

---

## 5. 【STEP2-3】プロセス制御（実行・アタッチ）

> **業務フローでの位置**: ターゲット作成後、プロセスを起動するか、実行中のプロセスにアタッチしてデバッグを開始します。

### 5.1 プロセス起動フォーム

**フォームを開く：**
1. 「F3」キーでProcessメニューを開きます
2. 「Launch」を選択します

**基本設定項目：**

| 項目 | 説明 |
|------|------|
| Arguments | コマンドライン引数 |
| Target Environment Variables | ターゲット環境変数 |
| Working Directory | ワーキングディレクトリ |

**詳細設定項目（Show advanced settings有効時）：**

| 項目 | 説明 |
|------|------|
| Stop at entry point | エントリポイントで停止 |
| Detach on error | エラー時にデタッチ |
| Disable ASLR | ASLRを無効化 |
| Shell | 使用するシェルパス |
| Standard Output/Error/Input | 標準入出力のリダイレクト |

**プロセスを起動する：**
1. 必要な設定を入力します
2. 「Launch」ボタンを選択します
3. プロセスが起動し、エントリポイントまたは最初のブレークポイントで停止します

### 5.2 プロセスアタッチフォーム

**フォームを開く：**
1. 「F3」キーでProcessメニューを開きます
2. 「Attach」を選択します

**設定項目：**

| 項目 | 説明 |
|------|------|
| Attach By | アタッチ方式（Name/PID） |
| PID | プロセスID（PID指定時） |
| Process Name | プロセス名（Name指定時） |
| Continue once attached | アタッチ後に続行するか |
| Wait for process to launch | プロセス起動を待機 |
| Include existing processes | 既存プロセスも対象に含める |

**アタッチを実行する：**
1. アタッチ対象を指定します
2. 「Attach」ボタンを選択します
3. プロセスにアタッチし、現在の状態で停止します

### 5.3 プロセス制御コマンド

Processメニュー（F3）から以下の操作が可能です：

| メニュー項目 | 説明 |
|-------------|------|
| Continue | 停止中のプロセスを続行 |
| Halt | 実行中のプロセスを停止 |
| Kill | プロセスを強制終了 |
| Detach Resume | デタッチしてプロセスを続行 |
| Detach Suspended | デタッチしてプロセスを停止状態で残す |

### 5.4 デタッチ/キル確認フォーム

既に実行中のプロセスがある状態で新しいプロセスを起動/アタッチしようとすると、確認フォームが表示されます：

- 「Detach」：現在のプロセスをデタッチして続行
- 「Kill」：現在のプロセスを終了

---

## 6. 【STEP3-4】ソースコードビュー（コードの確認・操作）

> **業務フローでの位置**: ブレークポイントの設定やステップ実行を行いながら、コードの動作を確認します。

### 6.1 ソースビューの基本操作

**ナビゲーション：**

| キー | 動作 |
|------|------|
| 上矢印 | 前の行を選択 |
| 下矢印 | 次の行を選択 |
| 左矢印 | 水平スクロール（左） |
| 右矢印 | 水平スクロール（右） |
| Page Up / , | 1ページ上にスクロール |
| Page Down / . | 1ページ下にスクロール |

### 6.2 ブレークポイントの設定

1. 設定したい行に移動します
2. 「b」キーを押します
3. ブレークポイントが設定され、行番号の背景色が変わります

**ブレークポイントの解除：**
- 同じ行で再度「b」キーを押すとブレークポイントが解除されます

### 6.3 ステップ実行

| キー | 動作 | 説明 |
|------|------|------|
| c | 続行 | 次のブレークポイントまで実行 |
| n | ステップオーバー | 関数呼び出しを飛ばして次の行へ |
| N | 命令ステップオーバー | 命令単位でステップオーバー |
| s | ステップイン | 関数の中に入る |
| S | 命令ステップイン | 命令単位でステップイン |
| f | ステップアウト | 現在の関数から抜ける |

### 6.4 フレーム移動

| キー | 動作 |
|------|------|
| u | フレームアップ（呼び出し元へ） |
| d | フレームダウン（呼び出し先へ） |

### 6.5 選択行まで実行

1. 実行したい行に移動します
2. 「Enter」キーを押します
3. その行にワンショットブレークポイントが設定され、実行が続行されます
4. 指定行に到達するとブレークポイントは自動的に削除されます

### 6.6 表示内容

| 表示要素 | 説明 |
|---------|------|
| 行番号 | 左端に表示（右寄せ） |
| PCマーカー | 現在の実行位置（ダイヤモンド記号） |
| ブレークポイント | 設定行は背景色が反転 |
| 停止理由 | PC行の右端に表示 |
| ソースコード/逆アセンブリ | ソースファイルがない場合は逆アセンブリを表示 |

---

## 7. 【STEP4-5】デバッグ実行・解析（変数・スレッド・レジスタ確認）

> **業務フローでの位置**: プログラムの状態を詳細に確認し、問題の原因を特定します。

### 7.1 変数ビュー

変数ビューでは、現在のスタックフレームのローカル変数を確認できます。

**基本操作：**

| キー | 動作 |
|------|------|
| 上矢印 | 前の変数を選択 |
| 下矢印 | 次の変数を選択 |
| 右矢印 | 複合型を展開 |
| 左矢印 | 折りたたみ/親を選択 |
| Page Up/Down | ページスクロール |

**値のフォーマット変更：**

| キー | フォーマット |
|------|------------|
| x | 16進数（小文字） |
| X | 16進数（大文字） |
| d | 符号付き整数 |
| u | 符号なし整数 |
| o | 8進数 |
| b | 2進数 |
| c | 文字 |
| f | 浮動小数点 |
| s | C文字列 |
| p | ポインタ |
| D | デフォルトに戻す |
| t | 型名表示のトグル |

### 7.2 スレッドビュー

スレッドビューでは、プロセス内の全スレッドとスタックフレームを確認できます。

**基本操作：**

| キー | 動作 |
|------|------|
| 上矢印 | 前の項目を選択 |
| 下矢印 | 次の項目を選択 |
| 右矢印 | スレッドを展開（スタックフレーム表示） |
| 左矢印 | 折りたたみ/親を選択 |
| Enter | 選択したスレッド/フレームをアクティブに設定 |

**表示内容：**
- プロセス情報（PID、プロセス名）
- スレッド情報（スレッドID、名前、状態、停止理由）
- スタックフレーム（フレーム番号、関数名、ソース位置）

### 7.3 レジスタビュー

レジスタビューは、オプションで表示できるウィンドウです。

**表示方法：**
1. 「F5」キーでViewメニューを開きます
2. 「Registers」を選択します
3. レジスタビューが表示されます（再度選択で非表示）

**表示内容：**
- General Purpose Registers（汎用レジスタ）
- Floating Point Registers（浮動小数点レジスタ）
- その他アーキテクチャ固有のレジスタ

**フォーマット変更：**
変数ビューと同じキー操作でフォーマットを変更できます。

---

## 8. ブレークポイント管理

### 8.1 ブレークポイントビューの表示

1. 「F5」キーでViewメニューを開きます
2. 「Breakpoints」を選択します
3. ブレークポイント一覧が表示されます

### 8.2 ブレークポイント情報の確認

ブレークポイントビューでは、以下の情報を確認できます：

**ブレークポイントレベル：**
- ID
- 設定条件（ファイル:行番号、関数名等）
- フィルター条件

**ロケーションレベル：**
- ブレークポイントID.ロケーションID
- 解決されたアドレス

**詳細情報（展開時）：**
- module：所属モジュール
- compile unit：コンパイルユニット
- function：関数名
- location：ソースファイル位置
- address：アドレス情報
- resolved：解決状態（true/false）
- hardware：ハードウェアブレークポイントかどうか
- hit count：ヒット回数

### 8.3 ソースビューからのブレークポイント操作

ソースビューで「b」キーを使用して、ブレークポイントの設定/解除を行います。

---

## 9. ヘルプ機能

### 9.1 ヘルプダイアログの表示

1. 任意の画面で「h」キーを押します
2. 現在のウィンドウのキーボードショートカット一覧が表示されます
3. 「ESC」キーで閉じます

### 9.2 メニューヘルプ

1. 「F6」キーでHelpメニューを開きます
2. 「GUI Help」を選択します

### 9.3 ウィンドウごとのヘルプ

各ウィンドウにフォーカスして「h」キーを押すと、そのウィンドウ固有のショートカットヘルプが表示されます：

- **ソースビュー**：ステップ実行、ブレークポイント操作のショートカット
- **変数ビュー**：フォーマット変更のショートカット
- **スレッドビュー**：ナビゲーションのショートカット

---

## 10. 検索機能

### 10.1 プロセス検索（アタッチ時）

プロセスアタッチフォームでプロセス名を入力する際、検索機能を使用できます。

1. 「Attach By」で「Name」を選択
2. プロセス名を入力
3. 「Wait for process to launch」を有効にすると、プロセス起動を待機

### 10.2 シンボル検索

LLDBコマンドラインで以下のコマンドを使用してシンボルを検索できます：
```
(lldb) image lookup -n <関数名>
(lldb) image lookup -t <型名>
```

---

## 11. 日常業務の流れ

本セクションでは、業務フローに沿った日常的なデバッグ作業の流れを説明します。

```
デバッグ業務フロー概要（再掲）
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
【STEP 1】ターゲット作成 → 4章参照
    ↓
【STEP 2】プロセス起動/アタッチ → 5章参照
    ↓
【STEP 3】ブレークポイント設定 → 6章・8章参照
    ↓
【STEP 4】実行・ステップ実行 → 6章参照
    ↓
【STEP 5】状態確認・解析 → 7章参照
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
```

### 11.1 STEP1: ターゲット作成

デバッグ対象のプログラムを設定します。

1. LLDBを起動し、`gui`コマンドでGUIモードに入ります
2. 「F2」→「Create」でターゲット作成フォームを開きます
3. 実行ファイルのパスを入力します
4. 必要に応じてシンボルファイル、コアファイルを指定します
5. 「Create」ボタンでターゲットを作成します

### 11.2 STEP2: プロセス起動/アタッチ

デバッグ対象を実行状態にします。

**新規プロセスを起動する場合：**
1. 「F3」→「Launch」を選択
2. コマンドライン引数、環境変数を設定
3. 「Launch」ボタンで起動

**実行中のプロセスにアタッチする場合：**
1. 「F3」→「Attach」を選択
2. プロセスIDまたはプロセス名を指定
3. 「Attach」ボタンでアタッチ

### 11.3 STEP3: ブレークポイント設定

調査したい箇所にブレークポイントを設定します。

1. ソースビューで対象の行に移動します
2. 「b」キーを押してブレークポイントを設定します
3. 設定されたブレークポイントは行番号の背景色変化で確認できます

### 11.4 STEP4: 実行・ステップ実行

プログラムを実行し、問題箇所を特定します。

1. 「c」キーで実行を続行します
2. ブレークポイントで停止したら、以下の操作を行います：
   - 「n」：次の行へ（ステップオーバー）
   - 「s」：関数の中へ（ステップイン）
   - 「f」：現在の関数から抜ける（ステップアウト）

### 11.5 STEP5: 状態確認・解析

プログラムの状態を確認し、問題の原因を特定します。

1. 変数ビューで変数の値を確認します
2. スレッドビューでスレッドの状態を確認します
3. 必要に応じてレジスタビューでCPU状態を確認します
4. 問題が特定できたら、コードを修正してデバッグを繰り返します

---

## 12. よくある質問と対処法

### 12.1 起動に関するQ&A

**Q: `gui`コマンドが使えません**

A: 以下を確認してください：
- LLDBが`LLDB_ENABLE_CURSES`を有効にしてビルドされているか確認
- ターミナルがncursesに対応しているか確認
- 環境変数`TERM`が適切に設定されているか確認

**Q: 画面が崩れて表示されます**

A: 以下を試してください：
- ターミナルサイズを80x24以上に拡大
- ターミナルの文字コードをUTF-8に設定
- ターミナルアプリケーションを変更

### 12.2 デバッグ操作に関するQ&A

**Q: ブレークポイントが設定できません**

A: 以下を確認してください：
- ターゲットが作成されているか
- デバッグ情報付きでビルドされているか（-gオプション）
- ソースファイルが正しく関連付けられているか

**Q: 変数の値が表示されません**

A: 以下を確認してください：
- プロセスが停止状態であるか
- 最適化によって変数が削除されていないか
- 現在のフレームに変数が存在するか

**Q: ソースコードが表示されず逆アセンブリが表示されます**

A: 以下を確認してください：
- ソースファイルが存在するパスにあるか
- コンパイル時のパスとソースファイルのパスが一致しているか
- シンボルファイルが正しく設定されているか

### 12.3 プロセスに関するQ&A

**Q: プロセスにアタッチできません**

A: 以下を確認してください：
- プロセスIDまたはプロセス名が正しいか
- アタッチ権限があるか（rootまたは同一ユーザー）
- macOSの場合、System Integrity Protection（SIP）の設定を確認

**Q: プロセスが応答しません**

A: 以下を試してください：
- 「F3」→「Halt」でプロセスを停止
- それでも応答がない場合は「F3」→「Kill」で強制終了

---

## 13. トラブルシューティング

### 13.1 エラーメッセージと対処法

| エラーメッセージ | 原因 | 対処法 |
|----------------|------|--------|
| "Some fields are invalid!" | フォーム入力が不正 | 必須項目を確認し、ファイルパスが存在するか確認 |
| "Unknown core file format!" | コアファイル形式が不明 | コアファイルが破損していないか確認、正しいアーキテクチャか確認 |
| "There is a running process" | 既に実行中のプロセスがある | デタッチまたはキルを選択 |
| ncursesライブラリ未対応 | LLDB_ENABLE_CURSESが無効 | LLDBを再ビルドするか、LLDB_ENABLE_CURSESが有効なバイナリを使用 |

### 13.2 よくあるトラブルと解決方法

**画面が更新されない**

1. ターミナルウィンドウをリサイズしてみる
2. GUIモードを一度終了して再度`gui`コマンドで入り直す
3. 別のターミナルアプリケーションを試す

**キー入力が効かない**

1. 正しいウィンドウにフォーカスがあるか確認（TABキーで切り替え）
2. ターミナルのキーバインド設定を確認
3. SSH接続の場合、接続設定を確認

**プロセスが予期せず終了する**

1. プログラムのバグでクラッシュしている可能性
2. シグナルが送信されている可能性
3. コアファイルが生成されていれば解析可能

### 13.3 サポートへの連絡方法

**LLVM/LLDBコミュニティ：**
- LLVM Discourse: https://discourse.llvm.org/
- LLDBドキュメント: https://lldb.llvm.org/
- GitHubイシュー: https://github.com/llvm/llvm-project/issues

**バグ報告時に含める情報：**
- LLDBのバージョン（`lldb --version`）
- OSとバージョン
- 再現手順
- エラーメッセージやスクリーンショット

---

## 改訂履歴

| 版数 | 改訂日 | 改訂内容 |
|-----|--------|---------|
| 1.0 | 2026-02-01 | 初版作成 |

---

*本マニュアルは、LLDB Curses GUIのエンドユーザー向け業務運用マニュアルです。*
*LLDBの更新により、画面や操作方法が変更される場合があります。*
