---
generated_at: 2026-02-01 23:45:00
metrics:
  claims_total: 55
  claims_with_evidence: 51
  claims_without_evidence: 4
confidence_derived: 0.93
---

# 根拠レポート：非機能要件テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：51 / 55、根拠なし：4
- 優先レビュー（高）
  1. **NFT-025 IOサンドボックス検証**：具体的なテスト手順・期待結果の根拠不足
  2. **NFT-026 libFuzzerテスト**：合格基準の定量的な根拠不足
  3. **NFT-039 実験的ターゲットビルド検証**：対象ターゲットリストの最新性要確認
  4. **NFT-055 libc++定期ビルド検証**：スケジュール実行の具体的な設定根拠不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `.ci/monolithic-linux.sh` - テスト実行タイムアウト設定（--timeout=1200）
- E-02: `.github/workflows/premerge.yaml` - CIジョブタイムアウト設定（timeout-minutes: 120, 180）
- E-03: `premerge_advisor_explain.py`, `premerge_advisor_upload.py` - HTTPタイムアウト設定
- E-04: `docs/code-to-docs/非機能要件定義書/非機能要件定義書.md` - 非機能要件定義
- E-05: `libc/benchmarks/README.md` - ベンチマーク実行方法
- E-06: `.github/workflows/scorecard.yml` - OpenSSF Scorecardワークフロー設定
- E-07: `.github/workflows/gha-codeql.yml` - CodeQL解析ワークフロー設定
- E-08: `compiler-rt/test/asan/`, `compiler-rt/test/msan/`, `compiler-rt/test/tsan/`, `compiler-rt/test/ubsan/` - サニタイザテストディレクトリ
- E-09: `compiler-rt/test/hwasan/` - HWAddressSanitizerテストディレクトリ
- E-10: `SECURITY.md` - セキュリティポリシー
- E-11: `.github/workflows/llvm-abi-tests.yml` - LLVM ABI互換性テストワークフロー
- E-12: `.github/workflows/libclang-abi-tests.yml` - libclang ABI互換性テストワークフロー
- E-13: `.github/workflows/pr-code-format.yml` - コードフォーマットチェックワークフロー
- E-14: `.github/workflows/pr-code-lint.yml` - コードリントチェックワークフロー
- E-15: `.github/workflows/libcxx-run-benchmarks.yml` - libcxxベンチマークワークフロー
- E-16: `docs/code-to-docs/テスト方針書/テスト方針書.md` - テスト方針定義
- E-17: `.clang-format` - コードフォーマット設定
- E-18: `.clang-tidy` - コードリント設定
- E-19: `third-party/benchmark/README.md` - Google Benchmarkライブラリ
- E-20: `compiler-rt/lib/sanitizer_common/` - サニタイザ共通ライブラリ

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | テスト実行タイムアウトは1200秒 | E-01 | ○ |
| C-02 | Linux CIジョブタイムアウトは120分 | E-02 | ○ |
| C-03 | Windows CIジョブタイムアウトは180分 | E-02 | ○ |
| C-04 | HTTP APIタイムアウトは5秒 | E-03, E-04 | ○ |
| C-05 | 並列コンパイルジョブ数はRAM/CPU依存で動的設定 | E-04 | ○ |
| C-06 | ThinLTOモード時は並列リンクジョブ数が2に制限 | E-04 | ○ |
| C-07 | 並列TableGenジョブ数はRAM依存で動的設定 | E-04 | ○ |
| C-08 | LLVM_RAM_PER_COMPILE_JOBでメモリ管理可能 | E-04 | ○ |
| C-09 | LLVM_RAM_PER_LINK_JOBでメモリ管理可能 | E-04 | ○ |
| C-10 | LLVM_RAM_PER_TABLEGEN_JOBでメモリ管理可能 | E-04 | ○ |
| C-11 | memcpyベンチマークは確率モードで実行可能 | E-05 | ○ |
| C-12 | memcpyベンチマークはスイープモードで実行可能 | E-05 | ○ |
| C-13 | memsetベンチマークが利用可能 | E-05 | ○ |
| C-14 | memcmpベンチマークが利用可能 | E-05 | ○ |
| C-15 | libcxxベンチマークワークフローが存在 | E-15 | ○ |
| C-16 | OpenSSF Scorecardは毎日20:38 UTCに実行 | E-06 | ○ |
| C-17 | CodeQL解析はsecurity-extendedクエリを使用 | E-07 | ○ |
| C-18 | AddressSanitizerテストが存在 | E-08 | ○ |
| C-19 | MemorySanitizerテストが存在 | E-08 | ○ |
| C-20 | ThreadSanitizerテストが存在 | E-08 | ○ |
| C-21 | UndefinedBehaviorSanitizerテストが存在 | E-08 | ○ |
| C-22 | HWAddressSanitizerテストが存在 | E-09 | ○ |
| C-23 | libcxxハードニングモードはextensive | E-04 | ○ |
| C-24 | glibcxxアサーションが有効化可能 | E-04 | ○ |
| C-25 | IOサンドボックス機能が存在 | **根拠不足** | △ |
| C-26 | libFuzzerテストの合格基準 | **根拠不足** | △ |
| C-27 | バックトレース機能はLLVM_ENABLE_BACKTRACESで有効化 | E-04 | ○ |
| C-28 | クラッシュオーバーライドはLLVM_ENABLE_CRASH_OVERRIDESで有効化 | E-04 | ○ |
| C-29 | クラッシュ再現情報はCLANG_CRASH_DIAGNOSTICS_DIRで設定 | E-04 | ○ |
| C-30 | Windowsでメモリダンプ生成可能 | E-04 | ○ |
| C-31 | Linux x86_64はCI環境でテスト | E-02, E-04 | ○ |
| C-32 | Linux AArch64はCI環境でテスト | E-02, E-04 | ○ |
| C-33 | WindowsはCI環境でテスト | E-02 | ○ |
| C-34 | macOSはリリースブランチでテスト | E-02 | ○ |
| C-35 | MinGWクロスコンパイルが可能 | E-04, E-16 | ○ |
| C-36 | LLVM ABI互換性テストワークフローが存在 | E-11 | ○ |
| C-37 | libclang ABI互換性テストワークフローが存在 | E-12 | ○ |
| C-38 | 全19標準ターゲットがサポート | E-04 | ○ |
| C-39 | 実験的ターゲット（5種）がサポート | **根拠不足** | △ |
| C-40 | C++17が必須 | E-04 | ○ |
| C-41 | 警告エラー化はLLVM_ENABLE_WERRORで設定 | E-04 | ○ |
| C-42 | PedanticモードはLLVM_ENABLE_PEDANTICで設定 | E-04 | ○ |
| C-43 | 高コストチェックはLLVM_ENABLE_EXPENSIVE_CHECKSで設定 | E-04 | ○ |
| C-44 | アサーションはLLVM_ENABLE_ASSERTIONSで設定 | E-04 | ○ |
| C-45 | clang-formatチェックワークフローが存在 | E-13 | ○ |
| C-46 | clang-tidyチェックワークフローが存在 | E-14 | ○ |
| C-47 | ccacheはLLVM_CCACHE_BUILDで有効化 | E-04 | ○ |
| C-48 | sccacheはCI環境で使用 | E-02, E-04 | ○ |
| C-49 | Concurrency制御はcancel-in-progressで設定 | E-02 | ○ |
| C-50 | アーティファクト保持期間は5日間 | E-02 | ○ |
| C-51 | シンボル化はLLVM_SYMBOLIZER_PATHで設定 | E-04 | ○ |
| C-52 | テスト実行時間計測は--time-testsで設定 | E-04 | ○ |
| C-53 | XUnit XML出力は--xunit-xml-outputで設定 | E-04 | ○ |
| C-54 | OpenSSF Scorecardは毎日20:38 UTCに実行 | E-06 | ○ |
| C-55 | libc++定期ビルドの具体的なスケジュール | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- **NFT-025 IOサンドボックス検証**: LLVM_ENABLE_IO_SANDBOXの具体的な動作仕様とテスト手順のドキュメントが不足
  - 候補：CMakeLists.txtの設定コメント / LLVMソースコード内の実装 / LLVM公式ドキュメント
- **NFT-026 libFuzzerテスト**: ファジングテストの「指定時間」の具体的な基準が不明
  - 候補：libFuzzerドキュメント / CIワークフロー設定 / テスト方針書への追記
- **NFT-039 実験的ターゲット**: 実験的ターゲットの最新リストはLLVMのバージョンにより変動する可能性
  - 候補：llvm/CMakeLists.txt / LLVM公式リリースノート / ターゲット一覧ドキュメント
- **NFT-055 libc++定期ビルド**: 具体的なスケジュール設定（cronの値）が確認できない
  - 候補：.github/workflows/libcxx-build-and-test.yaml / ワークフロー履歴

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: NFT-030, NFT-034, NFT-043, NFT-050, NFT-052, NFT-054, NFT-055
  - オプション機能またはリリースブランチ限定のテストケース
- **1（中リスク）**: NFT-004 - NFT-015, NFT-022 - NFT-029, NFT-035, NFT-038 - NFT-048
  - 重要だが代替手段があるテストケース
- **2（高リスク）**: NFT-001 - NFT-003, NFT-016 - NFT-021, NFT-031 - NFT-033, NFT-036 - NFT-037, NFT-040, NFT-045
  - 品質保証に直結するテストケース、セキュリティ関連テストケース

## 6) レビュアーチェックリスト（最小）
- [ ] 性能テスト（NFT-001 - NFT-015）のタイムアウト値・ベンチマーク手順が実際のCI設定と一致しているか
- [ ] セキュリティテスト（NFT-016 - NFT-026）のサニタイザ設定がcompiler-rtのテスト構成と一致しているか
- [ ] 互換性テスト（NFT-031 - NFT-039）のプラットフォーム・ターゲットリストが最新のLLVMサポート状況と一致しているか
- [ ] 保守性テスト（NFT-040 - NFT-048）のCMakeオプション名が最新のLLVM CMake設定と一致しているか
- [ ] 運用テスト（NFT-049 - NFT-055）のCI/CDワークフロー設定が実際の.github/workflows/と一致しているか
- [ ] 根拠不足（△）の4項目について追加調査が必要か判断
