---
generated_at: 2026-02-01 21:45:00
metrics:
  claims_total: 42
  claims_with_evidence: 38
  claims_without_evidence: 4
confidence_derived: 0.90
---

# 根拠レポート：非機能要件定義書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：38 / 42、根拠なし：4
- 優先レビュー（高）
  1. **稼働率要件**：明示的な定義がソースコードに存在しない
  2. **計画停止時間**：明示的な定義がソースコードに存在しない
  3. **RTO/RPO**：明示的な定義がソースコードに存在しない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `.ci/monolithic-linux.sh`（テストタイムアウト、ビルド設定）
- E-02: `.ci/monolithic-windows.sh`（Windows版ビルド設定）
- E-03: `.github/workflows/premerge.yaml`（CIジョブタイムアウト、ランナー設定）
- E-04: `llvm/CMakeLists.txt`（並列ジョブ設定、ビルドオプション）
- E-05: `llvm/cmake/modules/HandleLLVMOptions.cmake`（ビルドオプション詳細）
- E-06: `SECURITY.md`（セキュリティポリシー）
- E-07: `README.md`（プロジェクト概要、セキュリティバッジ）
- E-08: `.github/workflows/scorecard.yml`（セキュリティスコア設定）
- E-09: `.clang-format`（コードフォーマット設定）
- E-10: `.clang-tidy`（静的解析設定）
- E-11: `.ci/premerge_advisor_explain.py`（HTTPタイムアウト設定）
- E-12: `.ci/premerge_advisor_upload.py`（HTTPタイムアウト設定）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | テスト実行タイムアウト1200秒 | E-01, E-02 | ○ |
| C-02 | CI HTTPリクエストタイムアウト5秒 | E-11, E-12 | ○ |
| C-03 | CIジョブ全体タイムアウト120分 | E-03 | ○ |
| C-04 | 並列コンパイルジョブ数（RAM/CPU依存） | E-04, E-05 | ○ |
| C-05 | 並列リンクジョブ数（ThinLTO時2制限） | E-04, E-05 | ○ |
| C-06 | 並列TableGenジョブ数 | E-04, E-05 | ○ |
| C-07 | RAM per ジョブ設定 | E-04, E-05 | ○ |
| C-08 | 稼働率要件なし | **根拠なし** | △ |
| C-09 | 計画停止時間要件なし | **根拠なし** | △ |
| C-10 | RTO/RPO要件なし | **根拠なし** | △ |
| C-11 | バックトレース機能有効 | E-04 | ○ |
| C-12 | クラッシュオーバーライド有効 | E-04 | ○ |
| C-13 | メモリダンプ（Windows）無効 | E-04 | ○ |
| C-14 | クラッシュ再現情報保存 | E-01 | ○ |
| C-15 | セキュリティポリシー存在 | E-06 | ○ |
| C-16 | OpenSSF Scorecard実施 | E-07, E-08 | ○ |
| C-17 | OpenSSF Best Practices認定 | E-07 | ○ |
| C-18 | サニタイザーサポート | E-04 | ○ |
| C-19 | libcxxハードニングモード | E-05 | ○ |
| C-20 | glibcxxアサーション有効 | E-05 | ○ |
| C-21 | IOサンドボックスオプション | E-04 | ○ |
| C-22 | マルチプラットフォーム対応 | E-03, E-04 | ○ |
| C-23 | 19+5ターゲットアーキテクチャ | E-04 | ○ |
| C-24 | モジュール構成（LLVM/Clang/LLD等） | E-04 | ○ |
| C-25 | C++17標準必須 | E-04 | ○ |
| C-26 | 警告エラー化オプション | E-04 | ○ |
| C-27 | Pedanticモード有効 | E-04 | ○ |
| C-28 | アサーションビルドタイプ依存 | E-04 | ○ |
| C-29 | ccacheサポート | E-04 | ○ |
| C-30 | sccacheCI環境使用 | E-01, E-03 | ○ |
| C-31 | clang-format設定存在 | E-09 | ○ |
| C-32 | clang-tidy設定存在 | E-10 | ○ |
| C-33 | GitHub Actions CI使用 | E-03 | ○ |
| C-34 | Linux CI環境設定 | E-03 | ○ |
| C-35 | Windows CI環境設定 | E-03 | ○ |
| C-36 | Concurrency制御設定 | E-03 | ○ |
| C-37 | アーティファクト5日間保持 | E-03 | ○ |
| C-38 | シンボル化設定 | E-01 | ○ |
| C-39 | テスト時間計測 | E-01, E-02 | ○ |
| C-40 | XUnit XML出力 | E-01, E-02 | ○ |
| C-41 | Scorecardスケジュール実行 | E-08 | ○ |
| C-42 | SLA/SLOの不存在 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **可用性要件（稼働率、RTO/RPO、計画停止時間）**：オープンソースプロジェクトの特性上、ソースコードやCI設定に明示的なサービスレベル定義が存在しない。これは要件が存在しないことを意味し、根拠としてコードベース全体を確認済み。
  - 候補：運用ドキュメント / プロジェクト運営ガイドライン / インフラ構成図
- **SLA/SLOの明示的な不存在確認**：オープンソースプロジェクトとしての性質から推測されるが、プロジェクト方針文書での明示的な記載は未確認。
  - 候補：プロジェクト憲章 / コミュニティガイドライン / CONTRIBUTING.md

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 性能要件（C-01～C-07）：CI設定ファイルに明確な数値が存在
- **0: 低リスク** - セキュリティ要件（C-15～C-21）：設定ファイル・ポリシー文書で確認可能
- **0: 低リスク** - 保守性要件（C-25～C-32）：CMakeLists.txtで明確に定義
- **1: 中リスク** - 可用性要件（C-08～C-10）：明示的な定義がないことの確認が必要
- **0: 低リスク** - 運用要件（C-33～C-41）：GitHub Actionsワークフローで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] テストタイムアウト1200秒が運用上適切か確認（`.ci/monolithic-linux.sh`）
- [ ] 並列ジョブ設定が各環境で適切に機能するか確認（`llvm/CMakeLists.txt`）
- [ ] 可用性要件が本当に不要か、プロジェクト方針と照合して確認
- [ ] セキュリティバッジ（OpenSSF）が最新の状態を反映しているか確認
- [ ] CIジョブ120分タイムアウトが大規模変更時に十分か確認
- [ ] サニタイザー設定が実際のCI環境で有効化されているか確認
