# 非機能要件定義書

## 概要

本ドキュメントは、LLVMプロジェクト（llvm-project-main）の非機能要件を定義するものである。LLVMはコンパイラインフラストラクチャのツールキットであり、高度に最適化されたコンパイラ、オプティマイザ、およびランタイム環境の構築に使用される。本要件は、プロジェクトのソースコード、CMake設定ファイル、CI/CDパイプライン設定から抽出されたものである。

## 性能要件

### レスポンスタイム

| 処理種別 | 目標値 | 備考 |
| --- | --- | --- |
| テスト実行タイムアウト | 1200秒（20分）以内 | `.ci/monolithic-linux.sh` にて `--timeout=1200` として設定 |
| CI HTTPリクエストタイムアウト | 5秒以内 | `premerge_advisor_explain.py`、`premerge_advisor_upload.py` にて設定 |
| CIジョブ全体タイムアウト | 120分以内 | `.github/workflows/premerge.yaml` にて `timeout-minutes: 120` として設定 |

### スループット

| 項目 | 目標値 | 備考 |
| --- | --- | --- |
| 並列コンパイルジョブ数 | 動的設定（RAM/CPU依存） | `LLVM_PARALLEL_COMPILE_JOBS`：利用可能メモリと論理コア数から自動計算 |
| 並列リンクジョブ数 | 動的設定（ThinLTOの場合は2に制限） | `LLVM_PARALLEL_LINK_JOBS`：ThinLTOモード時は自動的に2に制限される |
| 並列TableGenジョブ数 | 動的設定（RAM/CPU依存） | `LLVM_PARALLEL_TABLEGEN_JOBS`：利用可能メモリから自動計算 |

### メモリ管理

| 項目 | 設定値 | 備考 |
| --- | --- | --- |
| RAM per コンパイルジョブ | 設定可能（LLVM_RAM_PER_COMPILE_JOB） | ジョブ数を自動調整 |
| RAM per リンクジョブ | 設定可能（LLVM_RAM_PER_LINK_JOB） | ジョブ数を自動調整 |
| RAM per TableGenジョブ | 設定可能（LLVM_RAM_PER_TABLEGEN_JOB） | ジョブ数を自動調整 |

## 可用性要件

| 項目 | 目標値 | 備考 |
| --- | --- | --- |
| 稼働率 | 明示的な定義なし | オープンソースプロジェクトのため、サービスレベルは未定義 |
| 計画停止時間 | 明示的な定義なし | CI/CDは GitHub Actions で運用 |
| 障害復旧時間（RTO） | 明示的な定義なし | ソースコード管理はGit、CI失敗時は手動対応 |
| 目標復旧時点（RPO） | 明示的な定義なし | Gitによるバージョン管理で任意時点への復旧可能 |

### クラッシュ・障害対応

| 項目 | 設定 | 備考 |
| --- | --- | --- |
| バックトレース機能 | 有効（LLVM_ENABLE_BACKTRACES=ON） | クラッシュ時のデバッグ情報取得 |
| クラッシュオーバーライド | 有効（LLVM_ENABLE_CRASH_OVERRIDES=ON） | カスタムクラッシュハンドラのサポート |
| メモリダンプ（Windows） | 無効（LLVM_ENABLE_CRASH_DUMPS=OFF） | オプションで有効化可能 |
| クラッシュ再現情報 | 有効（CLANG_CRASH_DIAGNOSTICS_DIR設定） | CIでアーティファクトとして保存 |

## セキュリティ要件

### セキュリティポリシー

- セキュリティ問題の報告は [LLVM Security Group](https://llvm.org/docs/Security.html#how-to-report-a-security-issue) を通じて行う
- 多くのLLVMツールは悪意のある入力に対するハードニングを目的としていない
- バッファオーバーリードやクラッシュはセキュリティ脆弱性とは限らず、通常の Issue として報告される

### セキュリティスコア・監査

| 項目 | 内容 | 備考 |
| --- | --- | --- |
| OpenSSF Scorecard | 実施（毎日20:38 UTC） | `.github/workflows/scorecard.yml` で自動実行 |
| OpenSSF Best Practices | 認定取得（プロジェクト#8273） | README.md にバッジ表示 |
| CodeQL解析 | 有効 | `.github/workflows/gha-codeql.yml` |

### サニタイザーサポート

| サニタイザー | 設定オプション | 備考 |
| --- | --- | --- |
| AddressSanitizer（ASan） | LLVM_USE_SANITIZER | メモリエラー検出 |
| MemorySanitizer（MSan） | LLVM_USE_SANITIZER | 未初期化メモリ検出 |
| ThreadSanitizer（TSan） | LLVM_USE_SANITIZER | データ競合検出 |
| UndefinedBehaviorSanitizer（UBSan） | LLVM_UBSAN_FLAGS | 未定義動作検出 |

### ハードニングオプション

| 項目 | 設定 | 備考 |
| --- | --- | --- |
| libcxxハードニングモード | extensive（LLVM_ENABLE_ASSERTIONS=ON時） | セキュリティ強化チェック |
| glibcxxアサーション | 有効（_GLIBCXX_ASSERTIONS） | 実行時チェック |
| IO サンドボックス | オプション（LLVM_ENABLE_IO_SANDBOX） | 対応ツールでのIO制限 |

## 拡張性要件

### マルチプラットフォーム対応

| プラットフォーム | サポート状況 | 備考 |
| --- | --- | --- |
| Linux (x86_64) | 完全サポート | 主要CI環境 |
| Linux (AArch64) | 完全サポート | CI環境に含まれる |
| Windows | 完全サポート | 専用CIジョブあり |
| macOS (Darwin) | サポート | 特定のリンカーフラグ設定あり |
| AIX | サポート | 特別なコンパイルフラグ必要 |
| FreeBSD/OpenBSD | サポート | リンカーオプション調整 |

### ターゲットアーキテクチャ

全19の標準ターゲット（AArch64、AMDGPU、ARM、AVR、BPF、Hexagon、Lanai、LoongArch、Mips、MSP430、NVPTX、PowerPC、RISCV、Sparc、SPIRV、SystemZ、VE、WebAssembly、X86、XCore）と5つの実験的ターゲット（ARC、CSKY、DirectX、M68k、Xtensa）をサポート。

### モジュール構成

| コンポーネント | 説明 | 独立ビルド |
| --- | --- | --- |
| LLVM Core | コアライブラリ・ツール | 可能 |
| Clang | C/C++/Objective-Cフロントエンド | LLVM依存 |
| LLD | リンカー | LLVM依存 |
| LLDB | デバッガー | LLVM + Clang依存 |
| MLIR | マルチレベルIR | LLVM依存 |
| Flang | Fortranフロントエンド | LLVM + Clang + MLIR依存 |
| compiler-rt | ランタイムライブラリ | LLVM依存 |
| libcxx | C++標準ライブラリ | 独立可能 |

## 保守性要件

### コード品質

| 項目 | 設定 | 備考 |
| --- | --- | --- |
| C++標準 | C++17必須 | LLVM_REQUIRED_CXX_STANDARD=17 |
| 警告をエラー化 | オプション（LLVM_ENABLE_WERROR） | CI環境ではON |
| Pedanticモード | 有効（LLVM_ENABLE_PEDANTIC=ON） | 厳格なコンパイル |
| アサーション | ビルドタイプ依存 | Debug時ON、Release時OFF |
| 高コストチェック | オプション（LLVM_ENABLE_EXPENSIVE_CHECKS） | 詳細な検証 |

### ビルドキャッシュ

| ツール | 設定 | 備考 |
| --- | --- | --- |
| ccache | LLVM_CCACHE_BUILD | ローカルビルドキャッシュ |
| sccache | CI環境で使用 | 分散キャッシュ（GCS/WebDAV対応） |
| キャッシュパラメータ | CCACHE_CPP2=yes, CCACHE_HASHDIR=yes | プリコンパイル済みヘッダー対応 |

### 静的解析・リンティング

| ツール | 用途 | 備考 |
| --- | --- | --- |
| clang-format | コードフォーマット | `.clang-format` で設定 |
| clang-tidy | 静的解析 | `.clang-tidy` で設定 |
| PR Code Format Check | 自動フォーマットチェック | `.github/workflows/pr-code-format.yml` |
| PR Code Lint Check | 自動リントチェック | `.github/workflows/pr-code-lint.yml` |

## 運用・監視要件

### CI/CD パイプライン

| 項目 | 設定 | 備考 |
| --- | --- | --- |
| CIプラットフォーム | GitHub Actions | `.github/workflows/` 配下 |
| Linux CI | llvm-premerge-linux-runners, depot-ubuntu-24.04-arm | マルチアーキテクチャ |
| Windows CI | llvm-premerge-windows-2022-runners | Windows 2022環境 |
| Concurrency制御 | PR単位でキャンセル可能 | `cancel-in-progress: true` |

### ビルドアーティファクト

| 項目 | 保持期間 | 備考 |
| --- | --- | --- |
| テスト結果XML | 5日間 | `test-results.xml` |
| ビルドログ | 5日間 | `ninja.log` |
| クラッシュ再現情報 | 5日間 | `artifacts/reproducers/` |
| sccacheログ | 5日間 | `artifacts/sccache.log` |

### ログ・診断

| 項目 | 設定 | 備考 |
| --- | --- | --- |
| シンボル化 | LLVM_SYMBOLIZER_PATH設定 | スタックトレースの可読化 |
| テスト詳細出力 | `--time-tests` | テスト実行時間の計測 |
| XUnit XML出力 | `--xunit-xml-output` | CI結果の構造化出力 |

### スケジュール実行

| ジョブ | スケジュール | 備考 |
| --- | --- | --- |
| OpenSSF Scorecard | 毎日20:38 UTC | セキュリティスコア更新 |
| libc++ Build and Test | スケジュール実行 | 定期的なビルド・テスト |

## 備考

### 制限事項

- 本ドキュメントはソースコードから抽出した非機能要件であり、実際の運用要件とは異なる可能性がある
- サービスレベル（SLA/SLO）はオープンソースプロジェクトの性質上、明示的に定義されていない
- パフォーマンス目標値はCI環境での設定であり、実運用環境では異なる値が適切な場合がある

### 参照ドキュメント

- [LLVM Getting Started](https://llvm.org/docs/GettingStarted.html)
- [LLVM CMake Documentation](https://llvm.org/docs/CMake.html)
- [LLVM Security Policy](https://llvm.org/docs/Security.html)
- [OpenSSF Scorecard Results](https://securityscorecards.dev/viewer/?uri=github.com/llvm/llvm-project)
