---
generated_at: 2026-02-03 12:00:00
metrics:
  claims_total: 42
  claims_with_evidence: 38
  claims_without_evidence: 4
confidence_derived: 0.90
---

# 根拠レポート：API設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：38 / 42、根拠なし：4
- 優先レビュー（高）
  1. **Pages Routerデータ取得APIのレスポンス形式**：レスポンスJSON構造の詳細はコード内で分散しており完全な確認が困難
  2. **静的アセット配信のCache-Control値**：具体的なCache-Controlヘッダー値はrouter-server.tsのコード全体で確認が必要
  3. **画像最適化APIの全クエリパラメータ仕様**：image-optimizer.tsの全体解析が必要
  4. **プレビューデータの暗号化仕様詳細**：AES暗号化の具体的実装はcrypto-utils.tsに依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `packages/next/src/server/route-kind.ts` - RouteKind列挙型（PAGES, PAGES_API, APP_PAGE, APP_ROUTE, IMAGE）
- E-02: `packages/next/src/server/web/http.ts` - HTTP_METHODSの定義（GET, HEAD, OPTIONS, POST, PUT, DELETE, PATCH）
- E-03: `packages/next/src/server/route-modules/app-route/module.ts` - AppRouteRouteModule実装（ハンドラー解決、動的設定、レスポンス処理）
- E-04: `packages/next/src/server/route-modules/pages-api/module.ts` - PagesAPIRouteModule実装
- E-05: `packages/next/src/server/api-utils/index.ts` - APIユーティリティ（sendStatusCode, redirect, clearPreviewData, ApiError, RESPONSE_LIMIT_DEFAULT等）
- E-06: `packages/next/src/server/api-utils/node/api-resolver.ts` - Pages API Routeリゾルバー（ボディパース、Cookie設定、レスポンスメソッド注入）
- E-07: `packages/next/src/server/api-utils/node/parse-body.ts` - リクエストボディパーサー（JSON, URLencoded, テキスト対応）
- E-08: `packages/next/src/server/web/spec-extension/request.ts` - NextRequestクラス定義
- E-09: `packages/next/src/server/web/spec-extension/response.ts` - NextResponseクラス定義（json, redirect, rewrite, next）
- E-10: `packages/next/src/server/web/spec-extension/revalidate.ts` - revalidatePath, revalidateTag, updateTag, refresh関数
- E-11: `packages/next/src/shared/lib/utils.ts` - NextApiRequest / NextApiResponse 型定義
- E-12: `packages/next/src/server/route-modules/app-route/helpers/auto-implement-methods.ts` - HEAD/OPTIONSメソッドの自動実装
- E-13: `packages/next/src/server/image-optimizer.ts` - 画像最適化処理（対応画像形式、キャッシュ）
- E-14: `packages/next/src/server/lib/router-server.ts` - Router Server初期化関数（initialize）
- E-15: `packages/next/src/server/next-server.ts` - NextServer実装（handleApiRequest）
- E-16: `packages/next/src/server/route-modules/route-module.ts` - RouteModule基底クラス

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Next.jsは2つのAPIルーティングシステム（Pages Router API Routes / App Router Route Handlers）を提供する | E-01, E-03, E-04 | ○ |
| C-02 | RouteKindとしてPAGES, PAGES_API, APP_PAGE, APP_ROUTE, IMAGEが定義されている | E-01 | ○ |
| C-03 | サポートHTTPメソッドはGET, HEAD, OPTIONS, POST, PUT, DELETE, PATCHの7種類 | E-02 | ○ |
| C-04 | Pages API Routeのボディパースはapplication/json, application/ld+json, application/x-www-form-urlencoded, text/plainに対応 | E-07 | ○ |
| C-05 | ボディサイズのデフォルト上限は1mb | E-06 | ○ |
| C-06 | レスポンスサイズのデフォルト上限（警告）は4MB（RESPONSE_LIMIT_DEFAULT） | E-05 | ○ |
| C-07 | NextApiRequestはquery, cookies, body, env, draftMode, preview, previewDataプロパティを持つ | E-11 | ○ |
| C-08 | NextApiResponseはstatus, send, json, redirect, setDraftMode, setPreviewData, clearPreviewData, revalidateメソッドを持つ | E-06, E-11 | ○ |
| C-09 | リダイレクトのデフォルトステータスコードは307 | E-05 | ○ |
| C-10 | App Route HandlerはHTTPメソッド名の大文字named exportで定義される | E-03 | ○ |
| C-11 | 小文字メソッド名は開発モードでエラーログが出力される | E-03 | ○ |
| C-12 | defaultエクスポートは開発モードでエラーログが出力される | E-03 | ○ |
| C-13 | 未実装メソッドへのリクエストは405レスポンスを返す | E-12 | ○ |
| C-14 | HEADメソッドはGETハンドラーが定義されている場合自動的に代替される | E-12 | ○ |
| C-15 | OPTIONSメソッドは未定義の場合、Allowヘッダー付き204レスポンスで自動実装される | E-12 | ○ |
| C-16 | 無効なHTTPメソッドは400レスポンスを返す | E-03 | ○ |
| C-17 | dynamic設定はauto, force-dynamic, force-static, errorの4値をサポート | E-03 | ○ |
| C-18 | force-static設定時、リクエスト情報は空スタブに置換される | E-03 | ○ |
| C-19 | POST, PUT, DELETE, PATCH, OPTIONSは非静的メソッドとして扱われる | E-03 | ○ |
| C-20 | NextRequestはWeb標準Requestを拡張しcookies, nextUrl, urlプロパティを追加 | E-08 | ○ |
| C-21 | NextResponseはjson, redirect, rewrite, nextの静的メソッドを提供 | E-09 | ○ |
| C-22 | NextResponse.redirect()は301, 302, 303, 307, 308のステータスコードをサポート | E-09 | ○ |
| C-23 | NextResponse.rewrite()はApp Route Handlerでは使用不可 | E-03 | ○ |
| C-24 | NextResponse.next()はApp Route Handlerでは使用不可 | E-03 | ○ |
| C-25 | revalidatePathはパスとタイプ（layout/page）を指定してキャッシュ無効化 | E-10 | ○ |
| C-26 | revalidateTagはタグ名とprofileを指定してキャッシュ無効化 | E-10 | ○ |
| C-27 | updateTagはServer Actionからのみ呼び出し可能 | E-10 | ○ |
| C-28 | refreshはServer Actionからのみ呼び出し可能 | E-10 | ○ |
| C-29 | use cacheスコープ内からの再検証関数呼び出しは禁止 | E-10 | ○ |
| C-30 | __prerender_bypassと__next_preview_data Cookieでdraft modeを制御 | E-05, E-06 | ○ |
| C-31 | プレビューデータはJWTエンコードされ上限2KB | E-06 | ○ |
| C-32 | Cookie属性は開発環境でsameSite=lax/secure=false、本番でsameSite=none/secure=true | E-05, E-06 | ○ |
| C-33 | output: export設定時、force-dynamicは使用不可 | E-03 | ○ |
| C-34 | App Route Handlerのハンドラーは必ずResponseインスタンスを返す必要がある | E-03 | ○ |
| C-35 | 画像最適化APIのパスは/_next/image | E-01, E-13 | ○ |
| C-36 | 対応画像形式にはJPEG, PNG, WebP, GIF, SVG, ICO, BMP等が含まれる | E-13 | ○ |
| C-37 | SVG, ICO, BMP等はバイパス対象（BYPASS_TYPES） | E-13 | ○ |
| C-38 | Router Serverのinitialize関数はdir, port, devを必須パラメータとする | E-14 | ○ |
| C-39 | 画像最適化APIのクエリパラメータ（url, w, q）の完全な仕様 | E-13 | △ |
| C-40 | Pages Routerデータ取得APIのレスポンスJSON構造（pageProps, __N_SSP） | **根拠なし** | △ |
| C-41 | 静的アセット配信のCache-Controlヘッダー値 | **根拠なし** | △ |
| C-42 | プレビューデータの暗号化にAES対称暗号が使用されている詳細 | E-06 | △ |

## 4) 不足情報（Unknown / Missing）
- **C-39: 画像最適化APIの完全なクエリパラメータ仕様**: `image-optimizer.ts`は940行以上あり、クエリパラメータのバリデーションロジック全体の解析が完了していない。ただし`url`, `w`, `q`がメインパラメータであることはNext.js公式ドキュメントから広く知られている。
  - 候補: `packages/next/src/server/image-optimizer.ts` のクエリパース部分 / Next.js公式ドキュメント / `test/integration/image-optimizer/`
- **C-40: Pages Routerデータ取得APIのレスポンス構造**: データフェッチのレスポンス生成ロジックは`render.tsx`や`base-server.ts`等に分散しており、単一ファイルからの確認が困難。
  - 候補: `packages/next/src/server/render.tsx` / `packages/next/src/server/base-server.ts` / テストファイル
- **C-41: 静的アセットのCache-Control値**: 静的アセット配信のキャッシュヘッダー設定はrouter-server.tsの広範な処理の中にあり、今回の解析範囲外。
  - 候補: `packages/next/src/server/lib/router-server.ts` / `packages/next/src/server/serve-static.ts`
- **C-42: 暗号化仕様の詳細**: `encryptWithSecret`関数の具体的な実装は`packages/next/src/server/crypto-utils.ts`に存在するが、今回は直接参照していない。api-resolver.ts内のJWT署名（HS256）は確認済み。
  - 候補: `packages/next/src/server/crypto-utils.ts`

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - RouteKind、HTTPメソッド、NextRequest/NextResponse、auto-implement-methodsの記述はソースコードに完全に基づいており正確性が高い
- **0: 低リスク** - Pages API Routeのリクエスト/レスポンスオブジェクト仕様はapi-resolver.tsおよびutils.tsの型定義に基づく
- **0: 低リスク** - revalidatePath/revalidateTag/updateTag/refreshの仕様はrevalidate.tsに基づく
- **1: 中リスク** - 画像最適化APIのクエリパラメータ仕様はimage-optimizer.tsの一部のみ確認。完全な仕様は追加解析が必要
- **1: 中リスク** - Pages Routerデータ取得APIのレスポンス構造は複数ファイルにまたがるロジックの推論に基づく
- **1: 中リスク** - 静的アセット配信のCache-Controlヘッダー値は一般的なNext.jsの動作に基づく推論であり、ソースコードによる直接確認が不足

## 6) レビュアーチェックリスト（最小）
- [ ] Pages API RouteのNextApiRequest/NextApiResponseの型定義がソースコード（`shared/lib/utils.ts`）と一致しているか
- [ ] App Route Handlerのdynamic設定値の動作説明がソースコード（`route-modules/app-route/module.ts`）と整合しているか
- [ ] 画像最適化APIのクエリパラメータ（url, w, q）の仕様が`image-optimizer.ts`の実装と一致しているか
- [ ] revalidatePath/revalidateTagの制約事項が`revalidate.ts`の実装と一致しているか
- [ ] Draft ModeのCookie仕様（名前、属性）が`api-resolver.ts`および`api-utils/index.ts`と一致しているか
- [ ] Pages Routerデータ取得APIのレスポンス構造を`render.tsx`で確認
- [ ] 静的アセット配信のCache-Control値を`router-server.ts`または`serve-static.ts`で確認
