# Next.js

## 概要

Next.js は Vercel が開発・メンテナンスする React ベースのフルスタック Web アプリケーションフレームワークである。サーバーサイドレンダリング（SSR）、静的サイト生成（SSG）、App Router / Pages Router、API ルート、画像最適化、フォント最適化など、本番レベルの Web アプリケーション構築に必要な機能を包括的に提供する。Rust ベースの高速バンドラ Turbopack を内蔵し、開発・ビルドの高速化を実現している。

本リポジトリは pnpm モノレポ構成であり、Next.js フレームワーク本体（`packages/next`）を中心に、CLI ツール、ESLint プラグイン、フォントパッケージ、SWC ネイティブバインディング等の関連パッケージ群、および Turbopack バンドラの Rust クレート群を含む。

## 主な機能

| 機能カテゴリ | 説明 |
| --- | --- |
| サーバーサイドレンダリング（SSR） | React コンポーネントをサーバー側でレンダリングし、初期表示速度と SEO を向上させる |
| 静的サイト生成（SSG） | ビルド時にページを事前生成し、CDN 配信に最適化する |
| App Router | React Server Components ベースの新しいルーティングシステム（`app/` ディレクトリ） |
| Pages Router | ファイルベースの従来型ルーティングシステム（`pages/` ディレクトリ） |
| API ルート | サーバーサイド API エンドポイントをフレームワーク内で定義可能 |
| Turbopack バンドラ | Rust 製の高速バンドラによる開発サーバー・本番ビルドの高速化 |
| 画像最適化 | `next/image` による自動画像最適化（リサイズ、フォーマット変換、遅延読み込み） |
| フォント最適化 | `next/font` による Google Fonts / ローカルフォントの自動最適化とセルフホスティング |
| ミドルウェア | Edge Runtime で動作するリクエストインターセプト機構 |
| 動的インポート | `next/dynamic` によるコンポーネントの遅延読み込みとコード分割 |
| 国際化（i18n） | 組み込みの国際化ルーティングサポート |
| SWC コンパイラ | Rust 製の高速 JavaScript/TypeScript コンパイラ（Babel 代替） |
| OG 画像生成 | `next/og` による Open Graph 画像の動的生成 |
| サードパーティスクリプト統合 | `@next/third-parties` による Google Analytics 等の最適化された埋め込み |
| ESLint プラグイン | Next.js 固有のベストプラクティスを強制する ESLint ルール群 |
| create-next-app | プロジェクトのスキャフォールディング CLI ツール |

## 技術スタック

### コア

- フレームワーク: React 19（Server Components 対応）
- 言語: TypeScript 5.9 / JavaScript（フレームワーク本体）、Rust nightly-2026-01-04（Turbopack / SWC バインディング）
- ランタイム: Node.js >= 20.9.0
- パッケージマネージャ: pnpm 9.6.0
- モノレポ管理: Turborepo（turbo）、Lerna
- バンドラ: Turbopack（Rust 製）、Webpack 5.98（レガシー対応）
- コンパイラ: SWC（Rust 製 JavaScript/TypeScript トランスフォーマ）

### 主要ライブラリ

- react / react-dom 19.x（UI ライブラリ）
- styled-jsx（CSS-in-JS、組み込みスタイリング）
- postcss（CSS 後処理）
- jest / playwright（テストフレームワーク）
- eslint / prettier（静的解析・フォーマッタ）
- napi-rs（Node.js ネイティブアドオンバインディング）
- lightningcss（Rust 製 CSS パーサー/トランスフォーマ）
- serde / tokio（Rust 非同期ランタイム・シリアライゼーション）

## ディレクトリ構成

```
next.js/
├── packages/                    # 公開 npm パッケージ群
│   ├── next/                    # Next.js フレームワーク本体（npm: next）
│   │   ├── src/                 # ソースコード
│   │   │   ├── server/          # サーバーランタイム（SSR、ルーティング等）
│   │   │   ├── client/          # クライアントサイドランタイム
│   │   │   ├── build/           # ビルドツールチェーン
│   │   │   ├── cli/             # CLI エントリポイント（next dev/build/start）
│   │   │   ├── lib/             # 共通ユーティリティ
│   │   │   ├── shared/          # サーバー・クライアント共有モジュール
│   │   │   ├── export/          # 静的エクスポート機能
│   │   │   ├── pages/           # Pages Router 関連
│   │   │   ├── compiled/        # 事前コンパイル済み依存
│   │   │   └── telemetry/       # テレメトリ収集
│   │   └── dist/                # コンパイル済み出力（src/ のミラー構造）
│   ├── create-next-app/         # create-next-app CLI
│   ├── next-swc/                # SWC ネイティブ Rust バインディング
│   ├── eslint-plugin-next/      # Next.js ESLint プラグイン
│   ├── eslint-config-next/      # Next.js ESLint 設定プリセット
│   ├── font/                    # next/font 実装
│   ├── next-mdx/                # MDX サポート（@next/mdx）
│   ├── next-bundle-analyzer/    # バンドル解析ツール
│   ├── next-codemod/            # コードモッド（マイグレーション支援）
│   ├── next-env/                # 環境変数管理（@next/env）
│   ├── next-rspack/             # Rspack 統合（実験的）
│   ├── third-parties/           # サードパーティスクリプト統合
│   ├── react-refresh-utils/     # React Fast Refresh ユーティリティ
│   └── next-polyfill-*/         # ポリフィルパッケージ
├── turbopack/                   # Turbopack バンドラ（Rust、git subtree）
│   └── crates/                  # Turbopack 関連 Rust クレート群
├── crates/                      # Next.js 固有 Rust クレート群
│   ├── next-api/                # Next.js API 層
│   ├── next-build/              # ビルドロジック（Rust 側）
│   ├── next-core/               # コアロジック（Rust 側）
│   ├── next-custom-transforms/  # カスタム SWC トランスフォーム
│   ├── next-napi-bindings/      # NAPI バインディング
│   └── wasm/                    # WASM ビルド
├── test/                        # テストスイート
│   ├── e2e/                     # E2E テスト
│   ├── development/             # 開発サーバーテスト
│   ├── production/              # 本番ビルドテスト
│   ├── integration/             # 統合テスト
│   ├── unit/                    # ユニットテスト
│   └── lib/                     # テストユーティリティ
├── examples/                    # Next.js サンプルアプリケーション集
├── docs/                        # ドキュメント
├── scripts/                     # ビルド・メンテナンス用スクリプト
├── errors/                      # エラーコード定義
├── Cargo.toml                   # Rust ワークスペース設定
├── turbo.json                   # Turborepo 設定
├── pnpm-workspace.yaml          # pnpm ワークスペース設定
└── package.json                 # ルート package.json
```

## セットアップ

### 必要条件

- Node.js >= 20.9.0
- pnpm 9.6.0（`corepack enable` で有効化可能）
- Rust nightly-2026-01-04（Turbopack / SWC のネイティブビルドを行う場合）
  - rustfmt, clippy, rust-analyzer コンポーネントが必要

### インストール手順

```bash
# リポジトリのクローン
git clone https://github.com/vercel/next.js.git
cd next.js

# 依存関係のインストール（postinstall でネイティブバイナリの取得も実行される）
pnpm install

# Next.js パッケージのビルド
pnpm build
```

## 開発

### ビルド

```bash
# Next.js パッケージのみビルド
pnpm --filter=next build

# 全パッケージビルド（Turborepo による差分ビルド）
pnpm build

# ネイティブ SWC バイナリのビルド（Rust コード変更時）
pnpm swc-build-native

# 開発モード（ウォッチビルド）
pnpm --filter=next dev
```

### テスト

```bash
# 開発モード + Turbopack でテスト実行（推奨）
pnpm test-dev-turbo test/<テストファイルパス>

# 開発モード + Webpack でテスト実行
pnpm test-dev-webpack test/<テストファイルパス>

# 本番ビルド + Turbopack でテスト実行
pnpm test-start-turbo test/<テストファイルパス>

# 本番ビルド + Webpack でテスト実行
pnpm test-start-webpack test/<テストファイルパス>

# ユニットテストのみ（高速、ブラウザ不要）
pnpm test-unit

# リビルドなしでテスト実行（高速イテレーション向け）
pnpm testonly <テストファイルパス>

# パターンマッチによるテスト実行
pnpm test-dev-turbo -t "パターン"

# 新規テストファイルの生成
pnpm new-test
```

### リント・フォーマット

```bash
# 全リント実行（型チェック、Prettier、ESLint、ast-grep）
pnpm lint

# リント自動修正
pnpm lint-fix

# フォーマットのみ修正
pnpm prettier-fix

# TypeScript 型チェックのみ
pnpm types
```

### 高速ローカル開発ワークフロー

```bash
# 1. ウォッチモードでバックグラウンドビルド開始
pnpm --filter=next dev

# 2. 高速テスト実行（パッキングスキップ）
NEXT_SKIP_ISOLATE=1 NEXT_TEST_MODE=dev pnpm testonly test/<テストファイルパス>
```

### リビルドが必要なケース

- Next.js のソースコード変更後: `pnpm build`
- Turbopack（Rust）のコード変更後: `pnpm swc-build-native`
- 両方変更した場合: `pnpm turbo build build-native`
- ブランチ切り替え後: `pnpm build`
