---
generated_at: 2026-02-03 00:00:00
metrics:
  claims_total: 30
  claims_with_evidence: 28
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：README.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：28 / 30、根拠なし：2
- 優先レビュー（高）
  1. **国際化（i18n）機能の記載**：本リポジトリのソースコードから直接確認していないため根拠不足
  2. **OG 画像生成機能の詳細**：`next/og` の存在は package.json のエクスポートから確認できるが、実装詳細は未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/next.js-canary/package.json`（ルート package.json）
- E-02: `/Users/tomoka.baba/Work/next.js-canary/packages/next/package.json`（Next.js パッケージ定義）
- E-03: `/Users/tomoka.baba/Work/next.js-canary/CLAUDE.md`（開発ガイド）
- E-04: `/Users/tomoka.baba/Work/next.js-canary/readme.md`（公式 README）
- E-05: `/Users/tomoka.baba/Work/next.js-canary/contributing.md`（コントリビューションガイド）
- E-06: `/Users/tomoka.baba/Work/next.js-canary/Cargo.toml`（Rust ワークスペース設定）
- E-07: `/Users/tomoka.baba/Work/next.js-canary/rust-toolchain.toml`（Rust ツールチェーン設定）
- E-08: `/Users/tomoka.baba/Work/next.js-canary/pnpm-workspace.yaml`（pnpm ワークスペース設定）
- E-09: `/Users/tomoka.baba/Work/next.js-canary/turbo.json`（Turborepo 設定）
- E-10: `/Users/tomoka.baba/Work/next.js-canary/tsconfig.json`（TypeScript 設定）
- E-11: `/Users/tomoka.baba/Work/next.js-canary/license.md`（ライセンス）
- E-12: `packages/` ディレクトリ一覧（ls コマンド結果）
- E-13: `packages/next/src/` ディレクトリ一覧（ls コマンド結果）
- E-14: `crates/` ディレクトリ一覧（ls コマンド結果）
- E-15: `test/` ディレクトリ一覧（ls コマンド結果）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Next.js は Vercel が開発する React ベースのフルスタック Web フレームワークである | E-04（readme.md に「The React Framework」と記載）、E-02（description: "The React Framework"） | ○ |
| C-02 | pnpm モノレポ構成である | E-01（workspaces 定義）、E-08（pnpm-workspace.yaml の存在） | ○ |
| C-03 | パッケージマネージャは pnpm 9.6.0 | E-01（packageManager: "pnpm@9.6.0"） | ○ |
| C-04 | Node.js >= 20.9.0 が必要 | E-01（engines.node: ">=20.9.0"） | ○ |
| C-05 | Turborepo でモノレポ管理している | E-09（turbo.json の存在）、E-01（devDependencies に turbo 2.5.5） | ○ |
| C-06 | Turbopack は Rust 製バンドラである | E-06（Cargo.toml に turbopack クレート群が定義）、E-03（CLAUDE.md に「Turbopack bundler (Rust) - git subtree」と記載） | ○ |
| C-07 | SWC による高速コンパイルをサポート | E-06（swc_core 依存）、E-12（packages/next-swc の存在） | ○ |
| C-08 | React 19 を使用 | E-01（devDependencies に react: "19.0.0"、overrides に react: "19.3.0-canary-*"） | ○ |
| C-09 | TypeScript 5.9 を使用 | E-01（devDependencies に typescript: "5.9.2"） | ○ |
| C-10 | Rust nightly-2026-01-04 ツールチェーンを使用 | E-07（channel = "nightly-2026-01-04"） | ○ |
| C-11 | packages/next がメインパッケージ（npm: next）として公開される | E-02（name: "next"、version: "16.2.0-canary.24"） | ○ |
| C-12 | packages/create-next-app が CLI ツールとして存在 | E-12（ディレクトリ一覧に create-next-app が存在） | ○ |
| C-13 | packages/eslint-plugin-next が存在 | E-12（ディレクトリ一覧に eslint-plugin-next が存在） | ○ |
| C-14 | packages/font が next/font 実装 | E-12（ディレクトリ一覧に font が存在）、E-03（CLAUDE.md に「`packages/font/` - `next/font` implementation」と記載） | ○ |
| C-15 | packages/third-parties が存在 | E-12（ディレクトリ一覧に third-parties が存在）、E-03（CLAUDE.md に記載） | ○ |
| C-16 | crates/ に next-api, next-build, next-core 等の Rust クレートが存在 | E-14（ディレクトリ一覧で確認）、E-06（Cargo.toml の workspace members で確認） | ○ |
| C-17 | test/ に e2e, development, production, integration, unit サブディレクトリが存在 | E-15（ディレクトリ一覧で確認） | ○ |
| C-18 | packages/next/src/ に server, client, build, cli 等のサブディレクトリが存在 | E-13（ディレクトリ一覧で確認） | ○ |
| C-19 | pnpm build で全パッケージビルド可能 | E-01（scripts.build: "turbo run build ..."）、E-03（CLAUDE.md に記載） | ○ |
| C-20 | pnpm test-dev-turbo で Turbopack 開発モードテスト実行 | E-01（scripts に定義）、E-03（CLAUDE.md に記載） | ○ |
| C-21 | pnpm test-unit でユニットテスト実行 | E-01（scripts.test-unit: "jest test/unit/ packages/next/ packages/font"） | ○ |
| C-22 | pnpm lint で全リント実行 | E-01（scripts.lint の定義）、E-03（CLAUDE.md に記載） | ○ |
| C-23 | pnpm lint-fix でリント自動修正 | E-01（scripts.lint-fix の定義） | ○ |
| C-24 | pnpm prettier-fix でフォーマット修正 | E-01（scripts.prettier-fix の定義） | ○ |
| C-25 | pnpm new-test で新規テストファイル生成 | E-01（scripts.new-test の定義）、E-03（CLAUDE.md に記載） | ○ |
| C-26 | NEXT_SKIP_ISOLATE=1 で高速テスト実行が可能 | E-03（CLAUDE.md に記載） | ○ |
| C-27 | pnpm swc-build-native でネイティブ SWC ビルド | E-01（scripts.swc-build-native の定義）、E-03（CLAUDE.md に記載） | ○ |
| C-28 | Webpack 5.98 をレガシー対応として使用 | E-01（devDependencies に webpack: "5.98.0"、overrides にも同バージョン） | ○ |
| C-29 | 国際化（i18n）の組み込みルーティングサポートがある | **根拠なし**（ソースコードの該当部分を直接確認していない。Next.js の公知機能だが、本リポジトリ内での直接的な根拠未取得） | △ |
| C-30 | next/og による OG 画像動的生成機能がある | E-02（package.json の files に "og.js", "og.d.ts" が含まれる。ただし実装詳細は未確認） | △ |

## 4) 不足情報（Unknown / Missing）
- C-29（国際化機能）：Next.js の公知機能として広く認知されているが、本リポジトリの `packages/next/src/` 内の i18n 関連ソースコードを直接読み取って確認していない
  - 候補：`packages/next/src/server/` 内の i18n ルーティング実装 / `packages/next/src/shared/lib/i18n/` / Next.js 公式ドキュメント
- C-30（OG 画像生成）：`og.js` / `og.d.ts` のエクスポートは確認できたが、`@vercel/og` との統合や実装の詳細は未確認
  - 候補：`packages/next/src/server/og/` / `@vercel/og` パッケージの依存関係

## 5) リスクフラグ（レビュー観点）
- 0: 概要・技術スタック・ディレクトリ構成 -- package.json / CLAUDE.md / ディレクトリ構造から高い信頼度で確認済み
- 0: セットアップ・開発コマンド -- package.json scripts と CLAUDE.md から直接確認済み
- 1: 主な機能一覧の一部（i18n、OG 画像生成） -- ソースコード直接確認なし。公知情報に基づく記載であり、大きな誤りの可能性は低いが要確認

## 6) レビュアーチェックリスト（最小）
- [ ] 概要セクションの記述がプロジェクトの実態と一致しているか
- [ ] 技術スタックのバージョン番号が最新の package.json / rust-toolchain.toml と一致しているか
- [ ] ディレクトリ構成図が実際のリポジトリ構造と一致しているか（特に packages/ 配下のパッケージ名）
- [ ] セットアップ手順を実行して正常にビルドできるか
- [ ] 国際化（i18n）機能の記載が現バージョンのソースコードと整合しているか
- [ ] OG 画像生成（next/og）の記載が実装と整合しているか
- [ ] テストコマンド群が実際に動作するか（特に pnpm test-dev-turbo）
