---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 42
  claims_with_evidence: 39
  claims_without_evidence: 3
confidence_derived: 0.93
---

# 根拠レポート：コードリーディングガイドライン

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：39 / 42、根拠なし：3
- 優先レビュー（高）
  1. **C-38: ISRの実装詳細**：IncrementalCacheの内部構造までは詳細に確認していない
  2. **C-40: Flightデータフォーマット**：用語集の説明が概念的であり、具体的なワイヤーフォーマット仕様の確認が不足
  3. **C-41: Fizzストリーミングの詳細**：用語集の説明が概念的であり、React内部実装との対応確認が不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `package.json` - ルートのパッケージ定義、スクリプト一覧、依存関係
- E-02: `Cargo.toml` - Rust workspace定義、クレート一覧
- E-03: `turbo.json` - Turborepo設定
- E-04: `packages/next/package.json` - Next.jsパッケージのメタデータ（バージョン16.2.0-canary.24）
- E-05: `packages/next/src/cli/next-dev.ts` - 開発サーバーCLIエントリーポイント
- E-06: `packages/next/src/cli/next-start.ts` - 本番サーバーCLIエントリーポイント
- E-07: `packages/next/src/cli/next-build.ts` - ビルドCLIエントリーポイント
- E-08: `packages/next/src/server/base-server.ts` - サーバー基底クラス
- E-09: `packages/next/src/server/next-server.ts` - 本番サーバー（BaseServer継承）
- E-10: `packages/next/src/server/dev/next-dev-server.ts` - 開発サーバー（NextNodeServer継承）
- E-11: `packages/next/src/server/lib/router-server.ts` - ルーターサーバー
- E-12: `packages/next/src/server/route-kind.ts` - RouteKind列挙型
- E-13: `packages/next/src/server/route-modules/route-module.ts` - RouteModule基底
- E-14: `packages/next/src/server/route-definitions/route-definition.ts` - RouteDefinitionインターフェース
- E-15: `packages/next/src/server/normalizers/normalizer.ts` - Normalizerインターフェース
- E-16: `packages/next/src/server/normalizers/request/pathname-normalizer.ts` - PathnameNormalizer
- E-17: `packages/next/src/shared/lib/constants.ts` - 共有定数
- E-18: `packages/next/src/client/link.tsx` - Linkコンポーネント（'use client'ディレクティブ）
- E-19: `packages/next/src/client/components/navigation.ts` - ナビゲーションフック
- E-20: `packages/next/src/server/app-render/app-render.tsx` - App Routerレンダラー
- E-21: `packages/next/src/server/async-storage/request-store.ts` - リクエストストア
- E-22: `packages/next/src/server/lib/start-server.ts` - サーバー起動処理
- E-23: `packages/next/src/build/index.ts` - ビルドエントリーポイント
- E-24: `packages/next/src/server/config.ts` - 設定読み込み
- E-25: `crates/next-core/Cargo.toml` - next-coreクレート定義
- E-26: `crates/next-custom-transforms/src/` - カスタムトランスフォームソース
- E-27: `CLAUDE.md` - 開発ガイド
- E-28: ディレクトリ構造の実地確認（ls結果）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | プロジェクトはTypeScript/JavaScriptとRustの2言語で構成される | E-01, E-02, E-28 | ○ |
| C-02 | pnpmモノレポ構成である | E-01, E-03 | ○ |
| C-03 | Next.jsのバージョンは16.2.0-canary.24 | E-04 | ○ |
| C-04 | ES Modulesベースのモジュールシステムを採用 | E-05, E-06, E-07 | ○ |
| C-05 | Rust側はCargo workspaceで構成 | E-02, E-25 | ○ |
| C-06 | RouteKindは5つの値（PAGES, PAGES_API, APP_PAGE, APP_ROUTE, IMAGE）を持つ | E-12 | ○ |
| C-07 | RouteDefinitionインターフェースはkind, bundlePath, filename, page, pathnameを持つ | E-14 | ○ |
| C-08 | 型のみのインポート（import type）が使用される | E-08, E-09 | ○ |
| C-09 | compiled モジュールがnext/dist/compiled/から参照される | E-22, E-11 | ○ |
| C-10 | CLIエントリーポイントはnext-dev.ts, next-build.ts, next-start.ts | E-05, E-06, E-07 | ○ |
| C-11 | サーバー継承階層: BaseServer → NextNodeServer → DevServer | E-08, E-09, E-10 | ○ |
| C-12 | NextNodeServerはBaseServerを継承する | E-09 (import BaseServer from './base-server') | ○ |
| C-13 | DevServerはServer (NextNodeServer)を継承する | E-10 (import Server from '../next-server') | ○ |
| C-14 | Route Moduleパターンが使われている | E-13, E-28 | ○ |
| C-15 | RouteModuleOptionsはdefinitionとuserlandを持つ | E-13 | ○ |
| C-16 | Normalizerインターフェースはnormalize()メソッドを持つ | E-15 | ○ |
| C-17 | PathnameNormalizerはmatch()メソッドを追加で持つ | E-16 | ○ |
| C-18 | App RouterとPages Routerの2つのルーティングシステムが共存 | E-12, E-17 | ○ |
| C-19 | 'use client'ディレクティブでクライアントコンポーネントを明示 | E-18 | ○ |
| C-20 | RSC関連ヘッダーがapp-router-headers.tsに集約されている | E-20 | ○ |
| C-21 | AsyncLocalStorageベースのストアパターンが使われている | E-20, E-21 | ○ |
| C-22 | ファイル名はkebab-caseが標準 | E-28 | ○ |
| C-23 | *.external.tsはバンドル境界モジュールを示す | E-20, E-28 | ○ |
| C-24 | *.shared-runtime.tsはクライアント/サーバー共有モジュールを示す | E-19, E-28 | ○ |
| C-25 | 定数はUPPER_SNAKE_CASEで命名される | E-17 | ○ |
| C-26 | packages/next/src/server/が最も変更が多いディレクトリ | E-27 | ○ |
| C-27 | ビルド出力はdist/でsrc/の鏡像構造 | E-27 | ○ |
| C-28 | router-server.tsがリクエストルーティングを担当 | E-11 | ○ |
| C-29 | マニフェストファイルがビルド時に生成される | E-17, E-23 | ○ |
| C-30 | PAGES_MANIFEST, APP_PATHS_MANIFEST等の定数が存在する | E-17 | ○ |
| C-31 | next devはchild_processのforkで子プロセスを起動する | E-05 | ○ |
| C-32 | next startはstartServer()を呼び出す | E-06 | ○ |
| C-33 | テストはtest/{e2e,development,production,integration,unit}に分類される | E-28 | ○ |
| C-34 | テスト実行コマンドの説明（test-dev-turbo等） | E-01, E-27 | ○ |
| C-35 | DEBUG=next:*でデバッグログが有効化される | E-27 | ○ |
| C-36 | crates/next-custom-transforms/にSWCカスタムトランスフォームがある | E-26 | ○ |
| C-37 | turbopack/はgit subtreeとして管理される | E-27 | ○ |
| C-38 | IncrementalCache がISRの実装を提供する | E-09 | △ |
| C-39 | app-render.tsxがFizzストリーミングレンダリングを行う | E-20 | ○ |
| C-40 | FlightはRSCのワイヤーフォーマットである | **根拠なし** | △ |
| C-41 | FizzはReactのストリーミングサーバーレンダラーである | **根拠なし** | △ |
| C-42 | Providerパターンがルートマッチャーへのデータ供給に使われる | E-10, E-28 | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-38（IncrementalCacheの詳細）**: `src/server/lib/incremental-cache/` ディレクトリ内部の実装詳細を完全には確認していない。概要レベルの記載は E-09 のimport文から確認できるが、キャッシュ戦略の詳細は未検証。
  - 候補：`src/server/lib/incremental-cache/index.ts` / `src/server/response-cache/` / Next.js公式ドキュメント ISRセクション
- **C-40（Flightフォーマット）**: React Server Componentsのワイヤーフォーマットとしての「Flight」は、React公式のRFC・実装に由来する用語であり、本リポジトリ内では変数名・型名として散見されるが、明示的な仕様文書は確認していない。
  - 候補：React Server Components RFC / `react-server-dom-webpack` パッケージ / React公式ドキュメント
- **C-41（Fizz）**: ReactのストリーミングレンダラーとしてのFizzは、React内部の実装名であり、app-render.tsx内の `renderToInitialFizzStream` 等の関数名から推定しているが、公式定義文書は本リポジトリ内に存在しない。
  - 候補：React GitHub リポジトリ / React Working Group ディスカッション

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: ディレクトリ構造、ファイル命名規則、CLI エントリーポイント - すべてファイルシステムの直接確認に基づく
- **0（低リスク）**: RouteKind、RouteDefinition、Normalizer等のインターフェース定義 - ソースコードから直接引用
- **0（低リスク）**: サーバー継承階層 - import文とクラス定義から直接確認
- **1（中リスク）**: ISR/IncrementalCacheの説明 - 概要レベルの記載であり、内部実装の詳細は未検証
- **1（中リスク）**: Flight/Fizz用語の説明 - React内部の概念であり、本リポジトリ外の情報に依存
- **0（低リスク）**: テスト実行コマンド - package.jsonとCLAUDE.mdから直接確認

## 6) レビュアーチェックリスト（最小）
- [ ] サーバー継承階層（BaseServer → NextNodeServer → DevServer）の説明が実際のコードと一致するか
- [ ] RouteKind列挙型の値が最新のソースコードと一致するか
- [ ] ディレクトリ構造図が現在のリポジトリと一致するか
- [ ] CLIエントリーポイント（next-dev.ts, next-build.ts, next-start.ts）の処理フローが正確か
- [ ] IncrementalCache/ISRの説明が実装と整合するか（要ソースコード確認）
- [ ] Flight/Fizzの用語説明がReact公式の定義と整合するか
- [ ] 命名規則の表が網羅的か（追加すべきパターンがないか）
- [ ] テスト実行コマンドが現在のpackage.jsonスクリプトと一致するか
