---
generated_at: 2026-02-03 12:00:00
metrics:
  claims_total: 35
  claims_with_evidence: 32
  claims_without_evidence: 3
confidence_derived: 0.91
---

# 根拠レポート：アーキテクチャ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：32 / 35、根拠なし：3
- 優先レビュー（高）
  1. **Rspack バンドラー統合の詳細**：設定ファイルおよびスクリプトに存在が確認されるが、実験的機能であり内部実装の詳細が不明確
  2. **MCP サーバーの用途と成熟度**：ディレクトリ・ファイルは確認できるが、機能の完全性・安定性の判断根拠が不足
  3. **Turbopack プロダクションビルドの完成度**：Turbopack はビルドオプションとして存在するが、Webpack と同等の機能カバレッジかの判断根拠が不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `packages/next/src/cli/next-dev.ts` - CLI エントリーポイント（dev）
- E-02: `packages/next/src/cli/next-build.ts` - CLI エントリーポイント（build）
- E-03: `packages/next/src/cli/next-start.ts` - CLI エントリーポイント（start）※CLAUDE.md記載
- E-04: `packages/next/src/server/base-server.ts` - 抽象基底サーバークラス
- E-05: `packages/next/src/server/next-server.ts` - プロダクションサーバー（NextNodeServer）
- E-06: `packages/next/src/server/dev/next-dev-server.ts` - 開発サーバー（NextDevServer）
- E-07: `packages/next/src/server/lib/router-server.ts` - ルーターサーバー
- E-08: `packages/next/src/server/route-modules/route-module.ts` - ルートモジュール基底クラス
- E-09: `packages/next/src/server/route-modules/` - app-page, app-route, pages, pages-api ディレクトリ
- E-10: `packages/next/src/server/app-render/app-render.tsx` - App Router レンダリング
- E-11: `packages/next/src/server/app-render/create-component-tree.tsx` - コンポーネントツリー生成
- E-12: `packages/next/src/server/app-render/csrf-protection.ts` - CSRF 保護
- E-13: `packages/next/src/server/app-render/action-handler.ts` - Server Action ハンドラー
- E-14: `packages/next/src/server/lib/incremental-cache/` - ISR キャッシュ
- E-15: `packages/next/src/server/lib/incremental-cache/file-system-cache.ts` - ファイルシステムキャッシュ
- E-16: `packages/next/src/server/lib/incremental-cache/memory-cache.external.ts` - メモリキャッシュ
- E-17: `packages/next/src/server/response-cache/` - レスポンスキャッシュ
- E-18: `packages/next/src/server/lib/cache-handlers/` - キャッシュハンドラー
- E-19: `packages/next/src/server/use-cache/` - "use cache" ディレクティブ
- E-20: `packages/next/src/server/async-storage/` - AsyncLocalStorage 管理
- E-21: `packages/next/src/server/web/` - Edge Runtime / Web API
- E-22: `packages/next/src/server/mcp/` - MCP サーバー
- E-23: `packages/next/src/server/lib/trace/tracer.ts` - OpenTelemetry トレーシング
- E-24: `packages/next/src/server/dev/hot-middleware.ts` - HMR WebSocket
- E-25: `packages/next/src/build/index.ts` - ビルドエントリーポイント
- E-26: `packages/next/src/build/webpack-config.ts` - Webpack 設定
- E-27: `packages/next/src/build/swc/` - SWC バインディング
- E-28: `packages/next/src/client/components/app-router.tsx` - App Router クライアント
- E-29: `packages/next/src/client/components/router-reducer/` - Router Reducer
- E-30: `packages/next/src/client/components/segment-cache/` - セグメントキャッシュ
- E-31: `packages/next/src/shared/lib/constants.ts` - 共有定数
- E-32: `packages/next/src/shared/lib/router/` - ルーター共通ロジック
- E-33: `package.json` - モノレポ設定、依存関係
- E-34: `Cargo.toml` - Rust ワークスペース設定
- E-35: `turbo.json` - Turborepo 設定
- E-36: `pnpm-workspace.yaml` - pnpm ワークスペース設定（package.json の workspaces 欄）
- E-37: `packages/next/src/server/normalizers/` - URL 正規化
- E-38: `packages/next/src/server/lib/lru-cache.ts` - LRU キャッシュ
- E-39: `packages/next/src/server/image-optimizer.ts` - 画像最適化
- E-40: `packages/next/src/telemetry/` - テレメトリ
- E-41: `packages/next/src/server/instrumentation/` - インストルメンテーション
- E-42: `packages/next/src/server/after/` - after() API
- E-43: `CLAUDE.md` - プロジェクト開発ガイド
- E-44: `crates/next-custom-transforms/` - SWC カスタム変換
- E-45: `crates/next-core/` - Turbopack 統合コア
- E-46: `turbopack/crates/turbo-tasks/` - 増分計算フレームワーク
- E-47: `packages/next/src/build/turbopack-build/` - Turbopack ビルド
- E-48: `packages/next/src/server/dev/log-requests.ts` - リクエストログ
- E-49: `packages/next/src/server/async-storage/draft-mode-provider.ts` - ドラフトモード
- E-50: `packages/next/src/lib/bundler.ts` - バンドラー抽象化（CLAUDE.md 記載の next-dev.ts import より確認）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Next.js は pnpm モノレポとして構成されている | E-33, E-36, E-35 | ○ |
| C-02 | TypeScript（Node.js）と Rust（SWC/Turbopack）の二層構造を持つ | E-33, E-34, E-44, E-45 | ○ |
| C-03 | 開発サーバー・プロダクションサーバー・ビルドシステムの三つの主要サブシステム | E-01, E-02, E-03, E-43 | ○ |
| C-04 | CLI レイヤーが next-dev.ts, next-build.ts, next-start.ts のエントリーポイントを持つ | E-01, E-02, E-03, E-43 | ○ |
| C-05 | Router Server が router-server.ts で全リクエストを受信する | E-07 | ○ |
| C-06 | BaseServer が抽象基底クラスで NextNodeServer と NextDevServer が継承する | E-04, E-05, E-06 | ○ |
| C-07 | Route Module が app-page, app-route, pages, pages-api の 4 種類ある | E-08, E-09 | ○ |
| C-08 | App Render が React Server Components をストリーミングレンダリングする | E-10, E-11 | ○ |
| C-09 | Incremental Cache が ISR キャッシュを管理する | E-14, E-15, E-16 | ○ |
| C-10 | Response Cache がレンダリング結果をキャッシュする | E-17 | ○ |
| C-11 | File System Cache と Memory Cache がキャッシュバックエンドとして存在する | E-15, E-16 | ○ |
| C-12 | Cache Handlers がプラグイン可能なキャッシュ機構を提供する | E-18 | ○ |
| C-13 | "use cache" ディレクティブが実装されている | E-19 | ○ |
| C-14 | AsyncLocalStorage によるリクエストスコープ管理を行っている | E-20 | ○ |
| C-15 | Edge Runtime が src/server/web/ に実装されている | E-21 | ○ |
| C-16 | MCP サーバーが src/server/mcp/ に実装されている | E-22 | ○ |
| C-17 | OpenTelemetry 統合によるトレーシングが存在する | E-23, E-33 | ○ |
| C-18 | HMR が WebSocket を通じて実現される | E-24 | ○ |
| C-19 | Webpack がモジュールバンドラーとして使用される | E-25, E-26, E-33 | ○ |
| C-20 | Turbopack が次世代バンドラーとして使用可能 | E-47, E-45, E-46, E-34 | ○ |
| C-21 | SWC が TypeScript/JSX コンパイルに使用される | E-27, E-44, E-34 | ○ |
| C-22 | クライアント側に App Router (app-router.tsx) が存在する | E-28 | ○ |
| C-23 | Router Reducer でクライアント側ステート管理を行う | E-29 | ○ |
| C-24 | Segment Cache がクライアント側に存在する | E-30 | ○ |
| C-25 | 共有定数が src/shared/lib/constants.ts に定義されている | E-31 | ○ |
| C-26 | URL 正規化がノーマライザーチェーンで実装されている | E-37 | ○ |
| C-27 | LRU キャッシュが汎用キャッシュとして存在する | E-38 | ○ |
| C-28 | 画像最適化が image-optimizer.ts で実装されている | E-39 | ○ |
| C-29 | テレメトリが src/telemetry/ で実装されている | E-40 | ○ |
| C-30 | CSRF 保護が Server Actions に実装されている | E-12 | ○ |
| C-31 | after() API がリクエスト完了後の非同期タスクを実行する | E-42 | ○ |
| C-32 | Bundler 型で Webpack / Turbopack / Rspack を抽象化している | E-50, E-01 | ○ |
| C-33 | Rspack が代替バンドラーとして実験的にサポートされている | E-33 | △ |
| C-34 | MCP サーバーが AI ツールとの統合を提供する | E-22 | △ |
| C-35 | Turbopack の増分計算が turbo-tasks フレームワークで実現されている | E-46 | △ |

## 4) 不足情報（Unknown / Missing）
- **C-33 (Rspack サポート)**: `package.json` のスクリプト（`with-rspack`）や `@rspack/core` 依存から存在が確認できるが、実験的機能の具体的な制限事項やカバレッジに関するドキュメントが不足
  - 候補：`packages/next/src/build/` 内の Rspack 固有設定 / UPGRADING.md / リリースノート
- **C-34 (MCP サーバーの目的)**: ディレクトリ構造とファイル名から AI ツール統合と推定したが、公式ドキュメントや README での機能説明が不足
  - 候補：`src/server/mcp/` 内のソースコード詳細読解 / Next.js 公式ドキュメント
- **C-35 (Turbopack 増分計算の詳細)**: `turbo-tasks` クレートの存在は確認できるが、増分計算の具体的な仕組み（依存グラフ管理、無効化戦略等）の技術的詳細は Rust ソースコードの深い解析が必要
  - 候補：`turbopack/crates/turbo-tasks/` のソースコード / Turbopack アーキテクチャドキュメント

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: サーバー継承階層、Route Module 体系、キャッシュシステム構成 -- ソースコードの import 文と継承関係から直接確認済み
- **0（低リスク）**: パッケージ構造、ディレクトリ構成 -- ファイルシステム走査で直接確認済み
- **1（中リスク）**: データフローの記述順序 -- ソースコード構造から推定した処理順序であり、実行時の動的分岐によって異なるパスを辿る可能性がある
- **1（中リスク）**: Rspack / MCP / Turbopack 関連 -- 実験的機能であり、バージョン間で変更される可能性が高い
- **2（高リスク）**: 外部システム連携の網羅性 -- Vercel プラットフォーム固有の統合（Edge Functions、ISR Worker 等）の詳細は OSS コードだけでは完全に把握できない

## 6) レビュアーチェックリスト（最小）
- [ ] サーバー継承階層（BaseServer -> NextNodeServer -> NextDevServer）が実際のコードと一致するか確認
- [ ] Route Module の 4 種類（app-page, app-route, pages, pages-api）が網羅的か確認
- [ ] キャッシュシステムの各レイヤー（Response Cache, Incremental Cache, File System Cache, Memory Cache, Cache Handlers）の関係が正確か確認
- [ ] リクエスト処理フローの順序（Router Server -> Resolve Routes -> Middleware -> BaseServer -> Route Module -> Render）が実際の動作と一致するか確認
- [ ] Rspack サポートの現状（実験的/安定）が正確に記述されているか確認
- [ ] MCP サーバーの目的と機能が正確に記述されているか確認
- [ ] Turbopack のプロダクションビルド対応状況が最新の状態を反映しているか確認
- [ ] Edge Runtime の対応範囲（Middleware のみ / Route Handlers も含む等）が正確か確認
