# アーキテクチャ構成図

## システム全体構成図

```mermaid
graph TB
    subgraph "CLI Layer"
        CLI_DEV["next dev<br/>(next-dev.ts)"]
        CLI_BUILD["next build<br/>(next-build.ts)"]
        CLI_START["next start<br/>(next-start.ts)"]
    end

    subgraph "Router Server Layer"
        RS["Router Server<br/>(router-server.ts)"]
        RR["Resolve Routes<br/>(resolve-routes.ts)"]
        FSC["Filesystem Check<br/>(setupFsCheck)"]
        MW["Middleware<br/>(Edge Runtime)"]
    end

    subgraph "Server Runtime Layer"
        BS["BaseServer<br/>(base-server.ts)"]
        NNS["NextNodeServer<br/>(next-server.ts)"]
        NDS["NextDevServer<br/>(next-dev-server.ts)"]
    end

    subgraph "Route Modules"
        RM_AP["AppPageRouteModule"]
        RM_AR["AppRouteRouteModule"]
        RM_P["PagesRouteModule"]
        RM_PA["PagesAPIRouteModule"]
    end

    subgraph "Rendering"
        AR["App Render<br/>(app-render.tsx)"]
        CT["Component Tree<br/>(create-component-tree.tsx)"]
        PR["Pages Render<br/>(render.tsx)"]
    end

    subgraph "Cache System"
        RC["Response Cache"]
        IC["Incremental Cache"]
        FSCache["File System Cache"]
        MC["Memory Cache"]
        CH["Cache Handlers"]
        UC["use cache"]
    end

    subgraph "Client Runtime"
        APR["App Router<br/>(app-router.tsx)"]
        RR_C["Router Reducer"]
        SC["Segment Cache"]
        NAV["Navigation API"]
        HR["Hydration"]
    end

    subgraph "Build System"
        BI["Build Index<br/>(build/index.ts)"]
        WC["Webpack Config"]
        WB["Webpack Build"]
        TB["Turbopack Build"]
        SA["Static Analysis"]
    end

    subgraph "Native Layer (Rust)"
        SWC["SWC Transforms<br/>(next-custom-transforms)"]
        NC["Next Core<br/>(next-core)"]
        TP["Turbopack<br/>(turbo-tasks)"]
        NAPI["N-API Bindings"]
    end

    subgraph "Shared"
        CONST["Constants"]
        ROUTER["Router Utils"]
        I18N["i18n"]
        UTILS["Utilities"]
    end

    CLI_DEV --> RS
    CLI_START --> RS
    CLI_BUILD --> BI

    RS --> RR
    RS --> FSC
    RR --> MW
    RS --> BS

    BS --> NNS
    NNS --> NDS

    NNS --> RM_AP
    NNS --> RM_AR
    NNS --> RM_P
    NNS --> RM_PA

    RM_AP --> AR
    AR --> CT
    RM_P --> PR

    NNS --> RC
    RC --> IC
    IC --> FSCache
    IC --> MC
    IC --> CH
    AR --> UC

    BI --> WC
    WC --> WB
    BI --> TB
    BI --> SA

    WB --> SWC
    TB --> TP
    TP --> NC
    SWC --> NAPI

    APR --> RR_C
    APR --> SC
    APR --> NAV
    APR --> HR

    BS --> CONST
    BS --> ROUTER
    APR --> ROUTER
    RS --> I18N
    BS --> UTILS
```

## サーバー継承階層図

```mermaid
classDiagram
    class BaseServer {
        <<abstract>>
        +run()
        +render()
        +renderToResponseCache()
        +handleRequest()
        #findPageComponents()
        #renderHTML()
        #sendRenderResult()
    }

    class NextNodeServer {
        +runMiddleware()
        +loadComponents()
        +incrementalCache
        +responseCache
        #createServerRouteHandler()
        #setupFsChecker()
    }

    class NextDevServer {
        +hotReloader
        +devBundlerService
        +onDemandEntryHandler
        #ensurePage()
        #getMiddleware()
    }

    BaseServer <|-- NextNodeServer
    NextNodeServer <|-- NextDevServer
```

## ルートモジュール体系図

```mermaid
classDiagram
    class RouteModule {
        <<abstract>>
        +definition: RouteDefinition
        +handle()
        +render()
    }

    class AppPageRouteModule {
        +render(): StreamingResponse
        -renderToHTMLOrFlight()
    }

    class AppRouteRouteModule {
        +handle(): Response
        -executeRoute()
    }

    class PagesRouteModule {
        +render(): HTML
        -renderToHTML()
    }

    class PagesAPIRouteModule {
        +handle(): Response
        -executeApiHandler()
    }

    RouteModule <|-- AppPageRouteModule
    RouteModule <|-- AppRouteRouteModule
    RouteModule <|-- PagesRouteModule
    RouteModule <|-- PagesAPIRouteModule
```

## リクエスト処理フロー図

```mermaid
sequenceDiagram
    participant C as Client
    participant RS as Router Server
    participant RR as Resolve Routes
    participant MW as Middleware
    participant BS as BaseServer
    participant RM as Route Module
    participant AR as App Render
    participant RC as Response Cache
    participant IC as Incremental Cache

    C->>RS: HTTP Request
    RS->>RR: Resolve Route
    RR->>MW: Execute Middleware (Edge Runtime)
    MW-->>RR: Middleware Response/Rewrite
    RR-->>RS: Resolved Route

    RS->>BS: Handle Request
    BS->>RC: Check Cache
    alt Cache Hit
        RC-->>BS: Cached Response
    else Cache Miss
        BS->>RM: Match Route Module
        RM->>AR: Render (RSC/SSR)
        AR-->>RM: Streaming HTML + RSC Payload
        RM-->>BS: Render Result
        BS->>IC: Store in Cache
    end
    BS-->>C: HTTP Response (Streaming)
```

## ビルドシステム構成図

```mermaid
graph LR
    subgraph "Build Entry"
        BUILD["next build<br/>(build/index.ts)"]
    end

    subgraph "Configuration"
        CONFIG["next.config.js"]
        TSCONFIG["tsconfig.json"]
    end

    subgraph "Bundler Selection"
        BUNDLER{"Bundler"}
        WP["Webpack"]
        TPK["Turbopack"]
        RSP["Rspack"]
    end

    subgraph "Compilation"
        SWC["SWC<br/>(TypeScript/JSX)"]
        CSS["CSS Processing<br/>(PostCSS/Lightning CSS)"]
        IMG["Image Optimization"]
    end

    subgraph "Analysis & Optimization"
        STATIC["Static Analysis"]
        TREE["Tree Shaking"]
        SPLIT["Code Splitting"]
        SSG["Static Generation"]
    end

    subgraph "Output (.next/)"
        MANIFEST["Manifests<br/>(build-manifest, routes-manifest, etc.)"]
        SERVER_OUT["Server Bundles<br/>(.next/server/)"]
        CLIENT_OUT["Client Bundles<br/>(.next/static/)"]
        CACHE_OUT["Cache<br/>(.next/cache/)"]
    end

    CONFIG --> BUILD
    TSCONFIG --> BUILD
    BUILD --> BUNDLER
    BUNDLER --> WP
    BUNDLER --> TPK
    BUNDLER --> RSP

    WP --> SWC
    TPK --> SWC
    RSP --> SWC
    WP --> CSS
    TPK --> CSS

    SWC --> STATIC
    STATIC --> TREE
    TREE --> SPLIT
    SPLIT --> SSG

    SSG --> MANIFEST
    SSG --> SERVER_OUT
    SSG --> CLIENT_OUT
    SSG --> CACHE_OUT
    IMG --> CLIENT_OUT
```

## キャッシュシステム構成図

```mermaid
graph TB
    subgraph "Client-Side Cache"
        SC["Segment Cache<br/>(client/components/segment-cache/)"]
        ROUTER_CACHE["Router Cache<br/>(router-reducer/)"]
    end

    subgraph "Server-Side Cache"
        RC["Response Cache<br/>(response-cache/)"]
        IC["Incremental Cache<br/>(lib/incremental-cache/)"]
        LRU["LRU Cache<br/>(lib/lru-cache.ts)"]
    end

    subgraph "Cache Backends"
        FSC["File System Cache<br/>(file-system-cache.ts)"]
        MEM["Memory Cache<br/>(memory-cache.external.ts)"]
        CUSTOM["Custom Cache Handler<br/>(cache-handlers/)"]
    end

    subgraph "Cache Directives"
        USE_CACHE["'use cache'<br/>(use-cache/)"]
        CACHE_LIFE["cacheLife<br/>(cache-life.ts)"]
        CACHE_TAG["cacheTag<br/>(cache-tag.ts)"]
    end

    SC --> RC
    ROUTER_CACHE --> RC
    RC --> IC
    IC --> FSC
    IC --> MEM
    IC --> CUSTOM
    IC --> LRU

    USE_CACHE --> IC
    CACHE_LIFE --> USE_CACHE
    CACHE_TAG --> USE_CACHE
```

## モノレポパッケージ依存関係図

```mermaid
graph TB
    subgraph "Published Packages"
        NEXT["packages/next<br/>(next)"]
        CNA["packages/create-next-app"]
        FONT["packages/font<br/>(next/font)"]
        TP_PKG["packages/third-parties<br/>(@next/third-parties)"]
        ESL["packages/eslint-plugin-next"]
        MDX["packages/next-mdx<br/>(@next/mdx)"]
        BA["packages/next-bundle-analyzer"]
        ENV["packages/next-env<br/>(@next/env)"]
    end

    subgraph "Rust Crates"
        SWC_PKG["packages/next-swc<br/>(@next/swc)"]
        NAPI_C["crates/next-napi-bindings"]
        CORE_C["crates/next-core"]
        TRANSFORMS["crates/next-custom-transforms"]
        API_C["crates/next-api"]
        BUILD_C["crates/next-build"]
    end

    subgraph "Turbopack (git subtree)"
        TURBO_CORE["turbopack-core"]
        TURBO_ECMA["turbopack-ecmascript"]
        TURBO_TASKS["turbo-tasks"]
    end

    NEXT --> ENV
    NEXT --> SWC_PKG
    CNA --> NEXT
    FONT --> NEXT
    TP_PKG --> NEXT
    ESL --> NEXT
    MDX --> NEXT

    SWC_PKG --> NAPI_C
    NAPI_C --> CORE_C
    NAPI_C --> API_C
    NAPI_C --> BUILD_C
    CORE_C --> TRANSFORMS
    CORE_C --> TURBO_CORE
    CORE_C --> TURBO_ECMA
    TURBO_CORE --> TURBO_TASKS
    TURBO_ECMA --> TURBO_TASKS
    API_C --> CORE_C
    BUILD_C --> CORE_C
```
