---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 35
  claims_with_evidence: 30
  claims_without_evidence: 5
confidence_derived: 0.86
---

# 根拠レポート：インフラ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.86**
  - 根拠あり：30 / 35、根拠なし：5
- 優先レビュー（高）
  1. **セルフホストランナーの詳細スペック・台数**：具体的なハードウェア仕様がコードベースからは不明
  2. **Vercel KV のデータ保持期間**：KV ストアの設定ファイルがリポジトリ内に存在しない
  3. **Slack 連携の詳細**：`@slack/web-api` パッケージの依存は確認できるが、具体的な通知設定はコードベースから読み取れない
  4. **Turbo Remote Cache の詳細構成**：キャッシュサーバーの構成はVercel側で管理されており、リポジトリからは接続設定のみ確認可能
  5. **Vercel プラットフォームの詳細なスケーリング設定**：Vercel 側のマネージド機能であり、リポジトリからは確認不可

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `package.json`（ルート）- パッケージマネージャ、依存関係、エンジン要件、スクリプト定義
- E-02: `turbo.json`（ルート）- Turborepo タスク設定
- E-03: `.github/workflows/build_and_test.yml` - CI テストワークフロー定義
- E-04: `.github/workflows/build_and_deploy.yml` - ビルド・デプロイワークフロー定義
- E-05: `.github/workflows/build_reusable.yml` - 再利用可能ワークフロー定義
- E-06: `.github/workflows/deploy_docs.yml` - ドキュメントデプロイワークフロー
- E-07: `examples/with-docker/Dockerfile` - Docker サンプル（Node.js）
- E-08: `examples/with-docker/Dockerfile.bun` - Docker サンプル（Bun）
- E-09: `examples/with-docker-multi-env/docker/production/Dockerfile` - マルチ環境 Docker（本番）
- E-10: `examples/with-docker-multi-env/docker/staging/Dockerfile` - マルチ環境 Docker（ステージング）
- E-11: `examples/with-docker-multi-env/docker/development/Dockerfile` - マルチ環境 Docker（開発）
- E-12: `examples/with-docker-compose/compose.prod.yaml` - Docker Compose 本番構成
- E-13: `examples/with-docker-compose/compose.dev.yaml` - Docker Compose 開発構成
- E-14: `examples/with-docker-compose/next-app/prod.Dockerfile` - Docker Compose 本番 Dockerfile
- E-15: `.github/actions/next-stats-action/Dockerfile` - PR Stats Action Dockerfile
- E-16: `vercel.json` - Vercel デプロイ設定
- E-17: `.github/workflows/retry_test.yml` - テストリトライワークフロー（存在確認）
- E-18: `.github/workflows/retry_deploy_test.yml` - デプロイテストリトライワークフロー（存在確認）
- E-19: `.github/workflows/graphite_ci_optimizer.yml` - CI 最適化ワークフロー（存在確認）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | pnpm 9.6.0 によるモノレポ管理 | E-01 (`packageManager: "pnpm@9.6.0"`, `engines.pnpm: "9.6.0"`) | ○ |
| C-02 | Turborepo 2.5.5 によるビルドオーケストレーション | E-01 (`turbo: "2.5.5"`), E-02 | ○ |
| C-03 | GitHub Actions による CI/CD | E-03, E-04, E-05, E-06 | ○ |
| C-04 | Vercel プラットフォームへのデプロイ | E-04, E-06, E-16 | ○ |
| C-05 | npm レジストリへのパッケージ公開 | E-04 (`publishRelease` ジョブ, `NPM_TOKEN`) | ○ |
| C-06 | Node.js >=20.9.0 要件 | E-01 (`engines.node: ">=20.9.0"`) | ○ |
| C-07 | テストの Node.js 20/22 マトリクス | E-03 (test-unit マトリクス `node: [20, 22]`) | ○ |
| C-08 | ubuntu-latest でのジョブ実行 | E-03, E-04 (`runs-on: ubuntu-latest`) | ○ |
| C-09 | セルフホスト Linux x64 metal ランナー | E-04 (`host: ['self-hosted', 'linux', 'x64', 'metal']`) | ○ |
| C-10 | セルフホスト macOS arm64 ランナー | E-04 (`host: ['self-hosted', 'macos', 'arm64']`) | ○ |
| C-11 | セルフホスト Windows x64 ランナー | E-03 (`runs_on_labels: '["windows","self-hosted","x64"]'`) | ○ |
| C-12 | セルフホストランナーの詳細スペック・台数 | **根拠なし** | △ |
| C-13 | Turbo Remote Cache 接続（TURBO_TEAM=vercel, TURBO_CACHE=remote:rw） | E-04 (`env.TURBO_TEAM: 'vercel'`, `env.TURBO_CACHE: 'remote:rw'`) | ○ |
| C-14 | Docker ネットワーク（my_network, 外部） | E-12, E-13 (`networks: my_network: external: true`) | ○ |
| C-15 | ポート 3000 の公開 | E-07 (`EXPOSE 3000`, `ENV PORT=3000`), E-12 (`ports: - 3000:3000`) | ○ |
| C-16 | napi-rs CLI 2.18.4 | E-04 (`env.NAPI_CLI_VERSION: 2.18.4`) | ○ |
| C-17 | corepack 0.31 | E-04 (`npm i -g corepack@0.31`) | ○ |
| C-18 | Docker マルチステージビルド構成 | E-07 (base, deps, builder, runner ステージ) | ○ |
| C-19 | 非 root ユーザー（nextjs:nodejs, UID 1001/GID 1001） | E-07 (`addgroup --gid 1001 nodejs`, `adduser --uid 1001 nextjs`, `USER nextjs`) | ○ |
| C-20 | standalone output の使用 | E-07 (`COPY .next/standalone`), E-14 | ○ |
| C-21 | Datadog メトリクス送信 | E-04 (`upload_turbopack_bytesize` ジョブ, `@datadog/datadog-ci@2.23.1`, `DATA_DOG_API_KEY`) | ○ |
| C-22 | Vercel KV によるテストタイミング保存 | E-02 (`env: ["KV_REST_API_URL", "KV_REST_API_TOKEN"]`) | ○ |
| C-23 | Vercel KV のデータ保持期間 | **根拠なし** | △ |
| C-24 | 8 ネイティブビルドターゲット | E-04 (build-native マトリクスに 8 ターゲット定義) | ○ |
| C-25 | WASM ビルド（web/nodejs） | E-04 (build-wasm ジョブ, `matrix.target: [web, nodejs]`) | ○ |
| C-26 | テストマトリクス分割（dev 7分割、prod 7分割、integration 13分割等） | E-03 (各テストジョブの `matrix.group`) | ○ |
| C-27 | cancel-in-progress: true 設定 | E-03 (`concurrency: cancel-in-progress: true`) | ○ |
| C-28 | fail-fast: false 設定 | E-03 (各テストマトリクスの `fail-fast: false`) | ○ |
| C-29 | Docker Compose 開発環境のボリュームマウント | E-13 (`volumes: - ./next-app/src:/app/src - ./next-app/public:/app/public`) | ○ |
| C-30 | restart: always ポリシー | E-12, E-13 (`restart: always`) | ○ |
| C-31 | CARGO_PROFILE_RELEASE_LTO=true 設定 | E-04 (`env.CARGO_PROFILE_RELEASE_LTO: 'true'`) | ○ |
| C-32 | MACOSX_DEPLOYMENT_TARGET=11.0 | E-04 (`env.MACOSX_DEPLOYMENT_TARGET: 11.0`) | ○ |
| C-33 | Slack 連携の詳細 | **根拠なし** (E-01 に `@slack/web-api: "7.9.1"` の依存はあるが、具体的な通知設定は不明) | △ |
| C-34 | Vercel プラットフォームのオートスケーリング | **根拠なし** (Vercel マネージド機能であり、リポジトリから確認不可) | △ |
| C-35 | Graphite CI Optimizer によるジョブ最適化 | E-03 (`optimize-ci: uses: ./.github/workflows/graphite_ci_optimizer.yml`), E-19 | ○ |

## 4) 不足情報（Unknown / Missing）
- **セルフホストランナーの詳細スペック・台数（C-12）**: セルフホストランナーの構成はGitHub Actionsワークフロー内のラベル（`self-hosted`, `linux`, `x64`, `metal`等）で特定されるが、具体的なハードウェアスペック・台数はリポジトリ内に記載がない。
  - 候補：Vercel 社内のインフラドキュメント / GitHub Settings のランナー管理画面 / ops チームへの確認
- **Vercel KV のデータ保持期間（C-23）**: `turbo.json` に KV 接続用の環境変数名は定義されているが、KV ストアの保持期間等の設定はリポジトリ内に存在しない。
  - 候補：Vercel KV ダッシュボード / Vercel プロジェクト設定
- **Slack 連携の詳細（C-33）**: `@slack/web-api` パッケージが devDependencies に含まれるが、リリース通知等の具体的な連携設定・ワークフローはリポジトリ内で確認できなかった。
  - 候補：`.github/workflows/trigger_release.yml` / `scripts/` 配下のリリーススクリプト
- **Vercel オートスケーリング設定（C-34）**: Vercel はマネージドプラットフォームであり、スケーリング設定はプラットフォーム側で管理される。
  - 候補：Vercel ダッシュボード / Vercel プロジェクト設定
- **Turbo Remote Cache のサーバー構成（C-13の詳細）**: 接続設定（`TURBO_TEAM`, `TURBO_CACHE`）は確認できるが、キャッシュサーバー自体の構成は Vercel 側の管理領域。
  - 候補：Vercel Turborepo ドキュメント / Vercel チーム設定

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: CI/CD ワークフロー構成、Docker サンプル構成 -- コードベースから直接確認可能な情報で構成されている
- **1（中リスク）**: 外部サービス連携の詳細（Datadog、Vercel KV、Slack） -- 環境変数名や依存パッケージは確認できるが、具体的な設定値や連携内容は推定を含む
- **2（高リスク）**: セルフホストランナーのスペック・台数、Vercel プラットフォームのスケーリング設定 -- リポジトリ内の情報だけでは確認不可能であり、別途確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] セルフホストランナーの実際のスペック・台数を確認し、C-12 の記述を補完する
- [ ] Vercel KV のデータ保持期間をダッシュボードで確認し、C-23 を補完する
- [ ] Slack 連携の有無・詳細を `trigger_release.yml` 等で確認し、C-33 の記述を修正する
- [ ] Vercel プラットフォームのスケーリング設定をプロジェクト設定で確認し、C-34 を補完する
- [ ] Docker サンプル構成が最新の公式推奨構成と一致しているかを確認する
- [ ] ネイティブバイナリのビルドターゲット一覧が `build_and_deploy.yml` のマトリクス定義と一致しているかを確認する
