# インフラ構成図

## 全体構成図

```mermaid
graph TB
    subgraph "開発者環境"
        DEV[開発者]
    end

    subgraph "GitHub"
        REPO[GitHub Repository<br/>vercel/next.js]
        subgraph "GitHub Actions CI/CD"
            direction TB
            BA_TEST["build-and-test<br/>ワークフロー"]
            BA_DEPLOY["build-and-deploy<br/>ワークフロー"]
            DOCS_DEPLOY["deploy_docs<br/>ワークフロー"]
        end
    end

    subgraph "CI ランナー"
        subgraph "GitHub ホスト型"
            UBUNTU["ubuntu-latest<br/>ビルド・テスト・リント"]
        end
        subgraph "セルフホスト型"
            LINUX_METAL["Linux x64 metal<br/>ネイティブビルド (GNU/musl)<br/>WASM ビルド"]
            MACOS_ARM["macOS arm64<br/>ネイティブビルド<br/>(x86_64/aarch64-apple-darwin)"]
            WINDOWS_X64["Windows x64<br/>ネイティブビルド<br/>(x86_64/aarch64-pc-windows-msvc)"]
        end
    end

    subgraph "外部サービス"
        NPM["npm Registry<br/>パッケージ公開"]
        VERCEL["Vercel Platform<br/>ドキュメント・サンプルアプリ<br/>ホスティング"]
        TURBO_CACHE["Turbo Remote Cache<br/>ビルドキャッシュ共有"]
        DATADOG["Datadog<br/>メトリクス監視"]
        VERCEL_KV["Vercel KV<br/>テストタイミングデータ"]
        DOCKER_REG["Docker Registry<br/>(Docker Hub / GHCR)<br/>ベースイメージ"]
    end

    DEV -->|push / PR| REPO
    REPO --> BA_TEST
    REPO --> BA_DEPLOY
    REPO --> DOCS_DEPLOY

    BA_TEST --> UBUNTU
    BA_TEST --> LINUX_METAL
    BA_TEST --> MACOS_ARM
    BA_TEST --> WINDOWS_X64

    BA_DEPLOY --> UBUNTU
    BA_DEPLOY --> LINUX_METAL
    BA_DEPLOY --> MACOS_ARM
    BA_DEPLOY --> WINDOWS_X64
    BA_DEPLOY -->|リリース公開| NPM
    BA_DEPLOY -->|デプロイ| VERCEL

    DOCS_DEPLOY -->|ドキュメントデプロイ| VERCEL

    UBUNTU -->|キャッシュ読み書き| TURBO_CACHE
    LINUX_METAL -->|キャッシュ読み書き| TURBO_CACHE
    MACOS_ARM -->|キャッシュ読み書き| TURBO_CACHE

    BA_DEPLOY -->|メトリクス送信| DATADOG
    BA_TEST -->|タイミングデータ| VERCEL_KV

    LINUX_METAL -->|ベースイメージ取得| DOCKER_REG
```

## CI/CD パイプライン構成図

```mermaid
graph LR
    subgraph "build-and-test ワークフロー"
        direction TB
        CHANGES["changes<br/>変更検出"]
        OPT_CI["optimize-ci<br/>Graphite CI Optimizer"]

        subgraph "ビルドフェーズ"
            BUILD_NEXT["build-next<br/>Next.js ビルド"]
            BUILD_NATIVE["build-native<br/>SWC ネイティブビルド"]
            BUILD_NATIVE_WIN["build-native-windows<br/>Windows ネイティブビルド"]
        end

        subgraph "品質チェックフェーズ"
            LINT["lint<br/>ESLint / Prettier"]
            TYPES["types-and-precompiled<br/>TypeScript 型チェック"]
            RUST_CHECK["rust-check<br/>Cargo チェック"]
            AST_GREP["ast-grep lint"]
            DOCS_LINKS["validate-docs-links"]
        end

        subgraph "テストフェーズ"
            TEST_UNIT["test-unit<br/>Node 20/22"]
            TEST_DEV["test-dev<br/>Webpack 10分割"]
            TEST_PROD["test-prod<br/>Webpack 10分割"]
            TEST_INT["test-integration<br/>13分割"]
            TEST_TP_DEV["test-turbopack-dev<br/>7分割"]
            TEST_TP_PROD["test-turbopack-production<br/>7分割"]
            TEST_CARGO["test-cargo-unit"]
            TEST_WASM["test-next-swc-wasm"]
            TEST_NEW["test-new-tests<br/>フレーク検出"]
            TEST_WIN["test-*-windows"]
            TEST_BROWSER["test-firefox-safari"]
        end

        GATE["tests-pass<br/>(thank you, next)"]

        CHANGES --> BUILD_NEXT
        CHANGES --> BUILD_NATIVE
        CHANGES --> BUILD_NATIVE_WIN

        BUILD_NEXT --> LINT
        BUILD_NEXT --> TYPES
        BUILD_NEXT --> RUST_CHECK
        BUILD_NEXT --> AST_GREP

        BUILD_NEXT --> TEST_UNIT
        BUILD_NEXT --> TEST_DEV
        BUILD_NEXT --> TEST_PROD
        BUILD_NEXT --> TEST_INT
        BUILD_NEXT --> TEST_TP_DEV
        BUILD_NEXT --> TEST_TP_PROD
        BUILD_NEXT --> TEST_CARGO
        BUILD_NEXT --> TEST_WASM
        BUILD_NEXT --> TEST_NEW
        BUILD_NEXT --> TEST_WIN
        BUILD_NEXT --> TEST_BROWSER

        TEST_UNIT --> GATE
        TEST_DEV --> GATE
        TEST_PROD --> GATE
        TEST_INT --> GATE
        TEST_TP_DEV --> GATE
        TEST_TP_PROD --> GATE
        TEST_CARGO --> GATE
        TEST_WASM --> GATE
        LINT --> GATE
        TYPES --> GATE
        RUST_CHECK --> GATE
        TEST_NEW --> GATE
        TEST_WIN --> GATE
        TEST_BROWSER --> GATE
    end
```

## Docker コンテナ構成図（サンプル: with-docker）

```mermaid
graph TB
    subgraph "Docker マルチステージビルド"
        BASE["base<br/>node:20-alpine"]

        subgraph "ステージ 1: deps"
            DEPS["依存関係インストール<br/>yarn / npm / pnpm<br/>(frozen lockfile)"]
        end

        subgraph "ステージ 2: builder"
            BUILDER["ソースコードビルド<br/>next build<br/>(standalone output)"]
        end

        subgraph "ステージ 3: runner"
            RUNNER["本番実行環境<br/>USER: nextjs (UID 1001)<br/>GROUP: nodejs (GID 1001)"]
            PUBLIC["public/"]
            STANDALONE[".next/standalone/"]
            STATIC[".next/static/"]
            SERVER["node server.js<br/>HOSTNAME=0.0.0.0<br/>PORT=3000"]
        end

        BASE --> DEPS
        DEPS --> BUILDER
        BASE --> RUNNER
        BUILDER -->|COPY standalone| RUNNER
        RUNNER --> PUBLIC
        RUNNER --> STANDALONE
        RUNNER --> STATIC
        RUNNER --> SERVER
    end

    CLIENT["クライアント"] -->|:3000| SERVER
```

## Docker Compose 構成図（サンプル: with-docker-compose）

```mermaid
graph TB
    subgraph "Docker Compose (Production)"
        subgraph "my_network (external)"
            NEXT_APP["next-app コンテナ<br/>prod.Dockerfile<br/>standalone ビルド<br/>restart: always"]
        end
    end

    subgraph "Docker Compose (Development)"
        subgraph "my_network_dev (external)"
            NEXT_APP_DEV["next-app コンテナ<br/>dev.Dockerfile<br/>ボリュームマウント<br/>- src/ -> /app/src<br/>- public/ -> /app/public"]
        end
    end

    CLIENT_PROD["クライアント"] -->|":3000"| NEXT_APP
    CLIENT_DEV["開発者ブラウザ"] -->|":3000"| NEXT_APP_DEV
    ENV[".env ファイル"] -.->|環境変数| NEXT_APP
    ENV -.->|環境変数| NEXT_APP_DEV
```

## ネイティブバイナリビルドマトリクス

```mermaid
graph TB
    subgraph "ネイティブバイナリ ビルドターゲット"
        SRC["packages/next-swc<br/>Rust ソースコード"]

        subgraph "macOS (self-hosted arm64)"
            MAC_X86["x86_64-apple-darwin"]
            MAC_ARM["aarch64-apple-darwin"]
        end

        subgraph "Windows (self-hosted x64)"
            WIN_X86["x86_64-pc-windows-msvc"]
            WIN_ARM["aarch64-pc-windows-msvc"]
        end

        subgraph "Linux (self-hosted x64 metal + Docker)"
            LINUX_GNU_X86["x86_64-unknown-linux-gnu<br/>Docker: napi-rs nodejs-rust x64"]
            LINUX_MUSL_X86["x86_64-unknown-linux-musl<br/>Docker: napi-rs nodejs-rust alpine"]
            LINUX_GNU_ARM["aarch64-unknown-linux-gnu<br/>Docker: napi-rs nodejs-rust aarch64"]
            LINUX_MUSL_ARM["aarch64-unknown-linux-musl<br/>Docker: napi-rs nodejs-rust alpine"]
        end

        subgraph "WASM (self-hosted linux x64 metal)"
            WASM_WEB["wasm32-unknown-unknown<br/>(web target)"]
            WASM_NODE["wasm32-unknown-unknown<br/>(nodejs target)"]
        end

        SRC --> MAC_X86
        SRC --> MAC_ARM
        SRC --> WIN_X86
        SRC --> WIN_ARM
        SRC --> LINUX_GNU_X86
        SRC --> LINUX_MUSL_X86
        SRC --> LINUX_GNU_ARM
        SRC --> LINUX_MUSL_ARM
        SRC --> WASM_WEB
        SRC --> WASM_NODE
    end

    subgraph "成果物"
        ARTIFACT["next-swc.*.node<br/>GitHub Actions Artifacts"]
        NPM_PKG["npm パッケージ<br/>@next/swc-*"]
    end

    MAC_X86 --> ARTIFACT
    MAC_ARM --> ARTIFACT
    WIN_X86 --> ARTIFACT
    WIN_ARM --> ARTIFACT
    LINUX_GNU_X86 --> ARTIFACT
    LINUX_MUSL_X86 --> ARTIFACT
    LINUX_GNU_ARM --> ARTIFACT
    LINUX_MUSL_ARM --> ARTIFACT
    WASM_WEB --> ARTIFACT
    WASM_NODE --> ARTIFACT
    ARTIFACT -->|リリース時| NPM_PKG
```
