# インフラ設計書

## 概要

本ドキュメントは、Next.js フレームワーク（canary ブランチ）のインフラストラクチャ構成を記載する。Next.js はVercel社が開発するオープンソースのReactフレームワークであり、本リポジトリはそのモノレポ構成のソースコードである。開発基盤としてGitHub Actions によるCI/CDパイプライン、Docker によるコンテナ化、Vercel プラットフォームへのデプロイ、Turborepo によるビルドオーケストレーションを採用している。

## システム構成

### 全体構成

本プロジェクトは pnpm ワークスペースによるモノレポ構成を採用しており、以下の主要コンポーネントで構成される。

- **パッケージ管理**: pnpm 9.6.0（ワークスペース機能によるモノレポ管理）
- **ビルドオーケストレーション**: Turborepo 2.5.5（タスク依存関係管理、リモートキャッシュ）
- **CI/CD**: GitHub Actions（ビルド、テスト、デプロイの自動化）
- **デプロイ先**: Vercel プラットフォーム（ドキュメント、サンプルアプリケーション）
- **パッケージ配布**: npm レジストリ（本番リリース）
- **ネイティブバイナリビルド**: Rust / napi-rs（SWCトランスパイラ、マルチプラットフォーム対応）

### サーバー構成

| サーバー種別 | 役割 | スペック | 台数 |
| --- | --- | --- | --- |
| GitHub Actions Runner (ubuntu-latest) | CI/CDジョブ実行（ビルド、テスト、リント、デプロイ） | GitHub ホスト型ランナー | 並列実行（マトリクス戦略により最大数十ジョブ） |
| Self-hosted Runner (Linux x64 metal) | ネイティブバイナリビルド（GNU/musl）、WASM ビルド、ベンチマーク | セルフホスト Linux x64 メタルサーバー | 複数台 |
| Self-hosted Runner (macOS arm64) | macOS 向けネイティブバイナリビルド（x86_64/aarch64） | セルフホスト macOS ARM64 | 複数台 |
| Self-hosted Runner (Windows x64) | Windows 向けネイティブバイナリビルド、Windows テスト実行 | セルフホスト Windows x64 | 複数台 |
| Vercel Edge/Serverless | ドキュメントサイトおよびサンプルアプリのホスティング | Vercel マネージド | オートスケーリング |
| npm Registry | パッケージ公開先 | npmjs.org | - |

### ネットワーク構成

本プロジェクトはOSS開発プロジェクトであり、以下のネットワーク構成を使用する。

- **GitHub Actions**: GitHub が管理するネットワーク上で CI/CD ジョブを実行。セルフホストランナーは Vercel 社内ネットワークに接続。
- **Vercel プラットフォーム**: CDN（エッジネットワーク）を通じたドキュメント・サンプルアプリの配信。
- **npm レジストリ**: パッケージ公開時に `registry.npmjs.org` へ HTTPS 接続。
- **Turbo リモートキャッシュ**: Turborepo のリモートキャッシュサーバー（Vercel 提供）へ HTTPS 接続。`TURBO_TEAM=vercel`、`TURBO_CACHE=remote:rw` として設定。
- **Docker コンテナネットワーク**: サンプルアプリ（with-docker-compose）では `my_network` という外部 Docker ネットワークを使用し、コンテナ間通信を実現。ポート 3000 を外部に公開。

## ミドルウェア

| ミドルウェア | バージョン | 用途 |
| --- | --- | --- |
| Node.js | >=20.9.0 (LTS: 20, 22) | JavaScript ランタイム。CI では Node.js 20 および 22 でテスト実行 |
| pnpm | 9.6.0 | パッケージマネージャ（モノレポワークスペース管理） |
| Turborepo | 2.5.5 | モノレポビルドオーケストレーション、リモートキャッシュ |
| Rust (stable) | stable チャネル | SWC ネイティブバイナリおよび Turbopack のビルド |
| napi-rs CLI | 2.18.4 | Node.js ネイティブアドオンのビルドツール |
| Docker | - | コンテナ化（サンプルアプリの Docker デプロイ、CI の Docker ビルド） |
| corepack | 0.31 | Node.js パッケージマネージャバージョン管理 |
| wasm-pack | - | Rust から WebAssembly へのビルドツール |
| Jest | 29.7.0 | テストフレームワーク |
| Playwright | 1.48.0 | E2E ブラウザテスト（Chromium, Firefox, WebKit） |
| Webpack | 5.98.0 | モジュールバンドラー（レガシーモード） |
| Turbopack | (組み込み) | 次世代バンドラー（Rust 実装、開発・本番ビルド対応） |

## 外部サービス連携

| サービス名 | 用途 | 接続方式 |
| --- | --- | --- |
| GitHub | ソースコード管理、CI/CD（GitHub Actions）、PR 管理 | HTTPS / GitHub API |
| Vercel | ドキュメント・サンプルアプリのデプロイ・ホスティング | Vercel CLI / HTTPS API（`VERCEL_API_TOKEN`） |
| npm Registry | パッケージ公開 | HTTPS（`NPM_TOKEN`） |
| Turbo Remote Cache | ビルドキャッシュ共有 | HTTPS（`TURBO_TOKEN`, `TURBO_TEAM`, `TURBO_API`） |
| Datadog | Turbopack バイナリサイズメトリクス、CI パイプラインモニタリング | Datadog CI CLI（`DATA_DOG_API_KEY`） |
| Vercel KV | テストタイミングデータの保存 | HTTPS（`KV_REST_API_URL`, `KV_REST_API_TOKEN`） |
| Slack | リリース通知等 | Slack Web API（`@slack/web-api`） |
| Docker Hub / GHCR | Docker ベースイメージ取得（`node:20-alpine`, `oven/bun:1`, `ghcr.io/napi-rs/napi-rs/*`） | HTTPS |

## スケーリング設計

### CI/CD スケーリング

- **GitHub Actions マトリクス戦略**: テストジョブはマトリクス分割により並列実行される。
  - 開発テスト（Turbopack）: 7 分割並列
  - 本番テスト（Turbopack）: 7 分割並列
  - インテグレーションテスト: 最大 13 分割並列
  - React バージョンマトリクス: デフォルト + 18.3.1 の 2 バージョン
- **Concurrency 制御**: PR ごとに 1 つの同時実行に制限し、同一 PR の古いジョブは自動キャンセル（`cancel-in-progress: true`）。
- **Graphite CI Optimizer**: CI ジョブの最適化（不要なジョブスキップ）を実施。
- **条件付き実行**: ドキュメントのみの変更時はテストジョブをスキップ。

### Docker コンテナスケーリング

- Docker Compose サンプルでは単一コンテナ構成（`restart: always` による自動再起動）。
- 本番環境での水平スケーリングは、デプロイ先プラットフォーム（Vercel、Kubernetes 等）に依存する設計。

### Vercel デプロイ

- Vercel プラットフォームのオートスケーリング機能により、トラフィックに応じた自動スケーリングが実現される。

## 可用性設計

### CI/CD の可用性

- **ジョブリトライ**: `retry_test.yml` および `retry_deploy_test.yml` ワークフローにより、失敗したテストジョブの自動リトライが可能。
- **キャッシュ戦略**: pnpm store キャッシュ、Turbo リモートキャッシュ、Rust ビルドキャッシュを活用し、ビルド時間短縮と安定性を確保。
- **フェイルファスト無効化**: テストマトリクスは `fail-fast: false` に設定し、一部のテスト失敗が他のテストジョブに影響しないようにしている。
- **自動ジョブキャンセル**: Vercel の `autoJobCancelation` 設定により、不要なデプロイジョブを自動キャンセル。

### Docker コンテナの可用性

- `restart: always` ポリシーにより、コンテナ異常終了時の自動再起動を実現。
- 非 root ユーザー（`nextjs:nodejs`、UID 1001 / GID 1001）でのコンテナ実行によるセキュリティ確保。
- マルチステージビルドによる最小限のプロダクションイメージ（standalone output）。

### ネイティブバイナリの可用性

- マルチプラットフォーム対応（8 ターゲット）:
  - `x86_64-apple-darwin`
  - `aarch64-apple-darwin`
  - `x86_64-pc-windows-msvc`
  - `aarch64-pc-windows-msvc`
  - `x86_64-unknown-linux-gnu`
  - `x86_64-unknown-linux-musl`
  - `aarch64-unknown-linux-gnu`
  - `aarch64-unknown-linux-musl`
- WASM フォールバック: ネイティブバイナリが利用できない環境向けに WASM ビルド（web / nodejs ターゲット）を提供。

## バックアップ設計

| 対象 | 方式 | 頻度 | 保持期間 |
| --- | --- | --- | --- |
| ソースコード | Git リポジトリ（GitHub） | コミットごと | 無期限（Git 履歴） |
| ビルドアーティファクト | GitHub Actions Artifacts | ワークフロー実行ごと | GitHub デフォルト保持期間（90日） |
| ビルドキャッシュ | Turbo Remote Cache / GitHub Actions Cache | ビルドごと | キャッシュポリシーに準拠 |
| npm パッケージ | npm Registry | リリースごと | 無期限（npm の公開ポリシーに準拠） |
| テストタイミングデータ | Vercel KV | テスト実行ごと | 不明（KV ストアの設定に依存） |

## 監視設計

### メトリクス監視

- **Datadog**: Turbopack バイナリサイズメトリクス（`turbopack.bytesize.*`）を CI パイプラインレベルで Datadog に送信。`@datadog/datadog-ci` CLI を使用。
- **GitHub Actions**: ワークフロー実行状況、ジョブ成否のモニタリング。`tests-pass`（"thank you, next"）および `buildPassed`（"thank you, build"）ジョブによる全体ステータスの集約。

### CI/CD 監視

- **PR Stats Action**: `.github/actions/next-stats-action` により、PR ごとのパフォーマンス統計を自動取得・比較。
- **Turbo Run Summary**: ビルド実行ごとに `.turbo/runs` にサマリーを出力し、アーティファクトとしてアップロード。
- **Devlow Bench**: 開発サーバーのパフォーマンスベンチマークを定期実行し、Datadog に結果を送信。

### ビルド品質監視

- **テスト**: ユニットテスト、E2E テスト、インテグレーションテスト、本番テストを Node.js 20/22 および複数バンドラー（Webpack / Turbopack / Rspack）で実行。
- **リント**: ESLint、Prettier、TypeScript 型チェック、ast-grep によるコード品質チェック。
- **Rust チェック**: `cargo fmt`、`cargo check`、rustdoc チェックによる Rust コードの品質監視。
- **新規テストのフレーク検出**: `test-new-tests-dev` / `test-new-tests-start` ジョブにより、新規・変更テストのフレーク（不安定テスト）を検出。

## 備考

### Docker サンプル構成

本リポジトリには Next.js アプリケーションの Docker 化に関する複数のサンプルが含まれる。

- **examples/with-docker**: 標準的な Docker 化サンプル。Node.js 20 Alpine ベースのマルチステージビルド。`output: 'standalone'` 設定による最適化されたプロダクションイメージ。Bun ランタイム向けの Dockerfile.bun も提供。
- **examples/with-docker-multi-env**: 開発・ステージング・本番の3環境対応 Docker 構成。環境ごとに異なる `.env` ファイルをコピーして環境変数を切り替え。
- **examples/with-docker-compose**: Docker Compose による構成。開発用（`compose.dev.yaml`：ホットリロード対応のボリュームマウント）と本番用（`compose.prod.yaml`：standalone ビルド）の2構成。

### ビルドターゲット環境

- **Node.js**: メンテナンスバージョン 20、LTS バージョン 22 の2バージョンをサポート。テストは両バージョンで実行。
- **Rust**: stable チャンネル。LTO（Link Time Optimization）を有効化（`CARGO_PROFILE_RELEASE_LTO=true`）。
- **macOS**: 最小デプロイターゲット macOS 11.0（`MACOSX_DEPLOYMENT_TARGET=11.0`）。

### セキュリティ

- CI/CD シークレットは GitHub Secrets で管理（`NPM_TOKEN`、`VERCEL_API_TOKEN`、`DATA_DOG_API_KEY`、`TURBO_TOKEN` 等）。
- Docker コンテナは非 root ユーザー（UID/GID 1001）で実行。
- npm パッケージ公開時は Provenance（出所証明）を有効化。
- Vercel の `github.silent` 設定により、不要な GitHub コメントを抑制。
