---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 28
  claims_with_evidence: 24
  claims_without_evidence: 4
confidence_derived: 0.86
---

# 根拠レポート：セキュリティ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.86**
  - 根拠あり：24 / 28、根拠なし：4
- 優先レビュー（高）
  1. **C-04 セッション固定化対策の不在**：フレームワーク内に該当コードが見当たらないことの確認が必要
  2. **C-15 HSTS自動設定機構の不在**：Middleware/headers設定による対応可能性の補足確認が必要
  3. **C-27 experimental.authInterruptsの詳細**：実験的機能の具体的挙動についてコード解析が不十分
  4. **C-28 server-onlyパッケージによるクライアントバンドル防止**：ビルドプロセス全体の検証が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `packages/next/src/server/api-utils/node/api-resolver.ts` -- Draft Mode Cookie設定（httpOnly, sameSite, secure）
- E-02: `packages/next/src/server/async-storage/draft-mode-provider.ts` -- Draft Mode Cookie設定
- E-03: `packages/next/src/server/api-utils/index.ts` -- Cookie属性設定（clearPreviewData）
- E-04: `packages/next/src/server/app-render/action-handler.ts` -- Server Actions CSRF検証、Cache-Controlヘッダー設定
- E-05: `packages/next/src/server/app-render/csrf-protection.test.ts` -- CSRF Origin検証のテストコード
- E-06: `packages/next/src/server/lib/router-utils/block-cross-site.ts` -- 開発モードクロスサイトリクエストブロック
- E-07: `packages/next/src/server/app-render/encryption-utils.ts` -- AES-GCM暗号化（Server Actions Bound Args）
- E-08: `packages/next/src/server/app-render/encryption-utils-server.ts` -- 暗号鍵の生成・キャッシュ・ローテーション
- E-09: `packages/next/src/server/app-render/encryption.ts` -- Server Actions Bound Argsの暗号化・復号処理
- E-10: `packages/next/src/server/crypto-utils.ts` -- AES-256-GCM + PBKDF2暗号化（Preview Data）
- E-11: `packages/next/src/build/webpack/plugins/subresource-integrity-plugin.ts` -- SRIハッシュ生成
- E-12: `packages/next/src/server/htmlescape.ts` -- HTMLエスケープ処理
- E-13: `packages/next/src/client/lib/javascript-url.ts` -- JavaScript URLサニタイズ
- E-14: `packages/next/src/server/app-render/get-script-nonce-from-header.tsx` -- CSP nonce抽出
- E-15: `packages/next/src/client/trusted-types.ts` -- Trusted Types対応
- E-16: `packages/next/src/server/image-optimizer.ts` -- 画像最適化SSRF防御、remotePatterns検証
- E-17: `packages/next/src/server/is-private-ip.ts` -- プライベートIP判定
- E-18: `packages/next/src/server/lib/server-ipc/utils.ts` -- 禁止ヘッダーフィルタリング
- E-19: `packages/next/src/server/send-payload.ts` -- X-Powered-By、ETag、Cache-Control
- E-20: `packages/next/src/server/config-shared.ts` -- 各種設定定義（poweredByHeader, crossOrigin, allowedDevOrigins, serverActions, taint, sri, logging等）
- E-21: `packages/next/src/server/dev/log-requests.ts` -- リクエストログ・フェッチログ機構
- E-22: `packages/next/src/server/web/spec-extension/response.ts` -- NextResponse実装
- E-23: `packages/next/src/shared/lib/image-config.ts` -- 画像設定（remotePatterns, dangerouslyAllowSVG, contentSecurityPolicy）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Draft Mode CookieはhttpOnly: trueで設定される | E-01, E-02, E-03 | ○ |
| C-02 | Draft Mode Cookieの sameSiteは本番: none / 開発: lax | E-01, E-02, E-03 | ○ |
| C-03 | Draft Mode Cookieの secureは本番: true / 開発: false | E-01, E-02 | ○ |
| C-04 | フレームワーク側にセッション固定化対策の専用機構はない | **根拠なし** | △ |
| C-05 | Server Actionsでoriginヘッダーとhost/x-forwarded-hostヘッダーを比較しCSRF防止 | E-04 | ○ |
| C-06 | allowedOriginsでワイルドカードパターンマッチング（*および**）をサポート | E-04, E-05 | ○ |
| C-07 | CSRF検証は大文字小文字を区別しないRFC 1035準拠 | E-05 | ○ |
| C-08 | 開発サーバーでクロスサイトリクエストをブロック（allowedDevOrigins） | E-06 | ○ |
| C-09 | sec-fetch-modeとsec-fetch-siteヘッダーによるno-cors/cross-site検出 | E-06 | ○ |
| C-10 | Server Actions Bound ArgsはAES-256-GCMで暗号化 | E-07, E-09 | ○ |
| C-11 | 暗号化にランダムIV（16バイト）を使用 | E-07, E-09 | ○ |
| C-12 | 暗号鍵は環境変数または自動生成、14日間のキャッシュ | E-08 | ○ |
| C-13 | Preview DataはAES-256-GCM + PBKDF2（100,000イテレーション、SHA-512）で暗号化 | E-10 | ○ |
| C-14 | SRIはSHA-256/384/512でビルド時にハッシュ算出 | E-11, E-20 | ○ |
| C-15 | フレームワーク内にHSTSヘッダーの自動設定機構はない | **根拠なし** | △ |
| C-16 | HTMLエスケープで&, >, <, U+2028, U+2029をUnicodeエスケープに変換 | E-12 | ○ |
| C-17 | JavaScript URLをjavascript:プロトコルの正規表現で検出しブロック | E-13 | ○ |
| C-18 | CSP nonceをContent-Security-Policyヘッダーから抽出しscriptタグに付与 | E-14 | ○ |
| C-19 | Trusted Typesのnextjsポリシーを作成しDOM操作を制御 | E-15 | ○ |
| C-20 | nonce値にHTMLエスケープ文字が含まれる場合はエラーをスロー | E-14 | ○ |
| C-21 | 画像最適化でDNS解決結果を検査しプライベートIPへのアクセスを拒否 | E-16, E-17 | ○ |
| C-22 | remotePatterns/localPatternsによる許可リスト方式のURL制御 | E-16, E-23 | ○ |
| C-23 | Server Actions処理時に禁止ヘッダー（connection, expect, content-length, set-cookie）をフィルタリング | E-18 | ○ |
| C-24 | X-Powered-Byヘッダーがデフォルトで有効（poweredByHeader: true） | E-19, E-20 | ○ |
| C-25 | Server Actions応答時にCache-Control: no-cache, no-store, max-age=0, must-revalidateを設定 | E-04 | ○ |
| C-26 | logging設定でリクエストログ、フェッチログ、Server Functionsログを制御可能 | E-20, E-21 | ○ |
| C-27 | experimental.authInterruptsによる認証割り込み実験的機能 | **根拠なし** | △ |
| C-28 | server-onlyパッケージによるクライアントバンドルへの漏洩防止 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **C-04（セッション固定化対策の不在）**: コードベース全体を網羅的に検索した結果、専用のセッション固定化対策コードは発見されなかったが、存在しないことの完全な証明は困難
  - 候補：セキュリティ関連のテストコード / ドキュメント / Middlewareサンプル
- **C-15（HSTS自動設定の不在）**: コードベースで `Strict-Transport-Security` や `HSTS` のキーワード検索で該当なしだが、`headers` 設定やMiddlewareで対応可能であることの補足が必要
  - 候補：next.config.js headers設定のドキュメント / Middleware実装例
- **C-27（authInterrupts）**: `config-shared.ts` にフラグの定義は確認したが、具体的な実装コードの詳細な解析を行っていない
  - 候補：`packages/next/src/server` 配下の認証割り込み実装コード / テストコード
- **C-28（server-onlyパッケージ）**: `encryption.ts` の先頭で `import 'server-only'` が確認されたが、ビルドプロセスにおける具体的なバンドル除外メカニズムの詳細な検証は未実施
  - 候補：webpack/turbopack設定コード / ビルドプロセスのテスト

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: C-04 -- セッション固定化対策はフレームワークの責務範囲外であり、アプリケーション開発者が実装する領域
- **1（中リスク）**: C-15 -- HSTS未設定はデプロイ環境に依存するが、フレームワーク利用者への案内が不十分な可能性
- **0（低リスク）**: C-27 -- 実験的機能であり、安定版リリースには影響しない
- **1（中リスク）**: C-28 -- server-onlyの動作保証はセキュリティ上重要であるため、ビルドプロセスの検証を推奨

## 6) レビュアーチェックリスト（最小）
- [ ] Draft Mode Cookieの属性（httpOnly, sameSite, secure）がソースコードと一致しているか確認
- [ ] Server Actions CSRF検証のロジック（origin vs host比較）が正確に記述されているか確認
- [ ] AES-256-GCM暗号化のパラメータ（鍵長、IVサイズ、PBKDF2イテレーション数）がソースコードと一致しているか確認
- [ ] 画像最適化のSSRF防御（プライベートIP拒否）のロジックが正確か確認
- [ ] 根拠なし（△）の4項目について、追加調査の要否を判断
- [ ] Next.jsの最新バージョンにおける変更がないか確認（特にexperimental機能）
