---
generated_at: 2026-02-03 12:00:00
metrics:
  claims_total: 30
  claims_with_evidence: 27
  claims_without_evidence: 3
confidence_derived: 0.90
---

# 根拠レポート：テスト方針書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：27 / 30、根拠なし：3
- 優先レビュー（高）
  1. **カバレッジ目標の方針**：明示的な数値目標が設定されていないという主張の裏付けが間接的
  2. **不具合管理の全体フロー**：GitHub Issues による管理は推定であり、明示的なドキュメントが不在
  3. **テストタイムアウト値（E2E）**：コード内のデフォルト値から推定しているが、環境変数による上書きがあるため正確性に留意

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `jest.config.js`（ルート）
- E-02: `jest.config.turbopack.js`（ルート）
- E-03: `package.json`（ルート、scriptsセクション）
- E-04: `package.json`（ルート、devDependenciesセクション）
- E-05: `.github/workflows/build_and_test.yml`
- E-06: `.github/workflows/build_reusable.yml`
- E-07: `test/readme.md`
- E-08: `contributing/core/testing.md`
- E-09: `test/jest-setup-after-env.ts`
- E-10: `test/jest-global-setup.ts`
- E-11: `test/lib/e2e-utils/index.ts`
- E-12: `test/lib/next-webdriver.ts`
- E-13: `test/lib/next-test-utils.ts`
- E-14: `test/lib/browsers/playwright.ts`（ファイル存在確認）
- E-15: `run-tests.js`
- E-16: `CLAUDE.md`（開発ガイド）
- E-17: `test/` ディレクトリ構成（unit, e2e, integration, development, production）
- E-18: テストファイル数カウント結果（find コマンド）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | テストランナーとして Jest 29.7.0 を使用 | E-04 (`"jest": "29.7.0"`) | ○ |
| C-02 | ブラウザ自動化に Playwright 1.48.0 を使用 | E-04 (`"playwright": "1.48.0"`), E-14 | ○ |
| C-03 | テストレポートに jest-junit 16.0.0 を使用 | E-01, E-04 | ○ |
| C-04 | jest-extended 4.0.2 をマッチャー拡張として使用 | E-04, E-09 (`expect.extend(matchers)`) | ○ |
| C-05 | next/jest による Jest 設定プリセットを使用 | E-01 (`require('next/jest')`) | ○ |
| C-06 | テストディレクトリは unit, e2e, integration, development, production の5種類 | E-17 | ○ |
| C-07 | Unit テストファイルは約95件 | E-18 | ○ |
| C-08 | E2E テストファイルは約801件 | E-18 | ○ |
| C-09 | Integration テストファイルは約352件 | E-18 | ○ |
| C-10 | Development テストファイルは約207件 | E-18 | ○ |
| C-11 | Production テストファイルは約165件 | E-18 | ○ |
| C-12 | CI は GitHub Actions で build_and_test.yml をメインワークフローとする | E-05 | ○ |
| C-13 | CI は canary ブランチ push と PR で発火する | E-05 (on: push: branches: ['canary'], pull_request) | ○ |
| C-14 | テストは Webpack, Turbopack, Rspack の3バンドラーで実行される | E-03, E-05 | ○ |
| C-15 | React 18.3.1 とデフォルト（19.x）の2バージョンでテストされる | E-05, E-15 (`nextjsReactPeerVersion = "19.2.4"`) | ○ |
| C-16 | テストはグループ分割で並列実行される（例: 1/7 - 7/7） | E-05 (matrix.group) | ○ |
| C-17 | デフォルトのテストタイムアウトは60秒（Windows: 180秒） | E-09 (`jest.setTimeout((process.platform === 'win32' ? 180 : 60) * 1000)`) | ○ |
| C-18 | E2E テストのタイムアウトは120秒（Windows: 240秒） | E-11 (`testTimeout = (process.platform === 'win32' ? 240 : 120) * 1000`) | ○ |
| C-19 | E2E テストは一時ディレクトリに隔離された Next.js インストールで実行される | E-08, E-11 | ○ |
| C-20 | nextTestSetup ユーティリティでセットアップ・ティアダウンを自動管理 | E-08, E-11 | ○ |
| C-21 | フレイクテスト検出は test-new-tests.mjs --flake-detection で実施 | E-05 (`node scripts/test-new-tests.mjs --flake-detection`) | ○ |
| C-22 | Firefox、Safari、モバイルデバイスでのクロスブラウザテストが CI に含まれる | E-05 (test-firefox-safari ジョブ、DEVICE_NAME='iPhone XR') | ○ |
| C-23 | Windows でのテスト実行が CI に含まれる | E-05 (test-unit-windows, test-dev-windows 等) | ○ |
| C-24 | Rust テストは cargo nextest で実行される | E-05 (needsNextest: 'yes'), E-06 | ○ |
| C-25 | テストリトライのデフォルトは2回 | E-15 (`DEFAULT_NUM_RETRIES = 2`) | ○ |
| C-26 | devlow-bench によるパフォーマンスベンチマークが CI に含まれる | E-05 (devlow-bench ジョブ) | ○ |
| C-27 | Graphite CI Optimizer による CI 最適化が行われる | E-05 (optimize-ci ジョブ) | ○ |
| C-28 | カバレッジの明示的な数値目標は設定されていない | **根拠なし** | △ |
| C-29 | 不具合管理は GitHub Issues で行われる | **根拠なし** | △ |
| C-30 | テスト生成には pnpm new-test コマンドを使用する | E-03 (`"new-test": "turbo gen test"`), E-08, E-16 | ○ |

## 4) 不足情報（Unknown / Missing）
- C-28（カバレッジ目標）: プロジェクト内に `.nycrc`、`coverageThreshold` 等のカバレッジ設定ファイルが見当たらなかったため、「明示的な数値目標なし」と推定した。ただし、個別パッケージレベルでカバレッジ設定が存在する可能性は排除できない。
  - 候補：各パッケージの jest.config.js / カバレッジ設定ファイル / CI 設定
- C-29（不具合管理）: GitHub Issues による不具合管理は GitHub リポジトリの一般的な運用慣行から推定したものであり、プロジェクト固有の不具合管理プロセスを定義するドキュメントは確認できなかった。
  - 候補：CONTRIBUTING.md / .github/ISSUE_TEMPLATE / 内部運用ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: テストツール・バージョン情報 -- package.json から直接確認可能であり信頼性が高い
- 0: CI/CD ワークフロー構成 -- build_and_test.yml から直接読み取っており信頼性が高い
- 0: テストディレクトリ構成・ファイル数 -- ファイルシステムから直接確認しており信頼性が高い
- 1: テストタイムアウト値 -- コード内のデフォルト値であるが、環境変数による実行時上書きの可能性がある
- 1: カバレッジ目標 -- 「目標なし」は不在の証明であり、見落としの可能性がある
- 1: 不具合管理プロセス -- 推定に基づいており、実際の運用と異なる可能性がある

## 6) レビュアーチェックリスト（最小）
- [ ] テストツールのバージョンが package.json の記載と一致しているか
- [ ] CI ワークフローのジョブ構成が build_and_test.yml の最新状態と一致しているか
- [ ] テストファイル数が実態と大きく乖離していないか（増減はプロジェクト進行に伴い発生する）
- [ ] カバレッジ目標について、プロジェクト固有のポリシーが別途存在しないか確認
- [ ] 不具合管理プロセスについて、チーム固有の運用ルールが別途存在しないか確認
- [ ] Rspack テストの条件分岐（ラベルベース / リリース時のみ）が正確に記載されているか
- [ ] テスト生成コマンド（pnpm new-test）の使用方法が最新のドキュメントと整合しているか
