# ER図

## A. Next.js 内部キャッシュデータ構造

Next.js のキャッシュシステムにおけるデータ構造の関係を示す。これらはRDB上のテーブルではなく、TypeScript の型定義に基づくインメモリ/ファイルシステム上のデータ構造である。

```mermaid
erDiagram
    CacheHandlerValue {
        number lastModified
        number age
        string cacheState
    }

    CachedAppPageValue {
        string kind "APP_PAGE"
        string html
        Buffer rscData
        string postponed
        number status
    }

    CachedPageValue {
        string kind "PAGES"
        string html
        Object pageData
        number status
    }

    CachedRouteValue {
        string kind "APP_ROUTE"
        Buffer body
        number status
    }

    CachedFetchValue {
        string kind "FETCH"
        number revalidate
    }

    CachedFetchData {
        string headers
        string body
        string url
        number status
    }

    CachedRedirectValue {
        string kind "REDIRECT"
        Object props
    }

    CachedImageValue {
        string kind "IMAGE"
        string etag
        string upstreamEtag
        Buffer buffer
        string extension
        number revalidate
    }

    TagManifestEntry {
        string tag_key "PK"
        number stale
        number expired
    }

    SharedCacheControls {
        string route "PK"
        number revalidate
        number expire
    }

    CacheHandlerValue ||--o| CachedAppPageValue : "value (APP_PAGE)"
    CacheHandlerValue ||--o| CachedPageValue : "value (PAGES)"
    CacheHandlerValue ||--o| CachedRouteValue : "value (APP_ROUTE)"
    CacheHandlerValue ||--o| CachedFetchValue : "value (FETCH)"
    CacheHandlerValue ||--o| CachedRedirectValue : "value (REDIRECT)"
    CacheHandlerValue ||--o| CachedImageValue : "value (IMAGE)"
    CachedFetchValue ||--|| CachedFetchData : "data"
```

## B. サンプルアプリケーション: examples/with-mysql（Prisma + MySQL）

ECサイトにおける商品とカテゴリの関係。

```mermaid
erDiagram
    Category {
        Int id PK "AUTO_INCREMENT"
        String name
        String description
    }

    Product {
        Int id PK "AUTO_INCREMENT"
        String name
        String description
        Decimal price
        String image
        Int categoryId FK
    }

    Category ||--o{ Product : "has many"
```

## C. サンプルアプリケーション: examples/prisma-postgres（Prisma + PostgreSQL）

ブログアプリケーションにおけるユーザーと投稿記事の関係。

```mermaid
erDiagram
    User {
        Int id PK "AUTO_INCREMENT"
        String email UK
        String name "nullable"
    }

    Post {
        Int id PK "AUTO_INCREMENT"
        DateTime createdAt "default: now()"
        DateTime updatedAt "auto-update"
        String title
        String content "nullable"
        Boolean published "default: false"
        Int authorId FK
    }

    User ||--o{ Post : "has many"
```

## D. サンプルアプリケーション: examples/with-nhost-auth-realtime-graphql（PostgreSQL）

Nhost 認証・リアルタイム GraphQL におけるユーザーとアイテムの関係。

```mermaid
erDiagram
    users {
        UUID id PK
    }

    items {
        UUID id PK "default: gen_random_uuid()"
        Timestamp created_at "default: now()"
        TEXT name
        UUID user_id FK
    }

    users ||--o{ items : "owns"
```

## E. サンプルアプリケーション: 各種 TODO アプリ

### examples/with-knex（Knex.js + PostgreSQL）

```mermaid
erDiagram
    todos_knex {
        Integer id PK "AUTO_INCREMENT"
        String text
        Boolean done
    }
```

### examples/next-forms（PostgreSQL 直接SQL）

```mermaid
erDiagram
    todos_forms {
        SERIAL id PK
        TEXT text
    }
```

### examples/with-turso（Turso / SQLite）

```mermaid
erDiagram
    todos_turso {
        INTEGER id PK "AUTOINCREMENT"
        TEXT description
    }
```

## F. サンプルアプリケーション: examples/convex

```mermaid
erDiagram
    messages {
        string author
        string body
    }
```

## G. サンプルアプリケーション: examples/with-mongodb-mongoose

MongoDB はドキュメント指向データベースのため、厳密な ER 図ではなくスキーマ構造を示す。

```mermaid
erDiagram
    Pet {
        ObjectId _id PK "auto-generated"
        String name "max 60, required"
        String owner_name "max 60, required"
        String species "max 40, required"
        Number age "optional"
        Boolean poddy_trained "optional"
        StringArray diet "optional"
        String image_url "required"
        StringArray likes "optional"
        StringArray dislikes "optional"
    }
```
