---
generated_at: 2026-02-03 12:00:00
metrics:
  claims_total: 28
  claims_with_evidence: 24
  claims_without_evidence: 4
confidence_derived: 0.86
---

# 根拠レポート：データベース設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.86**
  - 根拠あり：24 / 28、根拠なし：4
- 優先レビュー（高）
  1. **CachedRedirectValue の props 構造詳細**：型定義で Object としか記載されておらず具体的な構造が不明
  2. **CachedImageValue の保存場所・動作詳細**：IncrementalCache の file-system-cache.ts 内では IMAGE 種別が直接扱われていない
  3. **Convex スキーマの完全性**：schemaValidation が false のためランタイムスキーマが異なる可能性
  4. **items テーブルの users テーブル定義**：参照先の users テーブル定義がサンプルコード内に存在しない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `packages/next/src/server/response-cache/types.ts` - キャッシュ値の型定義（CachedRouteKind, CachedAppPageValue, CachedPageValue, CachedRouteValue, CachedFetchValue, CachedRedirectValue, CachedImageValue, IncrementalCacheKind 等）
- E-02: `packages/next/src/server/lib/incremental-cache/file-system-cache.ts` - ファイルシステムキャッシュ実装（保存パス、読み書きロジック）
- E-03: `packages/next/src/server/lib/incremental-cache/index.ts` - IncrementalCache クラス、CacheHandler インターフェース、CacheHandlerValue 型
- E-04: `packages/next/src/server/lib/incremental-cache/tags-manifest.external.ts` - TagManifestEntry 型定義、tagsManifest Map
- E-05: `packages/next/src/server/lib/incremental-cache/shared-cache-controls.external.ts` - SharedCacheControls クラス定義
- E-06: `packages/next/src/server/lib/incremental-cache/memory-cache.external.ts` - メモリキャッシュ LRU 実装
- E-07: `examples/with-mysql/prisma/schema.prisma` - Product, Category モデル定義
- E-08: `examples/prisma-postgres/prisma/schema.prisma` - User, Post モデル定義
- E-09: `examples/with-knex/knex/migrations/20201015140127_initial.js` - todos テーブルマイグレーション
- E-10: `examples/next-forms/app/actions.ts` - todos テーブル SQL コメント、INSERT/DELETE クエリ
- E-11: `examples/with-turso/app/todo-list.tsx` - todos テーブル CREATE TABLE 文
- E-12: `examples/with-nhost-auth-realtime-graphql/setup/data.sql` - items テーブル CREATE TABLE 文、外部キー制約
- E-13: `examples/convex/convex/schema.ts` - messages テーブルスキーマ定義
- E-14: `examples/with-mongodb-mongoose/models/Pet.ts` - Pet Mongoose スキーマ定義
- E-15: `examples/with-knex/knexfile.js` - Knex 接続設定（PostgreSQL）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Next.js はフレームワーク自体にアプリケーション固有の永続データベースを持たない | E-01, E-02, E-03 | ○ |
| C-02 | CachedAppPageValue は html, rscData, postponed, status, headers, segmentData フィールドを持つ | E-01 (IncrementalCachedAppPageValue 型, L113-L123) | ○ |
| C-03 | CachedPageValue は html, pageData, headers, status フィールドを持つ | E-01 (IncrementalCachedPageValue 型, L125-L133) | ○ |
| C-04 | CachedRouteValue は body, status, headers フィールドを持つ | E-01 (CachedRouteValue 型, L93-L100) | ○ |
| C-05 | CachedFetchValue は data, tags, revalidate フィールドを持つ | E-01 (CachedFetchValue 型, L57-L64) | ○ |
| C-06 | CachedFetchData は headers, body, url, status フィールドを持つ | E-01 (CachedFetchData 型, L41-L46) | ○ |
| C-07 | CachedRedirectValue は kind と props を持つ | E-01 (CachedRedirectValue 型, L66-L69) | ○ |
| C-08 | CachedRedirectValue の props の詳細構造 | **根拠なし** | △ |
| C-09 | CachedImageValue は etag, upstreamEtag, buffer, extension, revalidate, isMiss, isStale を持つ | E-01 (CachedImageValue 型, L102-L111) | ○ |
| C-10 | CachedImageValue はファイルシステムキャッシュで直接扱われない | E-02 (file-system-cache.ts に IMAGE 処理なし) | △ |
| C-11 | TagManifestEntry は stale と expired フィールドを持つ | E-04 (TagManifestEntry 型, L3-L6) | ○ |
| C-12 | CacheHandlerValue は lastModified, age, cacheState, value を持つ | E-03 (CacheHandlerValue 型, L52-L57) | ○ |
| C-13 | ファイルシステムキャッシュの保存先パス構造 | E-02 (getFilePath メソッド, L457-L478) | ○ |
| C-14 | インメモリ LRU キャッシュが maxMemoryCacheSize で制御される | E-06, E-03 (constructor 内の maxMemoryCacheSize 処理) | ○ |
| C-15 | カスタムキャッシュハンドラーで外部ストアに差し替え可能 | E-03 (CurCacheHandler パラメータ, L130-L163) | ○ |
| C-16 | Product テーブルは id, name, description, price, image, categoryId を持つ | E-07 (schema.prisma, L11-L21) | ○ |
| C-17 | Category テーブルは id, name, description を持ち Product と一対多 | E-07 (schema.prisma, L23-L28) | ○ |
| C-18 | User テーブルは id, email(unique), name を持つ | E-08 (schema.prisma, L11-L16) | ○ |
| C-19 | Post テーブルは id, createdAt, updatedAt, title, content, published, authorId を持ち User と多対一 | E-08 (schema.prisma, L18-L27) | ○ |
| C-20 | with-knex の todos テーブルは id, text, done を持つ | E-09 (マイグレーションファイル, L1-L7) | ○ |
| C-21 | next-forms の todos テーブルは id(SERIAL), text(TEXT) を持つ | E-10 (コメント内 SQL, L11-L14) | ○ |
| C-22 | with-turso の todos テーブルは id(INTEGER), description(TEXT) を持つ | E-11 (CREATE TABLE 文, L13-L16) | ○ |
| C-23 | items テーブルは id(UUID), created_at, name, user_id を持ち users テーブルに外部キー | E-12 (data.sql, L1-L15) | ○ |
| C-24 | items の参照先 users テーブルの完全な定義 | **根拠なし** | △ |
| C-25 | messages テーブルは author, body を持つ | E-13 (schema.ts, L6-L9) | ○ |
| C-26 | Convex スキーマバリデーションが無効化されている | E-13 (schema.ts, L12: schemaValidation: false) | ○ |
| C-27 | Pet コレクションのフィールド定義（name, owner_name, species, age, poddy_trained, diet, image_url, likes, dislikes） | E-14 (Pet.ts, L16-L69) | ○ |
| C-28 | SharedCacheControls は route ごとに revalidate/expire を管理する | E-05 (SharedCacheControls クラス, L10-L85) | ○ |

## 4) 不足情報（Unknown / Missing）
- **CachedRedirectValue の props 構造詳細**（C-08）：型定義上 `Object` としか指定されておらず、リダイレクト先URLやステータスコードなどの具体的なフィールドが不明。実行時の動的な値であるため、コードベースからの静的解析のみでは特定困難。
  - 候補：`packages/next/src/server/render.tsx` / `packages/next/src/server/app-render/` / リダイレクト関連のミドルウェア実装
- **CachedImageValue のファイルシステムキャッシュにおける取り扱い**（C-10）：`file-system-cache.ts` の `getFilePath` メソッドに `IMAGE` ケースは存在するが、`get`/`set` メソッド内に IMAGE 固有の処理は見られない。別のキャッシュハンドラーで処理されている可能性がある。
  - 候補：`packages/next/src/server/image-optimizer.ts` / 画像最適化専用キャッシュ実装
- **items テーブルが参照する users テーブルの完全定義**（C-24）：`data.sql` 内で `public.users(id)` への外部キー参照があるが、users テーブル自体の CREATE TABLE 文はサンプルコードに含まれていない（Nhost が自動生成する認証テーブルと推測される）。
  - 候補：Nhost ドキュメント / 認証テーブルの自動生成仕様
- **Convex のランタイムスキーマの完全性**（C-26 関連）：schemaValidation が false のため、実際のランタイムでは定義外のフィールドが存在する可能性がある。
  - 候補：Convex ダッシュボード / 実行時データの確認

## 5) リスクフラグ（レビュー観点）
- **リスク 0（低）**: サンプルアプリケーションのスキーマ定義（C-16 から C-27） - ソースコードから直接読み取れる内容であり、正確性が高い
- **リスク 1（中）**: Next.js 内部キャッシュ構造の記述（C-01 から C-15） - 型定義とソースコードに基づいているが、ランタイムの動作や未文書化の挙動がある可能性
- **リスク 1（中）**: CachedImageValue の保存場所と動作（C-10） - ファイルシステムキャッシュ実装での取り扱いが不明確
- **リスク 2（高）**: CachedRedirectValue の具体的構造（C-08） - Object 型のみで具体的なフィールドが確認できない

## 6) レビュアーチェックリスト（最小）
- [ ] Next.js 内部キャッシュのデータ構造が実際の型定義（`response-cache/types.ts`）と一致しているか確認
- [ ] ファイルシステムキャッシュの保存パス構造が `file-system-cache.ts` の `getFilePath` メソッドと整合しているか確認
- [ ] CachedRedirectValue の props フィールドの具体的な構造を実行時デバッグで補完する必要があるか判断
- [ ] CachedImageValue が IncrementalCache 経由ではなく別の経路で処理されているか確認
- [ ] サンプルアプリケーションのスキーマが最新のソースコードと一致しているか確認
- [ ] items テーブルの users 参照先が Nhost の自動生成テーブルであるかドキュメントで確認
