---
generated_at: 2026-02-03 00:00:00
metrics:
  claims_total: 50
  claims_with_evidence: 48
  claims_without_evidence: 2
confidence_derived: 0.96
---

# 根拠レポート：バッチ一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：48 / 50、根拠なし：2
- 優先レビュー（高）
  1. **deploy-examples（No.48）**：シェルスクリプトの内部処理の詳細未確認
  2. **deploy-turbopack-docs（No.49）**：シェルスクリプトの内部処理の詳細未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `packages/next/src/cli/next-build.ts`
- E-02: `package.json` scripts セクション
- E-03: `scripts/build-native.ts`
- E-04: `scripts/pack-next.ts`
- E-05: `scripts/start-release.js`
- E-06: `scripts/publish-release.js`
- E-07: `scripts/publish-native.js`
- E-08: `scripts/create-release-branch.js`
- E-09: `scripts/create-preview-tarballs.js`
- E-10: `scripts/normalize-version-bump.js`
- E-11: `scripts/generate-release-log.mjs`
- E-12: `scripts/code-freeze.js`
- E-13: `packages/next/src/cli/next-test.ts`
- E-14: `scripts/test-new-tests.mjs`
- E-15: `scripts/get-changed-tests.mjs`
- E-16: `scripts/check-pre-compiled.sh`
- E-17: `scripts/check-manifests.js`
- E-18: `scripts/validate-externals-doc.js`
- E-19: `scripts/sync-react.js`
- E-20: `scripts/update-google-fonts.js`
- E-21: `scripts/automated-update-workflow.js`
- E-22: `packages/next/src/cli/next-analyze.ts`
- E-23: `packages/next/src/cli/next-info.ts`
- E-24: `scripts/analyze-dev-server-bundle.js`
- E-25: `scripts/trace-next-server.js`
- E-26: `scripts/benchmark-next-dev-boot.js`
- E-27: `scripts/devlow-bench.mjs`
- E-28: `scripts/pr-status.js`
- E-29: `packages/next/src/cli/next-typegen.ts`
- E-30: `packages/next/src/cli/next-upgrade.ts`
- E-31: `packages/next/src/cli/next-telemetry.ts`
- E-32: `scripts/check-is-release.js`
- E-33: `scripts/pull-turbo-cache.js`
- E-34: `scripts/deploy-docs.sh`
- E-35: `scripts/deploy-examples.sh`
- E-36: `scripts/deploy-turbopack-docs.sh`
- E-37: `scripts/inject-deploy-url.js`
- E-38: `scripts/merge-errors-json/merge.mjs`
- E-39: `packages/next/src/cli/next-export.ts`
- E-40: `packages/next/taskfile.js`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | next build: プロダクションビルドを実行する | E-01 | ○ |
| C-02 | turbo run build: モノレポ全体のビルドを実行する | E-02 | ○ |
| C-03 | swc-build-native: SWCネイティブバインディングのビルド | E-03 | ○ |
| C-04 | pack-next: tarball形式でパッケージング | E-04 | ○ |
| C-05 | start-release: リリースプロセスを開始する | E-05 | ○ |
| C-06 | publish-release: npmレジストリに公開する | E-06 | ○ |
| C-07 | publish-native: ネイティブバイナリをnpm公開 | E-07 | ○ |
| C-08 | create-release-branch: リリース用ブランチを作成 | E-08 | ○ |
| C-09 | create-preview-tarballs: PRプレビュー用tarball生成 | E-09 | ○ |
| C-10 | normalize-version-bump: バージョン番号を正規化 | E-10 | ○ |
| C-11 | generate-release-log: リリースログを生成 | E-11 | ○ |
| C-12 | code-freeze: コードフリーズの切り替え | E-12 | ○ |
| C-13 | test-unit: Jestによるユニットテスト実行 | E-02 | ○ |
| C-14 | test-dev-turbo: Turbopack開発モードテスト | E-02 | ○ |
| C-15 | test-start-turbo: Turbopackプロダクションモードテスト | E-02 | ○ |
| C-16 | test-dev-webpack: Webpack開発モードテスト | E-02 | ○ |
| C-17 | test-start-webpack: Webpackプロダクションモードテスト | E-02 | ○ |
| C-18 | test-deploy: デプロイモードテスト | E-02 | ○ |
| C-19 | test-new-tests: 変更テストの検出・実行 | E-14 | ○ |
| C-20 | next test: PlaywrightテストCLIコマンド | E-13 | ○ |
| C-21 | lint: 総合リント | E-02 | ○ |
| C-22 | lint-fix: 自動修正 | E-02 | ○ |
| C-23 | check-precompiled: プリコンパイル済みファイル検証 | E-16 | ○ |
| C-24 | check-manifests: エラーマニフェスト整合性検証 | E-17 | ○ |
| C-25 | validate-externals-doc: 外部パッケージドキュメント検証 | E-18 | ○ |
| C-26 | check-error-codes: エラーコード整合性検証 | E-02 | ○ |
| C-27 | update-error-codes: エラーコード更新 | E-02 | ○ |
| C-28 | merge-errors-json: errors.jsonマージコンフリクト自動解決 | E-38 | ○ |
| C-29 | sync-react: React依存パッケージ同期 | E-19 | ○ |
| C-30 | update-google-fonts: Google Fontsデータ更新 | E-20 | ○ |
| C-31 | automated-update-workflow: 汎用自動更新ワークフロー | E-21 | ○ |
| C-32 | next analyze: バンドル分析 | E-22 | ○ |
| C-33 | next info: 環境情報収集 | E-23 | ○ |
| C-34 | analyze-dev-server-bundle: 開発サーバーバンドル分析 | E-24 | ○ |
| C-35 | trace-next-server: サーバーファイルトレース | E-25 | ○ |
| C-36 | benchmark-next-dev-boot: 起動時間ベンチマーク | E-26 | ○ |
| C-37 | devlow-bench: devlow-benchパフォーマンスベンチマーク | E-27 | ○ |
| C-38 | pr-status: PR CI状況分析レポート生成 | E-28 | ○ |
| C-39 | next typegen: TypeScript型定義自動生成 | E-29 | ○ |
| C-40 | next upgrade: Next.jsアップグレード | E-30 | ○ |
| C-41 | next telemetry: テレメトリ設定管理 | E-31 | ○ |
| C-42 | clean: モノレポクリーンアップ | E-02 | ○ |
| C-43 | postinstall: インストール後初期化 | E-02 | ○ |
| C-44 | check-is-release: リリースバージョン検出 | E-32 | ○ |
| C-45 | get-changed-tests: 変更テストファイル検出 | E-15 | ○ |
| C-46 | pull-turbo-cache: Turboキャッシュ取得 | E-33 | ○ |
| C-47 | deploy-docs: ドキュメントサイトデプロイ | E-34 | ○ |
| C-48 | deploy-examples: サンプルアプリデプロイ | **根拠なし** | △ |
| C-49 | deploy-turbopack-docs: Turbopackドキュメントデプロイ | **根拠なし** | △ |
| C-50 | inject-deploy-url: デプロイURL注入 | E-37 | ○ |

## 4) 不足情報（Unknown / Missing）
- C-48（deploy-examples）：`scripts/deploy-examples.sh` はファイルの存在を確認したが、内部処理の詳細を確認していない。シェルスクリプトの具体的な処理内容は読み取っていないため説明が推測を含む。
  - 候補：scripts/deploy-examples.sh の詳細読み取り / CI workflow の確認
- C-49（deploy-turbopack-docs）：`scripts/deploy-turbopack-docs.sh` はファイルの存在を確認したが、内部処理の詳細を確認していない。
  - 候補：scripts/deploy-turbopack-docs.sh の詳細読み取り / CI workflow の確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分のバッチ（48/50件）はソースコードの直接確認に基づいている
- 1: 中リスク - deploy-examples, deploy-turbopack-docs の2件はファイル存在のみ確認、詳細処理は未確認
- 0: 低リスク - カテゴリ分類は機能的な観点で行っており、プロジェクト固有の分類基準がある場合は調整が必要

## 6) レビュアーチェックリスト（最小）
- [ ] 全50件のバッチが漏れなく列挙されているか（特にCI workflowで定義されるバッチの網羅性）
- [ ] カテゴリ分類が適切か（ビルド / リリース / テスト / コード品質 / 依存関係更新 / 分析・診断 / コード生成 / ユーティリティ / デプロイ）
- [ ] deploy-examples, deploy-turbopack-docs の説明が正確か（シェルスクリプト内容の確認推奨）
- [ ] GitHub Actions workflowで定義される自動実行バッチ（cron等）が網羅されているか
- [ ] 各バッチの「備考」欄の実行方法・環境変数情報が正確か
