# バッチ設計書 10-normalize-version-bump

## 概要

本ドキュメントは、Turboキャッシュの不要な無効化を防ぐためにパッケージのバージョン番号を0.0.0に正規化する `normalize-version-bump` バッチの設計書である。

### 本バッチの処理概要

`normalize-version-bump` は、モノレポ内の全パッケージのバージョン番号を `0.0.0` に統一するバッチ処理である。バージョン番号の変更がTurborepoのキャッシュキーに影響し、本来キャッシュ可能なビルドが無効化されることを防止する。

**業務上の目的・背景**：Turborepoはpackage.jsonの内容をキャッシュキーの一部として使用する。リリースプロセスでバージョン番号が更新されると、コードに変更がなくてもキャッシュが無効化され、フルリビルドが発生する。本バッチでバージョンを正規化することで、CI/CD環境でのビルド時間を大幅に短縮できる。また、pnpm-lock.yamlを空にし、ルートpackage.jsonを最小構成に書き換えることで、依存関係の差分によるキャッシュ無効化も防止する。

**バッチの実行タイミング**：ビルド前処理として実行。CI/CDパイプラインの初期段階で、`turbo run build` の前に実行される。

**主要な処理内容**：
1. packages/ ディレクトリの全パッケージのpackage.jsonを読み込み
2. 各パッケージのバージョンを `0.0.0` に更新
3. モノレポ内パッケージ間の依存関係バージョンも `0.0.0` に更新
4. lerna.json のバージョンを `0.0.0` に更新
5. pnpm-lock.yaml を空ファイルに置換
6. ルート package.json を最小構成に書き換え

**前後の処理との関連**：CI/CDパイプラインで `turbo run build` の前に実行される。`start-release` でバージョンが更新された後のビルドパイプラインで特に有用。

**影響範囲**：モノレポ内の全 `package.json`、`lerna.json`、`pnpm-lock.yaml`、ルート `package.json`。

## バッチ種別

ビルド前処理（バージョン正規化）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | CI/CDビルドごと |
| 実行時刻 | ビルドパイプライン初期 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | CI/CDパイプライン |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.js環境 | Node.js が利用可能であること |
| packagesディレクトリ | packages/ ディレクトリが存在すること |
| lerna.json | ルートに lerna.json が存在すること |

### 実行可否判定

特別な判定なし。packages/ ディレクトリの読み取りが可能であれば実行される。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | コマンドライン引数なし |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| packages/*/package.json | JSON | 各パッケージのバージョン・依存関係情報 |
| lerna.json | JSON | モノレポバージョン情報 |
| pnpm-lock.yaml | YAML | パッケージロックファイル |
| package.json（ルート） | JSON | ルートパッケージ設定 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| packages/*/package.json | JSON | バージョン 0.0.0 に更新 |
| lerna.json | JSON | バージョン 0.0.0 に更新 |
| pnpm-lock.yaml | テキスト | 空ファイル |
| package.json（ルート） | JSON | 最小構成に書き換え |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | package.json, lerna.json, pnpm-lock.yaml |
| 出力先 | リポジトリルート、各パッケージディレクトリ |
| 文字コード | UTF-8 |
| 区切り文字 | JSON形式（2スペースインデント + 末尾改行） |

## 処理フロー

### 処理シーケンス

```
1. パッケージ一覧取得
   └─ packages/ ディレクトリを読み込み
2. 全パッケージのpackage.json読み込み（並列）
   └─ パッケージ名を収集、データをMapに保存
3. バージョン正規化処理（並列）
   └─ 各パッケージについて:
      a. version を 0.0.0 に設定
      b. dependencies 内のモノレポパッケージを 0.0.0 に更新
      c. devDependencies 内のモノレポパッケージを 0.0.0 に更新
      d. package.json を書き込み
4. lerna.json 正規化
   └─ バージョンを 0.0.0 に設定
5. pnpm-lock.yaml 空化
   └─ 既存ファイルを削除し、空ファイルを作成
6. ルート package.json 書き換え
   └─ 最小構成（name, version, private, workspaces, scripts, packageManager）
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始: normalize-version-bump] --> B[packages/ 読み込み]
    B --> C[全パッケージ package.json 読み込み（並列）]
    C --> D[パッケージ名一覧収集]
    D --> E[各パッケージのバージョン正規化（並列）]
    E --> F[version を 0.0.0 に更新]
    F --> G[モノレポ内依存関係も 0.0.0 に更新]
    G --> H[lerna.json バージョン正規化]
    H --> I[pnpm-lock.yaml 空化]
    I --> J[ルート package.json 最小構成化]
    J --> K[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 該当なし | - | - | データベース操作なし |

### テーブル別操作詳細

該当なし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ENOENT | ファイル不在 | package.jsonが存在しない | パッケージディレクトリの構成を確認 |
| JSON_PARSE_ERROR | パースエラー | package.jsonの形式不正 | ファイル内容を確認 |
| EACCES | 権限エラー | ファイルの書き込み権限がない | 実行権限を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

処理失敗時は、Gitの変更を取り消して（`git checkout .`）再実行する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | ファイルシステム操作のみ |
| コミットタイミング | 各ファイル書き込み時 |
| ロールバック条件 | git checkout . で変更を元に戻す |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 約10-15パッケージ + lerna.json + ルートpackage.json |
| 目標処理時間 | 数秒 |
| メモリ使用量上限 | 通常のNode.jsプロセスメモリ |

## 排他制御

同時実行の排他制御は行わない。CI/CDパイプラインの順序制御により、ビルド前に1回のみ実行される想定。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| なし | - | 本バッチは明示的なログ出力を行わない |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | CI/CDパイプライン |

## 備考

- エントリポイント: `scripts/normalize-version-bump.js`
- 正規化バージョン: `0.0.0`（NORMALIZED_VERSION定数）
- モノレポ内パッケージ間の依存関係のみバージョンを更新（外部パッケージの依存は変更しない）
- 依存関係のバージョン更新条件: パッケージ名がモノレポ内パッケージ名一覧に含まれ、かつバージョンが元のバージョンと一致する場合のみ
- ルートpackage.jsonは `nextjs-project` として最小構成に書き換えられる（packageManager: pnpm@9.6.0）
- pnpm-lock.yaml は一度削除（unlink）してから空ファイルとして再作成される
- JSON出力は2スペースインデント + 末尾改行（`JSON.stringify(data, null, 2) + '\n'`）
