# バッチ設計書 11-generate-release-log

## 概要

本ドキュメントは、Next.jsプロジェクトにおけるリリースログ生成バッチ `generate-release-log` の設計仕様を定義する。

### 本バッチの処理概要

GitHub Releases APIから最新のcanaryリリース情報を取得し、複数のcanaryリリースにまたがる変更内容を集約してリリースログを生成するバッチである。

**業務上の目的・背景**：Next.jsは頻繁にcanaryリリースを行っており、安定版リリース時にはこれらのcanaryリリースに含まれる変更内容を集約したリリースノートが必要となる。手動での集約は変更量が多いため非現実的であり、本バッチによって自動的にリリースログを生成することで、リリース作業の効率化とリリースノートの品質向上を実現する。

**バッチの実行タイミング**：安定版リリースの準備時に手動で実行される。通常はリリースプロセスの一環として、start-releaseバッチの前後に実行する。

**主要な処理内容**：
1. GitHub Releases APIから最新100件のリリース情報を取得する
2. 最新のcanaryバージョンプレフィックスを自動検出する
3. 該当バージョンに属するリリースのボディを解析し、カテゴリ別（Core Changes, Minor Changes, Documentation Changes, Example Changes, Misc Changes, Patches, Credits）に変更内容を分類する
4. Credits セクションではGitHubユーザー名を抽出し、重複を排除した貢献者リストを生成する
5. 集約されたリリースログをコンソールに出力する

**前後の処理との関連**：本バッチはリリースプロセスの情報収集フェーズに位置する。前提としてGitHub上にcanaryリリースが公開されている必要がある。生成されたログは、start-release（No.5）やpublish-release（No.6）の実行時にリリースノートとして利用される。

**影響範囲**：本バッチは読み取り専用であり、GitHub Releases APIからデータを取得してコンソールに出力するのみ。リポジトリやパッケージへの変更は行わない。

## バッチ種別

レポート生成

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | 手動（リリース準備時） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| GitHub Releases存在 | 対象バージョンのcanaryリリースがGitHub Releasesに公開済みであること |
| ネットワーク接続 | GitHub APIにアクセス可能であること |
| node-fetch利用可能 | node-fetchパッケージがインストール済みであること |

### 実行可否判定

GitHub Releases APIからリリース情報を取得できること。認証トークンは不要（パブリックリポジトリのため）だが、APIレートリミットに注意が必要。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | CLIパラメータは不要。自動的に最新バージョンを検出する |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| GitHub Releases API | JSON | `https://api.github.com/repos/vercel/next.js/releases?per_page=100` から取得 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力（コンソール） | テキスト | カテゴリ別に分類されたリリースログ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | なし（標準出力のみ） |
| 出力先 | コンソール |
| 文字コード | UTF-8 |
| 区切り文字 | なし（Markdown形式） |

出力されるリリースログには以下のセクションが含まれる：
- `### Core Changes`：コア機能の変更
- `### Minor Changes`：マイナー変更
- `### Documentation Changes`：ドキュメント変更
- `### Example Changes`：サンプル変更
- `### Misc Changes`：その他の変更
- `### Patches`：パッチ
- `### Credits`：貢献者一覧

## 処理フロー

### 処理シーケンス

```
1. GitHub Releases API呼び出し
   └─ 最新100件のリリース情報を取得（per_page=100）
2. リリース情報の整形
   └─ id, tag_name, created_at, bodyを抽出し、作成日時でソート
3. ターゲットバージョンの検出
   └─ 正規表現 /v(.*?-)/ で最新のcanaryバージョンプレフィックスを特定
4. 対象リリースのフィルタリング
   └─ ターゲットバージョンに一致するリリースを抽出
5. カテゴリ別変更内容の集約
   └─ 各リリースのbodyからMarkdownヘッダーを基にカテゴリ分類
6. Credits処理
   └─ @ユーザー名の正規表現抽出と重複排除
7. 最終メッセージの組み立て
   └─ 空でないカテゴリのみを含むMarkdown形式のログ生成
8. 結果出力
   └─ コンソールにリリースログを出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[GitHub Releases API呼び出し]
    B --> C[リリース情報整形・ソート]
    C --> D[最新canaryバージョンプレフィックス検出]
    D --> E[対象リリースフィルタリング]
    E --> F{対象リリースあり?}
    F -->|あり| G[カテゴリ別変更内容集約]
    F -->|なし| H[空の結果を出力]
    G --> I[Credits抽出・重複排除]
    I --> J[Markdownリリースログ組み立て]
    J --> K[コンソール出力]
    H --> L[バッチ終了]
    K --> L
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| なし | - | - | データベース操作は行わない |

### テーブル別操作詳細

本バッチはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | APIエラー | GitHub Releases APIがエラーレスポンスを返した場合 | ネットワーク接続を確認し再実行 |
| - | レートリミット | GitHub APIのレートリミットに達した場合 | 時間をおいて再実行、または認証トークンを使用 |
| - | パースエラー | リリースボディのフォーマットが想定外の場合 | 該当リリースのボディ形式を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（自動リトライ未実装） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

バッチ失敗時はエラー内容をコンソールで確認し、ネットワーク接続やGitHub APIの状態を確認した上で再実行する。冪等性のある読み取り専用処理のため、再実行に副作用はない。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（データベース操作なし） |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 最大100件のリリース情報 |
| 目標処理時間 | 30秒以内 |
| メモリ使用量上限 | 256MB |

## 排他制御

同時実行可能。読み取り専用処理のため排他制御は不要。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 結果ログ | 処理完了時 | 生成されたリリースログ全文 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 60秒 | コンソール |
| APIエラー | 1件 | コンソール |

## 備考

- 実行スクリプト: `scripts/generate-release-log.mjs`
- main()関数はversion, firstVersion, lastVersion, contentを含むオブジェクトを返却するため、他のスクリプトからモジュールとしてインポートして利用することも可能
- GitHub APIの認証なしでの利用時はレートリミット（60回/時間）に注意
