# バッチ設計書 13-test-unit

## 概要

本ドキュメントは、Next.jsプロジェクトにおけるユニットテスト実行バッチ `test-unit` の設計仕様を定義する。

### 本バッチの処理概要

Jestテストランナーを使用して、Next.jsプロジェクトのユニットテストを実行するバッチである。テスト対象は `test/unit/`、`packages/next/`、`packages/font` の3つのディレクトリである。

**業務上の目的・背景**：Next.jsフレームワークの品質を保証するため、個々の関数・モジュール単位でのテストを実行する。ブラウザを必要としない軽量かつ高速なテストであり、CI/CDパイプラインでの早期エラー検出に貢献する。E2Eテストや統合テストと比較して実行時間が短いため、開発者のフィードバックループを高速に保つ役割を果たす。

**バッチの実行タイミング**：CIパイプラインで毎PR・毎コミット時に自動実行される。開発者がローカルで手動実行することも多い。

**主要な処理内容**：
1. Jestテストランナーを起動する
2. `test/unit/` ディレクトリ配下のユニットテストを実行する
3. `packages/next/` ディレクトリ配下のテストファイルを実行する
4. `packages/font` ディレクトリ配下のテストファイルを実行する
5. テスト結果を集約して成功・失敗を報告する

**前後の処理との関連**：ビルドバッチ（No.1 next build）によるコンパイルが完了していることが前提。ユニットテストはテストピラミッドの基盤部分であり、ここで検出されなかった問題は統合テスト（No.14-18）で検出される。

**影響範囲**：テストの実行のみであり、ソースコードやビルド成果物への変更は行わない。テスト結果はJestの標準出力およびCI環境ではJUnit形式のレポートとして出力される。

## バッチ種別

テスト実行

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（PR/コミット時） |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | CI自動実行 / 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| 依存パッケージインストール済み | `pnpm install` が完了していること |
| Jestインストール済み | devDependenciesにjest 29.7.0が含まれていること |
| Node.js 20.9.0以上 | package.jsonのengines制約を満たすこと |

### 実行可否判定

Jestが正常にインストールされており、テスト対象ディレクトリが存在すること。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| テストパス | string[] | No | `test/unit/ packages/next/ packages/font` | Jestに渡すテスト対象パス |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| テストファイル群 | TypeScript/JavaScript | `test/unit/`、`packages/next/`、`packages/font` 配下の `*.test.ts`, `*.test.js` ファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | Jestテスト結果サマリー |
| JUnitレポート | XML | CI環境でのテスト結果レポート（jest-junit使用時） |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | JUnit XML（CI環境設定に依存） |
| 出力先 | CI環境のアーティファクト |
| 文字コード | UTF-8 |
| 区切り文字 | なし（XML形式） |

## 処理フロー

### 処理シーケンス

```
1. Jestテストランナー起動
   └─ `jest test/unit/ packages/next/ packages/font` コマンドを実行
2. テストファイル検出
   └─ 指定ディレクトリからテストファイルをglobパターンで検出
3. テストスイート実行
   └─ 各テストファイルのdescribe/itブロックを順次実行
4. アサーション検証
   └─ expect()による検証結果を集計
5. 結果レポート
   └─ 成功/失敗/スキップの件数をサマリーとして出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[Jest起動]
    B --> C[テストファイル検出]
    C --> D{テストファイルあり?}
    D -->|あり| E[テストスイート実行]
    D -->|なし| F[0件で正常終了]
    E --> G[アサーション検証]
    G --> H[結果集計]
    H --> I{全テスト成功?}
    I -->|Yes| J[終了コード0で終了]
    I -->|No| K[終了コード1で終了]
    F --> J
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| なし | - | - | データベース操作は行わない |

### テーブル別操作詳細

本バッチはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 終了コード1 | テスト失敗 | 1つ以上のテストが失敗した場合 | 失敗テストの内容を確認し修正 |
| - | 設定エラー | Jest設定ファイルに問題がある場合 | jest.config.jsを確認 |
| - | 依存エラー | 必要なパッケージが不足している場合 | pnpm installを実行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（CI環境ではrun-tests.jsによるリトライあり：デフォルト2回） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

テスト失敗時はJestの出力からスタックトレースと失敗箇所を確認する。環境依存の問題の場合はNode.jsバージョンやOS環境を確認する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数百〜数千テストケース |
| 目標処理時間 | 5分以内 |
| メモリ使用量上限 | 2048MB |

## 排他制御

同時実行可能。テストは読み取り専用の処理が中心であり、ファイルシステム上の一時ファイル生成はテストごとに隔離される。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | Jest起動時 | テストスイート数、テストファイル数 |
| 進捗ログ | 各テストスイート実行時 | PASS/FAILステータスとファイル名 |
| 終了ログ | 全テスト完了時 | サマリー（テスト数、成功数、失敗数、スキップ数、実行時間） |
| エラーログ | テスト失敗時 | 失敗テスト名、期待値と実際値の差分、スタックトレース |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| テスト失敗数 | 1件以上 | CI（GitHub Actions） |
| 実行時間 | 10分 | CI |

## 備考

- 実行コマンド: `jest test/unit/ packages/next/ packages/font`（package.json scripts.test-unit）
- ブラウザ不要の軽量テストであり、E2Eテストより高速
- `pnpm testonly` コマンド（`jest --runInBand`）で単一スレッド実行も可能
- CI環境では `jest-junit` レポーターによるXML出力をサポート
