# バッチ設計書 16-test-dev-webpack

## 概要

本ドキュメントは、Next.jsプロジェクトにおけるWebpack開発モード統合テスト実行バッチ `test-dev-webpack` の設計仕様を定義する。

### 本バッチの処理概要

Webpackバンドラーを使用した開発モード（dev mode）でNext.jsの統合テスト・E2Eテストを実行するバッチである。ヘッドレスブラウザを使用したブラウザテストを含む。

**業務上の目的・背景**：Next.jsは従来からWebpackをバンドラーとして使用しており、Webpackベースの開発モードでの互換性を継続的に検証する必要がある。Turbopackへの移行が進む中でも、Webpack利用者は依然として多く、Webpackモードでの動作保証は不可欠である。本バッチは `test-dev-turbo`（No.14）と並行して実行され、両バンドラーの動作一貫性を担保する。

**バッチの実行タイミング**：CIパイプラインでPR・コミット時に自動実行される。ローカル開発でも手動実行可能。

**主要な処理内容**：
1. 環境変数 `IS_WEBPACK_TEST=1` を設定してWebpackモードを指定する
2. `NEXT_TEST_MODE=dev` を設定して開発モードテストを指定する
3. `HEADLESS=true` でヘッドレスブラウザモードを有効化する
4. 各テストでNext.jsアプリケーションをWebpackで開発サーバー起動してテストする
5. テスト対象は `test/e2e/`、`test/development/`、`test/integration/` 配下のテストファイル

**前後の処理との関連**：ユニットテスト（No.13）の後に実行される。Turbopack版の同等バッチは `test-dev-turbo`（No.14）。プロダクションモードのWebpackテストは `test-start-webpack`（No.17）で実行される。

**影響範囲**：テスト実行のみであり、ソースコードやビルド成果物への変更は行わない。

## バッチ種別

テスト実行

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（PR/コミット時） |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | CI自動実行 / 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| 依存パッケージインストール済み | `pnpm install` が完了していること |
| Next.jsビルド済み | `pnpm build` が完了し、`packages/next/dist/` が生成されていること |
| Playwright/ブラウザインストール済み | ヘッドレスブラウザ（Chromium）が利用可能であること |

### 実行可否判定

Next.jsのビルド成果物が存在し、テスト対象ファイルが存在すること。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| テストパス | string[] | No | 全テスト | 特定のテストファイル/ディレクトリを指定可能 |
| -t | string | No | なし | テスト名パターンによるフィルタリング |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| テストファイル群 | TypeScript/JavaScript | `test/e2e/`、`test/development/`、`test/integration/` 配下のテストファイル |
| テストフィクスチャ | 各種 | テスト用のNext.jsアプリケーションファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | Jestテスト結果サマリー |
| JUnitレポート | XML | CI環境でのテスト結果レポート |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | CI環境設定に依存 |
| 出力先 | CIアーティファクト |
| 文字コード | UTF-8 |
| 区切り文字 | なし |

## 処理フロー

### 処理シーケンス

```
1. 環境変数設定
   └─ IS_WEBPACK_TEST=1, NEXT_TEST_MODE=dev, HEADLESS=true
2. テストファイル検出
   └─ 指定パスまたは全テストディレクトリからテストファイルを検出
3. テストスイート実行ループ
   └─ 各テストファイルに対して以下を繰り返す
4. Next.js開発サーバー起動（各テスト内）
   └─ テストフィクスチャのNext.jsアプリをWebpackモードで起動
5. ブラウザテスト実行
   └─ ヘッドレスChromiumでページアクセス・DOM検証
6. クリーンアップ
   └─ 開発サーバー停止、一時ファイル削除
7. 結果レポート
   └─ 成功/失敗/スキップの件数をサマリーとして出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[環境変数設定]
    B --> C[テストファイル検出]
    C --> D{テストファイルあり?}
    D -->|あり| E[テストスイート実行ループ]
    D -->|なし| F[0件で正常終了]
    E --> G[Next.js開発サーバー起動<br/>Webpackモード]
    G --> H[ヘッドレスブラウザテスト]
    H --> I[アサーション検証]
    I --> J[サーバー停止・クリーンアップ]
    J --> K{次のテストあり?}
    K -->|Yes| E
    K -->|No| L[結果集計]
    L --> M{全テスト成功?}
    M -->|Yes| N[終了コード0で終了]
    M -->|No| O[終了コード1で終了]
    F --> N
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| なし | - | - | データベース操作は行わない |

### テーブル別操作詳細

本バッチはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 終了コード1 | テスト失敗 | 1つ以上のテストが失敗した場合 | 失敗テストの内容を確認し修正 |
| - | サーバー起動失敗 | ポート競合やWebpackコンパイルエラー | ポート使用状況確認、Webpack設定確認 |
| - | ブラウザ起動失敗 | Chromiumバイナリ不足 | playwright installを実行 |
| - | タイムアウト | テスト実行がタイムアウトした場合 | リソース確認、テスト内容見直し |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | CIでのrun-tests.js経由: デフォルト2回 |
| リトライ間隔 | 即座 |
| リトライ対象エラー | テスト失敗（フレーキーテスト対策） |

### 障害時対応

テスト失敗時はJestの出力から失敗箇所を確認する。Turbopack版（test-dev-turbo）では成功するがWebpack版で失敗する場合は、Webpack固有の動作に起因する可能性がある。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数十〜数百テストスイート |
| 目標処理時間 | 60分以内（CI全体） |
| メモリ使用量上限 | 4096MB |

## 排他制御

並列実行時はポート番号の重複に注意が必要。テストフレームワーク側でランダムポートを割り当てることで衝突を回避している。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | テスト開始時 | テスト設定情報（モード: dev、バンドラー: Webpack） |
| 進捗ログ | 各テストスイート実行時 | PASS/FAILステータスとファイル名 |
| 終了ログ | 全テスト完了時 | サマリー（テスト数、成功数、失敗数、実行時間） |
| エラーログ | テスト失敗時 | 失敗テスト名、期待値/実際値の差分 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| テスト失敗数 | 1件以上 | CI（GitHub Actions） |
| 実行時間 | 90分 | CI |

## 備考

- 実行コマンドチェーン: `cross-env IS_WEBPACK_TEST=1` → `cross-env NEXT_TEST_MODE=dev` → `cross-env HEADLESS=true jest --runInBand`
- package.json定義: `"test-dev-webpack": "pnpm run with-webpack pnpm test-dev-inner"`
- `with-webpack`: `cross-env IS_WEBPACK_TEST=1`
- `test-dev-inner`: `cross-env NEXT_TEST_MODE=dev pnpm testheadless`
- `test-dev` のデフォルトは `test-dev-webpack` である（`"test-dev": "pnpm run test-dev-webpack"`）
