# バッチ設計書 17-test-start-webpack

## 概要

本ドキュメントは、Next.jsプロジェクトにおけるWebpackプロダクションモードテスト実行バッチ `test-start-webpack` の設計仕様を定義する。

### 本バッチの処理概要

Webpackバンドラーを使用したプロダクションビルド+サーバー起動モード（start mode）でNext.jsの統合テスト・E2Eテストを実行するバッチである。

**業務上の目的・背景**：Next.jsのプロダクション環境でWebpackを使用した場合の動作を検証する。プロダクションビルド（`next build`）と本番サーバー起動（`next start`）を組み合わせた実際のデプロイシナリオに近い条件でテストを行い、最適化処理（Tree Shaking、コード分割、Minification等）後の正確な動作を保証する。開発モードテスト（No.16 test-dev-webpack）では検出できないプロダクション固有の問題を検出する。

**バッチの実行タイミング**：CIパイプラインでPR・コミット時に自動実行される。ローカル開発でも手動実行可能。

**主要な処理内容**：
1. 環境変数 `IS_WEBPACK_TEST=1` を設定してWebpackモードを指定する
2. `NEXT_TEST_MODE=start` を設定してプロダクション起動モードテストを指定する
3. `HEADLESS=true` でヘッドレスブラウザモードを有効化する
4. 各テストでNext.jsアプリケーションをWebpackでビルドし、プロダクションサーバーを起動してテストする
5. テスト対象はプロダクション関連テスト（`test/e2e/`、`test/production/`、`test/integration/`）

**前後の処理との関連**：開発モードテスト（No.16 test-dev-webpack）とともにWebpackの全面的な検証を構成する。Turbopack版の同等バッチは `test-start-turbo`（No.15）。`test-start` のデフォルトは本バッチ（test-start-webpack）である。

**影響範囲**：テスト実行のみ。各テスト内でプロダクションビルドとサーバー起動が行われるため、ディスクI/Oとメモリ使用量が開発モードテストより多い。

## バッチ種別

テスト実行

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（PR/コミット時） |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | CI自動実行 / 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| 依存パッケージインストール済み | `pnpm install` が完了していること |
| Next.jsビルド済み | `pnpm build` が完了し、`packages/next/dist/` が生成されていること |
| Playwright/ブラウザインストール済み | ヘッドレスブラウザ（Chromium）が利用可能であること |

### 実行可否判定

Next.jsのビルド成果物が存在し、テスト対象ファイルが存在すること。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| テストパス | string[] | No | 全テスト | 特定のテストファイル/ディレクトリを指定可能 |
| -t | string | No | なし | テスト名パターンによるフィルタリング |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| テストファイル群 | TypeScript/JavaScript | `test/e2e/`、`test/production/`、`test/integration/` 配下のテストファイル |
| テストフィクスチャ | 各種 | テスト用のNext.jsアプリケーションファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | Jestテスト結果サマリー |
| JUnitレポート | XML | CI環境でのテスト結果レポート |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | CI環境設定に依存 |
| 出力先 | CIアーティファクト |
| 文字コード | UTF-8 |
| 区切り文字 | なし |

## 処理フロー

### 処理シーケンス

```
1. 環境変数設定
   └─ IS_WEBPACK_TEST=1, NEXT_TEST_MODE=start, HEADLESS=true
2. テストファイル検出
   └─ 指定パスまたは全テストディレクトリからテストファイルを検出
3. テストスイート実行ループ
   └─ 各テストファイルに対して以下を繰り返す
4. Next.jsプロダクションビルド（各テスト内）
   └─ テストフィクスチャのNext.jsアプリをWebpackでビルド
5. プロダクションサーバー起動
   └─ next startでサーバーを起動
6. ブラウザテスト実行
   └─ ヘッドレスChromiumでページアクセス・DOM検証
7. クリーンアップ
   └─ サーバー停止、ビルド成果物・一時ファイル削除
8. 結果レポート
   └─ 成功/失敗/スキップの件数をサマリーとして出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[環境変数設定]
    B --> C[テストファイル検出]
    C --> D{テストファイルあり?}
    D -->|あり| E[テストスイート実行ループ]
    D -->|なし| F[0件で正常終了]
    E --> G[Next.jsプロダクションビルド<br/>Webpackモード]
    G --> H[next startサーバー起動]
    H --> I[ヘッドレスブラウザテスト]
    I --> J[アサーション検証]
    J --> K[サーバー停止・クリーンアップ]
    K --> L{次のテストあり?}
    L -->|Yes| E
    L -->|No| M[結果集計]
    M --> N{全テスト成功?}
    N -->|Yes| O[終了コード0で終了]
    N -->|No| P[終了コード1で終了]
    F --> O
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| なし | - | - | データベース操作は行わない |

### テーブル別操作詳細

本バッチはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 終了コード1 | テスト失敗 | 1つ以上のテストが失敗した場合 | 失敗テストの内容を確認し修正 |
| - | ビルド失敗 | Webpackビルドがエラーとなった場合 | ビルドエラーログ、Webpack設定を確認 |
| - | サーバー起動失敗 | ポート競合やランタイムエラー | ポート使用状況確認 |
| - | タイムアウト | ビルドまたはテスト実行がタイムアウト | リソース確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | CIでのrun-tests.js経由: デフォルト2回 |
| リトライ間隔 | 即座 |
| リトライ対象エラー | テスト失敗（フレーキーテスト対策） |

### 障害時対応

ビルド失敗時はWebpackのビルドログを確認する。開発モード（test-dev-webpack）では成功するが start モードで失敗する場合は、プロダクション最適化に起因する可能性がある。Turbopack版（test-start-turbo）との結果比較でバンドラー固有の問題を切り分ける。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数十〜数百テストスイート |
| 目標処理時間 | 90分以内（CI全体） |
| メモリ使用量上限 | 4096MB |

## 排他制御

並列実行時はポート番号の重複に注意が必要。テストフレームワーク側でランダムポートを割り当てることで衝突を回避している。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | テスト開始時 | テスト設定情報（モード: start、バンドラー: Webpack） |
| 進捗ログ | 各テストスイート実行時 | PASS/FAILステータスとファイル名 |
| 終了ログ | 全テスト完了時 | サマリー（テスト数、成功数、失敗数、実行時間） |
| エラーログ | テスト失敗時 | ビルドログ、サーバーログ、失敗テスト詳細 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| テスト失敗数 | 1件以上 | CI（GitHub Actions） |
| 実行時間 | 120分 | CI |

## 備考

- 実行コマンドチェーン: `cross-env IS_WEBPACK_TEST=1` → `cross-env NEXT_TEST_MODE=start` → `cross-env HEADLESS=true jest --runInBand`
- package.json定義: `"test-start-webpack": "pnpm run with-webpack pnpm run test-start-inner"`
- `test-start-inner`: `cross-env NEXT_TEST_MODE=start pnpm testheadless`
- `test-start` のデフォルトは本バッチ（`"test-start": "pnpm run test-start-webpack"`）
- Webpackベースのプロダクションビルドは成熟しており、Turbopackビルドよりもテストカバレッジが広い場合がある
