# バッチ設計書 18-test-deploy

## 概要

本ドキュメントは、Next.jsプロジェクトにおけるデプロイモードテスト実行バッチ `test-deploy` の設計仕様を定義する。

### 本バッチの処理概要

デプロイモード（deploy mode）でNext.jsの統合テスト・E2Eテストを実行するバッチである。実際のデプロイ環境に近い条件でテストを行い、Webpack/Turbopackの両方のバンドラーを選択可能。

**業務上の目的・背景**：Next.jsアプリケーションが実際にデプロイされた環境で正しく動作するかを検証する。開発モード（dev）やプロダクション起動モード（start）ではカバーできないデプロイ固有の問題（例：CDN経由のアセット配信、サーバーレス関数の動作、エッジランタイム等）を検出する。デプロイテストマニフェスト（`test/deploy-tests-manifest.json`）による外部テストフィルタをサポートする。

**バッチの実行タイミング**：CIパイプラインで特定の条件下（デプロイ関連の変更があるPR等）で自動実行される。ローカル開発でも手動実行可能。

**主要な処理内容**：
1. `NEXT_TEST_MODE=deploy` を設定してデプロイモードテストを指定する
2. Webpack版（デフォルト）: `IS_WEBPACK_TEST=1`、Turbopack版: `IS_TURBOPACK_TEST=1 TURBOPACK_BUILD=1` を設定する
3. `HEADLESS=true` でヘッドレスブラウザモードを有効化する
4. デプロイテストマニフェストによるテストフィルタリングを適用する
5. 各テストでデプロイ環境に近い条件でテストを実行する

**前後の処理との関連**：デプロイテスト用のtarball生成（No.9 create-preview-tarballs）やデプロイURL注入（No.50 inject-deploy-url）が前提処理として必要な場合がある。開発モードテスト（No.14/16）およびプロダクション起動モードテスト（No.15/17）で基本的な動作が確認された後に実行される、最終確認レベルのテストとして位置づけられる。

**影響範囲**：テスト実行のみ。外部デプロイ環境へのアクセスが含まれる場合がある。

## バッチ種別

テスト実行

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（PR/コミット時、デプロイ関連変更時） |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | CI自動実行 / 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| 依存パッケージインストール済み | `pnpm install` が完了していること |
| Next.jsビルド済み | `pnpm build` が完了していること |
| Playwright/ブラウザインストール済み | ヘッドレスブラウザ（Chromium）が利用可能であること |
| デプロイアーティファクト（任意） | デプロイ用tarballが生成済みであること（deploy-tests使用時） |

### 実行可否判定

テスト対象ファイルが存在し、必要に応じてデプロイアーティファクトが利用可能であること。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| テストパス | string[] | No | 全テスト | 特定のテストファイル/ディレクトリを指定可能 |
| NEXT_EXTERNAL_TESTS_FILTERS | string | No | `test/deploy-tests-manifest.json` | 外部テストフィルタマニフェストのパス |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| テストファイル群 | TypeScript/JavaScript | `test/e2e/` 配下のテストファイル |
| deploy-tests-manifest.json | JSON | デプロイテスト用フィルタマニフェスト |
| テストフィクスチャ | 各種 | テスト用のNext.jsアプリケーションファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | Jestテスト結果サマリー |
| JUnitレポート | XML | CI環境でのテスト結果レポート |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | CI環境設定に依存 |
| 出力先 | CIアーティファクト |
| 文字コード | UTF-8 |
| 区切り文字 | なし |

## 処理フロー

### 処理シーケンス

```
1. 環境変数設定
   └─ NEXT_TEST_MODE=deploy, IS_WEBPACK_TEST=1（またはTurbopack環境変数）, HEADLESS=true
2. テストフィルタ適用
   └─ deploy-tests-manifest.jsonによる対象テストのフィルタリング
3. テストファイル検出
   └─ フィルタ適用後のテストファイルを検出
4. テストスイート実行ループ
   └─ 各テストファイルに対して以下を繰り返す
5. デプロイ環境テスト実行
   └─ デプロイモードでのテスト実行（ブラウザテスト含む）
6. クリーンアップ
   └─ 一時ファイル削除
7. 結果レポート
   └─ 成功/失敗/スキップの件数をサマリーとして出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[環境変数設定]
    B --> C[テストフィルタ適用<br/>deploy-tests-manifest.json]
    C --> D[テストファイル検出]
    D --> E{テストファイルあり?}
    E -->|あり| F[テストスイート実行ループ]
    E -->|なし| G[0件で正常終了]
    F --> H[デプロイモードテスト実行]
    H --> I[ヘッドレスブラウザテスト]
    I --> J[アサーション検証]
    J --> K[クリーンアップ]
    K --> L{次のテストあり?}
    L -->|Yes| F
    L -->|No| M[結果集計]
    M --> N{全テスト成功?}
    N -->|Yes| O[終了コード0で終了]
    N -->|No| P[終了コード1で終了]
    G --> O
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| なし | - | - | データベース操作は行わない |

### テーブル別操作詳細

本バッチはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 終了コード1 | テスト失敗 | 1つ以上のテストが失敗した場合 | 失敗テストの内容を確認し修正 |
| - | デプロイ環境接続失敗 | デプロイ先にアクセスできない場合 | ネットワーク接続、デプロイ状態を確認 |
| - | マニフェストエラー | deploy-tests-manifest.jsonの形式が不正 | マニフェストファイルの内容を確認 |
| - | タイムアウト | テスト実行がタイムアウトした場合 | リソース確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | CIでのrun-tests.js経由: デフォルト2回 |
| リトライ間隔 | 即座 |
| リトライ対象エラー | テスト失敗（フレーキーテスト対策） |

### 障害時対応

デプロイ環境への接続問題の場合は、デプロイ先の可用性を確認する。テスト自体の失敗の場合は、dev/startモードでの結果と比較してデプロイ固有の問題かを切り分ける。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数十テストスイート |
| 目標処理時間 | 60分以内（CI全体） |
| メモリ使用量上限 | 4096MB |

## 排他制御

並列実行時はポート番号の重複に注意が必要。デプロイ環境へのアクセスが含まれる場合は、同時アクセス数に注意が必要。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | テスト開始時 | テスト設定情報（モード: deploy） |
| 進捗ログ | 各テストスイート実行時 | PASS/FAILステータスとファイル名 |
| 終了ログ | 全テスト完了時 | サマリー（テスト数、成功数、失敗数、実行時間） |
| エラーログ | テスト失敗時 | 失敗テスト名、デプロイ環境情報 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| テスト失敗数 | 1件以上 | CI（GitHub Actions） |
| 実行時間 | 90分 | CI |

## 備考

- 実行コマンドチェーン（Webpack版）: `cross-env IS_WEBPACK_TEST=1` → `cross-env NEXT_TEST_MODE=deploy` → `cross-env HEADLESS=true jest --runInBand`
- 実行コマンドチェーン（Turbopack版）: `cross-env IS_TURBOPACK_TEST=1 TURBOPACK_BUILD=1` → `cross-env NEXT_TEST_MODE=deploy` → `cross-env HEADLESS=true jest --runInBand`
- package.json定義:
  - `"test-deploy": "pnpm run test-deploy-webpack"`（デフォルトはWebpack）
  - `"test-deploy-webpack": "pnpm run with-webpack pnpm test-deploy-inner"`
  - `"test-deploy-turbo": "cross-env IS_TURBOPACK_TEST=1 TURBOPACK_BUILD=1 pnpm test-deploy-inner"`
  - `"test-deploy-inner": "cross-env NEXT_TEST_MODE=deploy pnpm testheadless"`
